function xls_results_cycles_v6(T, EventMin, EventMax, nZEROS, RSE, confirm, dataFromTable, batch3D, batch2D, TFILower, TFIUpper, Wmin, Wmax)
% loads results xls files and target xls file and creates graphed xls files

numberSequencesInTable = size(dataFromTable,1);
sequenceListInTable = dataFromTable(:,1);
channelsInSequences = dataFromTable(:,2);
dotNumberInSequencesInTable = dataFromTable(:,3);
numImagesInSequenceTimepoint = dataFromTable(:,5);
fullLogFilePathSequencesInTable = dataFromTable(:,6);
numberSequences = 0;
for ind = 1:numberSequencesInTable
    numberSequences = numberSequences + str2num(channelsInSequences{ind});
end
ind_numberSequences = 0;
sequenceList = cell(numberSequences,1);
dotNumberInSequences = cell(numberSequences,1);
fullFilePathSequences = cell(numberSequences,1);
xlsFilePathSequences = cell(numberSequences,1);
numSlicesSequences = cell(numberSequences,1);
for k = 1:numberSequencesInTable
    ind_numberSequences = ind_numberSequences + 1;
    if str2num(channelsInSequences{k}) == 1
        fullFilePathSequences{ind_numberSequences} = strrep(fullLogFilePathSequencesInTable{k},'.log','.tiff');
        sequenceList{ind_numberSequences} = sequenceListInTable{k};
        dotNumberInSequences{ind_numberSequences} = dotNumberInSequencesInTable{k};
        xlsFilePathSequences{ind_numberSequences} = strrep(fullFilePathSequences{ind_numberSequences},'.tiff',['_spot_' dotNumberInSequencesInTable{k} '_results.xls']);
        numSlicesSequences{ind_numberSequences} = numImagesInSequenceTimepoint{k};
    elseif str2num(channelsInSequences{k}) == 2
        logFID = fopen(fullLogFilePathSequencesInTable{k},'r');
        logData = textscan(logFID, '%s', 'delimiter', {'\n','\t'}, 'whitespace', '');
        logStrings = logData{1};
        fclose(logFID);
        indexesIFD = strfind(logStrings, 'IFD');
        indexIFD = find(~cellfun('isempty', indexesIFD), 1);
        channel1File = logStrings{indexIFD+13,:};
        [~, name1] = fileparts(channel1File);
        channel2File = logStrings{indexIFD+20,:};
        [~, name2] = fileparts(channel2File);
        [pathstr] = fileparts(fullLogFilePathSequencesInTable{k});
        fullFilePathSequences{ind_numberSequences} = fullfile(pathstr, channel1File);
        sequenceList{ind_numberSequences} = name1;
        dotNumberInSequences{ind_numberSequences} = dotNumberInSequencesInTable{k};
        xlsFilePathSequences{ind_numberSequences} = strrep(fullFilePathSequences{ind_numberSequences},'.tiff',['_spot_' dotNumberInSequencesInTable{k} '_results.xls']);
        numSlicesSequences{ind_numberSequences} = numImagesInSequenceTimepoint{k};
        ind_numberSequences = ind_numberSequences + 1;
        fullFilePathSequences{ind_numberSequences} = fullfile(pathstr, channel2File);
        sequenceList{ind_numberSequences} = name2;
        dotNumberInSequences{ind_numberSequences} = dotNumberInSequencesInTable{k};
        xlsFilePathSequences{ind_numberSequences} = strrep(fullFilePathSequences{ind_numberSequences},'.tiff',['_spot_' dotNumberInSequencesInTable{k} '_results.xls']);
        numSlicesSequences{ind_numberSequences} = numImagesInSequenceTimepoint{k};
    end
end
n = ind_numberSequences;
targetFullFilePath = 'timelapse VOID.xls';
if ~exist(targetFullFilePath,'file')
    warndlg('timelapse VOID.xls file is missing!')
end
h = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
matrixForFile = [];
resultsForFile = [];
sequencesForFile = [];
timeSequencesForFile = [];
for i=1:n
    waitbar(i/n,h,sprintf('File %d of %d',i,n))
    [path, name, ext] = fileparts(xlsFilePathSequences{i});
    stringResults = strfind(name,'_results');
    if ~isempty(stringResults)
        newName = strrep(name,'_results','_events');
        tableName = strrep(name,'_results','');
    end
    fullFilePath = xlsFilePathSequences{i};
    tiffFilePath = fullFilePathSequences{i};
    numSlices = numSlicesSequences{i};
    if exist(fullFilePath,'file')
        [num] = xlsread(fullFilePath);
        size(num,1);
        newFullFilePath = fullfile(path,[newName ext]);
        timeSequence = zeros(1,size(num,1));
        tfiSequence = zeros(1,size(num,1));
        wSequence = zeros(1,size(num,1));
        xSequence = zeros(1,size(num,1));
        ySequence = zeros(1,size(num,1));
        zSequence = zeros(1,size(num,1));
        for j = 1:size(num,1)
            if ~isnan(num(j,1))
                timeSequence(num(j,1)) = num(j,1);
                tfiSequence(num(j,1)) = num(j,2);
                wSequence(num(j,1)) = num(j,3);
                xSequence(num(j,1)) = num(j,6);
                ySequence(num(j,1)) = num(j,7);
                zSequence(num(j,1)) = num(j,8);
            end
        end
        num_time=length(timeSequence);
        timepoints = find(timeSequence ~= 0);
        timepointsForFile = NaN(num_time,1);
        tfiForFile = NaN(num_time,1);
        wForFile = NaN(num_time,1);
        xForFile = NaN(num_time,1);
        yForFile = NaN(num_time,1);
        zForFile = NaN(num_time,1);
        for k = 1:length(timepoints)
            timepointsForFile(timepoints(k)) = timepoints(k);
            tfiForFile(timepoints(k)) = tfiSequence(timepoints(k));
            wForFile(timepoints(k)) = wSequence(timepoints(k));
            xForFile(timepoints(k)) = xSequence(timepoints(k));
            yForFile(timepoints(k)) = ySequence(timepoints(k));
            zForFile(timepoints(k)) = zSequence(timepoints(k));
        end
        [results, tfiSelectedALL, timeSequences, tfiSequences] = extract_all_cycles_v6(T, tfiForFile, wForFile, xForFile, yForFile, zForFile, EventMin, EventMax, nZEROS, RSE, tiffFilePath, fullFilePath, batch3D, batch2D, numSlices, TFILower, TFIUpper, Wmin, Wmax);
        if ~isnan(max(tfiSelectedALL))
            copyfile(targetFullFilePath,newFullFilePath,'f');
            xlswrite(newFullFilePath,[timepointsForFile tfiForFile tfiSelectedALL],'Sheet1','A2');
            xlswrite(newFullFilePath,T,'Sheet1','H2')
        end
        newMatrix = cell(size(results,1),5);
        newResults = NaN(size(results,1),4);
        newSequences = NaN(size(tfiSequences,1),EventMax+nZEROS*2);
        newTimeSequences = NaN(size(tfiSequences,1),EventMax+nZEROS*2);
        if ~isempty(results)
            for m = 1:size(results,1)
                newMatrix(m,1) = {path};
                newMatrix(m,2) = {tableName};
                newMatrix(m,3) = {num2str(results(m,1))};
                newMatrix(m,4) = {num2str(results(m,2))};
                newMatrix(m,5) = {num2str(results(m,3))};
            end
            newResults = results;
            newSequences = tfiSequences;
            newTimeSequences = timeSequences;
            matrixForFile = [matrixForFile; newMatrix];
            resultsForFile = [resultsForFile; newResults];
            sequencesForFile = [sequencesForFile; newSequences];
            timeSequencesForFile = [timeSequencesForFile; newTimeSequences];
        end
    end
end
close(h)
if confirm == 1 && ~isempty(resultsForFile)
    hc = waitbar(0,'Initializing waitbar...','Position',[400,100,280,50]);
    hps = figure('Name','Single Event Detection','Toolbar','none',...
        'Menubar','none','Position',[570,250,300,250]);
    rowsToBeDeleted = [];
    rowsToBeRedone = (1:size(sequencesForFile,1))';
    for l = 1:size(sequencesForFile,1)
        waitbar(l/size(sequencesForFile,1),hc,sprintf('Event %d of %d',l,size(sequencesForFile,1)))
        figure(hps)
        plot(sequencesForFile(l,:),':ko',...
            'LineWidth',3,'MarkerEdgeColor','k','MarkerFaceColor','r',...
            'MarkerSize',8);
        xlabel('Timepoint');
        ylabel('TFI');
        if nZEROS == 0
            EventMax = length(sequencesForFile(1,:));
        end
        axis([0 (EventMax+2*nZEROS) 0 (max(sequencesForFile(l,:))+1)]);
        reply = questdlg('Single Event OK?','User Confirmation','Yes','No','Yes');
        if(strcmp(reply,'No') == 1)
            rowsToBeDeleted = [rowsToBeDeleted, l];
        end
    end
    close(hc)
    close(hps)
    if ~isempty(rowsToBeDeleted)
        rowsToBeRedone(rowsToBeDeleted,:) = [];
        filesToBeDeleted = {};
        h2 = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
        index_ftd = 1;
        for k =1:length(rowsToBeDeleted)
            waitbar(k/length(rowsToBeDeleted),h2,sprintf('Cleaning File %d of %d',k,length(rowsToBeDeleted)))
            fileToClean = fullfile(matrixForFile{rowsToBeDeleted(k),1},[matrixForFile{rowsToBeDeleted(k),2} '_events' ext]);
            timepointList = timeSequencesForFile(rowsToBeDeleted(k),:);
            timepointsToNaN = timepointList(~isnan(timepointList))/T + 1;
            for n = 1:length(timepointsToNaN)
                filesToBeDeleted{index_ftd} = fullfile(matrixForFile{rowsToBeDeleted(k),1},[matrixForFile{rowsToBeDeleted(k),2} '_results' ' - ' num2str(timepointsToNaN(n)) '.tif']);
                index_ftd = index_ftd + 1;
            end
            xlswrite(fileToClean,NaN(length(timepointsToNaN),1),'Sheet1',['C' num2str(timepointsToNaN(1)+1)]);
        end
        close(h2)
        h3 = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
        filesToBeKept = {};
        index_ftk = 1;
        for r =1:length(rowsToBeRedone)
            waitbar(r/length(rowsToBeRedone),h3,sprintf('Updating File %d of %d',r,length(rowsToBeRedone)))
            fileToUpdate = fullfile(matrixForFile{rowsToBeRedone(r),1},[matrixForFile{rowsToBeRedone(r),2} '_events' ext]);
            timepointList = timeSequencesForFile(rowsToBeRedone(r),:);
            sequenceList = sequencesForFile(rowsToBeRedone(r),:);
            timepointsToUpdate = timepointList(~isnan(timepointList))/T + 1;
            for n = 1:length(timepointsToUpdate)
                filesToBeKept{index_ftk} = fullfile(matrixForFile{rowsToBeRedone(r),1},[matrixForFile{rowsToBeRedone(r),2} '_results' ' - ' num2str(timepointsToUpdate(n)) '.tif']);
                index_ftk = index_ftk + 1;
            end
            sequenceToUpdate = sequenceList(~isnan(sequenceList));
            xlswrite(fileToUpdate,sequenceToUpdate','Sheet1',['C' num2str(timepointsToUpdate(1)+1)]);
        end
        close(h3)
        h4 = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
        filesToBeReallyDeleted = setdiff(filesToBeDeleted, filesToBeKept);
        for w = 1:length(filesToBeReallyDeleted)
            waitbar(w/length(filesToBeReallyDeleted),h4,sprintf('Deleting TIF File %d of %d',w,length(filesToBeReallyDeleted)))
            delete(filesToBeReallyDeleted{w});
        end
        close(h4)
        matrixForFile(rowsToBeDeleted,:) = [];
        resultsForFile(rowsToBeDeleted,:) = [];
    end
end
if ~isempty(resultsForFile)
    [rangeTS, nTS] = hist_dot(resultsForFile(:,1), T, (EventMax+2)*T);
    if size(rangeTS,1) == 1
        rangeTS = rangeTS';
    end
    if size(nTS,1) == 1
        nTS = nTS';
    end
    [rangeLT, nLT] = hist_dot(resultsForFile(:,2), T, (EventMax+2)*T);
    if size(rangeLT,1) == 1
        rangeLT = rangeLT';
    end
    if size(nLT,1) == 1
        nLT = nLT';
    end
    [rangeTFI, nTFI] = hist_dot(resultsForFile(:,3), 100, 1000);
    if size(rangeTFI,1) == 1
        rangeTFI = rangeTFI';
    end
    if size(nTFI,1) == 1
        nTFI = nTFI';
    end
    [targetFilename, targetPathname] = uiputfile('*.xls','Write results to file');
    if exist(fullfile(targetPathname,targetFilename),'file')
        delete(fullfile(targetPathname,targetFilename))
    end
    xlswrite(fullfile(targetPathname,targetFilename),{'Path','Filename', 'Time of Synthesis', 'Lifetime', 'TFI','Bin TS', 'hist TS', 'Bin LT', 'hist LT', 'Bin TFI', 'hist TFI'},'Sheet1','A1');
    xlswrite(fullfile(targetPathname,targetFilename),matrixForFile,'Sheet1','A2');
    xlswrite(fullfile(targetPathname,targetFilename),[rangeTS nTS rangeLT nLT],'Sheet1','F2');
    xlswrite(fullfile(targetPathname,targetFilename),[rangeTFI nTFI],'Sheet1','J2');
    warndlg('All Done!')
else
    warndlg('No Cycles!')
end