function interfaceImage3D_timelapse_batch_2channels_v5(dataFromTable,pSizeBatch)

numberSequencesInTable = size(dataFromTable,1);
sequenceListInTable = dataFromTable(:,1);
channelsInSequences = dataFromTable(:,2);
dotNumberInSequencesInTable = dataFromTable(:,3);
numberImagesInSequencesInTable = dataFromTable(:,4);
numImagesInSequenceTimepointInTable = dataFromTable(:,5);
fullLogFilePathSequencesInTable = dataFromTable(:,6);
numberSequences = 0;
for ind = 1:numberSequencesInTable
    numberSequences = numberSequences + str2num(channelsInSequences{ind});
end
ind_numberSequences = 0;
sequenceList = cell(numberSequences,1);
dotNumberInSequences = cell(numberSequences,1);
numberImagesInSequences = cell(numberSequences,1);
numImagesInSequenceTimepoint = cell(numberSequences,1);
fullFilePathSequences = cell(numberSequences,1);
for k = 1:numberSequencesInTable
    ind_numberSequences = ind_numberSequences + 1;
    if str2num(channelsInSequences{k}) == 1
        fullFilePathSequences{ind_numberSequences} = strrep(fullLogFilePathSequencesInTable{k},'.log','.tiff');
        sequenceList{ind_numberSequences} = sequenceListInTable{k};
        dotNumberInSequences{ind_numberSequences} = dotNumberInSequencesInTable{k};
        numberImagesInSequences{ind_numberSequences} = numberImagesInSequencesInTable{k};
        numImagesInSequenceTimepoint{ind_numberSequences} = numImagesInSequenceTimepointInTable{k};
    elseif str2num(channelsInSequences{k}) == 2
        logFID = fopen(fullLogFilePathSequencesInTable{k},'r');
        logData = textscan(logFID, '%s', 'delimiter', {'\n','\t'}, 'whitespace', '');
        logStrings = logData{1};
        fclose(logFID);
        indexesIFD = strfind(logStrings, 'IFD');
        indexIFD = find(~cellfun('isempty', indexesIFD), 1);
        channel1Name = logStrings{indexIFD+12,:};
        channel1File = logStrings{indexIFD+13,:};
        [~, name1] = fileparts(channel1File);
        channel2Name = logStrings{indexIFD+19,:};
        channel2File = logStrings{indexIFD+20,:};
        [~, name2] = fileparts(channel2File);
        [pathstr] = fileparts(fullLogFilePathSequencesInTable{k});
        fullFilePathSequences{ind_numberSequences} = fullfile(pathstr, channel1File);
        sequenceList{ind_numberSequences} = name1;
        dotNumberInSequences{ind_numberSequences} = dotNumberInSequencesInTable{k};
        numberImagesInSequences{ind_numberSequences} = numberImagesInSequencesInTable{k};
        numImagesInSequenceTimepoint{ind_numberSequences} = numImagesInSequenceTimepointInTable{k};
        ind_numberSequences = ind_numberSequences + 1;
        fullFilePathSequences{ind_numberSequences} = fullfile(pathstr, channel2File);
        sequenceList{ind_numberSequences} = name2;
        dotNumberInSequences{ind_numberSequences} = dotNumberInSequencesInTable{k};
        numberImagesInSequences{ind_numberSequences} = numberImagesInSequencesInTable{k};
        numImagesInSequenceTimepoint{ind_numberSequences} = numImagesInSequenceTimepointInTable{k};
    end
end
xDimensionList = zeros(numberSequences);
yDimensionList = zeros(numberSequences);
n = 0;
for k = 1:numberSequences
    infoSequences = imfinfo(fullFilePathSequences{k});
    xDimensionList(k) = infoSequences.Width;
    yDimensionList(k) = infoSequences.Height;
    n = n + str2num(numberImagesInSequences{k});
end
maxDimension = max(max(max(xDimensionList),max(yDimensionList)));
hseq = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
himages = waitbar(0,'Initializing waitbar...','Position',[400,100,280,50]);
TimepointInfoTable = cell(n,5);
S_proj = zeros(maxDimension, maxDimension, n);
S_proj_min = 2^12;
iForS_proj = 1;
for l = 1:numberSequences
    waitbar(l/numberSequences,hseq,sprintf('Loading sequence %d of %d',l,numberSequences))
    [pathstrSeq, ~, extSeq] = fileparts(fullFilePathSequences{l});
    infoSequence = imfinfo(fullFilePathSequences{l});
    yDim = infoSequence.Height;
    xDim = infoSequence.Width;
    for m = 1:str2num(numberImagesInSequences{l})
        waitbar(m/str2num(numberImagesInSequences{l}),himages,sprintf('Loading z-stack from timepoint %d of %d',m,str2num(numberImagesInSequences{l})))
        S = zeros(yDim, xDim, str2num(numImagesInSequenceTimepoint{l}));
        for q = 1:str2num(numImagesInSequenceTimepoint{l})
            S(:,:,q) = imread(fullfile(pathstrSeq, [sequenceList{l} extSeq]),(m-1)*str2num(numImagesInSequenceTimepoint{l})+q, 'Info', infoSequence);
        end
        S_proj_temp = max(S, [], 3);
        S_proj_min = min(S_proj_min,min(min(S_proj_temp)));
        S_proj(1:yDim,1:xDim,iForS_proj) = S_proj_temp;
        TimepointInfoTable(iForS_proj,1) = fullFilePathSequences(l);
        TimepointInfoTable(iForS_proj,2) = sequenceList(l);
        TimepointInfoTable(iForS_proj,3) = {num2str(m)};
        TimepointInfoTable(iForS_proj,4) = dotNumberInSequences(l);
        TimepointInfoTable(iForS_proj,5) = numImagesInSequenceTimepoint(l);
        iForS_proj = iForS_proj + 1;
    end
end

slice2range = zeros(n,2);
TimepointsRange = zeros(numberSequences,2);
TimepointsRange(1,1) = 1;
TimepointsRange(1,2) = str2num(numberImagesInSequences{1});
slice2range(1:str2num(numberImagesInSequences{1}),1) = TimepointsRange(1,1);
slice2range(1:str2num(numberImagesInSequences{1}),2) = TimepointsRange(1,2);
if numberSequences > 1
    for g = 2:numberSequences
        TimepointsRange(g,1) = TimepointsRange(g-1,2)+1;
        TimepointsRange(g,2) = TimepointsRange(g-1,2)+str2num(numberImagesInSequences{g});
        slice2range(TimepointsRange(g,1):TimepointsRange(g,2),1) = TimepointsRange(g,1);
        slice2range(TimepointsRange(g,1):TimepointsRange(g,2),2) = TimepointsRange(g,2);
    end
end
xList = zeros(1,n);
yList = zeros(1,n);
tfiSequence = NaN(1,n);
wSequence = NaN(1,n);
iminSequence = NaN(1,n);
imaxSequence = NaN(1,n);
gM1Sequence = NaN(1,n);
gM2Sequence = NaN(1,n);
gM3Sequence = NaN(1,n);
gM4Sequence = NaN(1,n);
gM5Sequence = NaN(1,n);
gM6Sequence = NaN(1,n);
zSequence = NaN(1,n);
rSequence = zeros(1,n);
rfSequence = zeros(1,n);
filterSequence = NaN(1,n);
close(hseq)
close(himages)

sizeImg = size(S_proj);
minImg = double(S_proj_min);
maxImg = max(max(max(S_proj)));
minSlice = 1;
if numel(sizeImg) == 3
    maxSlice = sizeImg(3);
else
    maxSlice = 1;
end
startSlice = 1;

S_proj_clean = S_proj;

% Create a figure for TFI Plot
hpp = figure('Name','TFI Plot over time','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,100,400,125]);

% Create a figure for Z Plot
hpz = figure('Name','Z Plot over time','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,405,400,100]);
        
% Create a figure for W Plot
hpw = figure('Name','W Plot over time','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,265,400,100]);

% Create a figure for zoomed image on brightest plane
hpzoom = figure('Name','Z','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,545,161,185]);        

% Create a figure for Gaussian Fit
hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure',...
            'Menubar','none','Position',[1116,545,221,185]);     
hpgaussbuttons = findall(hpgauss);
hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(hpgaussbutton1,'Visible','Off')
set(hpgaussbutton2,'Visible','Off')
set(hpgaussbutton4,'Visible','Off')
set(hpgaussbutton5,'Visible','Off')
set(hpgaussbutton7,'Visible','Off')
set(hpgaussbutton8,'Visible','Off')
set(hpgaussbutton9,'Visible','Off')
set(hpgaussbutton10,'Visible','Off')
set(hpgaussbutton11,'Visible','Off')
set(hpgaussbutton12,'Visible','Off')
set(hpgaussbutton13,'Visible','Off')
        
% Create a figure without toolbar and menubar
hfig = figure('Toolbar','figure',...
    'Menubar','none',...
    'Name','Max Projection Timelapse Viewer - 3D',...
    'Position',[20,100,900,630],...
    'NumberTitle','off',...
    'IntegerHandle','off');
hfigbuttons = findall(hfig);
button1 = findall(hfigbuttons,'ToolTipString','New Figure');
button2 = findall(hfigbuttons,'ToolTipString','Open File');
button3 = findall(hfigbuttons,'ToolTipString','Save Figure');
button4 = findall(hfigbuttons,'ToolTipString','Print Figure');
button5 = findall(hfigbuttons,'ToolTipString','Edit Plot');
button6 = findall(hfigbuttons,'ToolTipString','Rotate 3D');
button7 = findall(hfigbuttons,'ToolTipString','Data Cursor');
button8 = findall(hfigbuttons,'ToolTipString','Brush/Select Data');
button9 = findall(hfigbuttons,'ToolTipString','Link Plot');
button10 = findall(hfigbuttons,'ToolTipString','Insert Colorbar');
button11 = findall(hfigbuttons,'ToolTipString','Insert Legend');
button12 = findall(hfigbuttons,'ToolTipString','Hide Plot Tools');
button13 = findall(hfigbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(button1,'Visible','Off')
set(button2,'Visible','Off')
set(button3,'Visible','Off')
set(button4,'Visible','Off')
set(button5,'Visible','Off')
set(button6,'Visible','Off')
set(button7,'Visible','Off')
set(button8,'Visible','Off')
set(button9,'Visible','Off')
set(button10,'Visible','Off')
set(button11,'Visible','Off')
set(button12,'Visible','Off')
set(button13,'Visible','Off')

hpanel1 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Spot Tracking',...
    'Clipping','on',...
    'Position',[10 12 30 6.69230769230769]);

htextR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 2.69230769230769 17.2 1.84615384615385],...
'String','Search Radius',...
'Style','text',...
'Tag','text4');

hinputR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 3.07692307692308 5.4 1.53846153846154],...
'String','6',...
'Style','edit',...
'Tag','inputR',...
'Callback',@inputR_Callback);

htextS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.3 0.466153846153846 17.4 1.85615384615385],...
'String','Sensitivity ',...
'Style','text',...
'Tag','text5');

hinputS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 1.015384615384615 5.4 1.43846153846154],...
'String','10',...
'Style','edit',...
'Tag','inputStdmeanratio',...
'Callback',@inputStdmeanratio_Callback);

hpanel2 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Gaussian Fitting',...
    'Clipping','on',...
    'Position',[146 36 30 10]);

htextFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 5.19230769230769 17.2 1.84615384615385],...
'String','PSF FWHM',...
'Style','text',...
'Tag','textRf');

hinputFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 5.68692307692308 7.4 1.53846153846154],...
'String','0.500',...
'Style','edit',...
'Tag','inputRf',...
'Callback',@inputFWHM_Callback);

htextRf = uicontrol(...
    'Parent',hpanel2,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'HorizontalAlignment','right',...
    'Position',[1.6 2.89230769230769 17.2 1.84615384615385],...
    'String','Grid Size',...
    'Style','text',...
    'Tag','textRf');

hinputRf = uicontrol(...
    'Parent',hpanel2,...
    'Units','characters',...
    'FontUnits','pixels',...
    'BackgroundColor',[1 1 1],...
    'FontSize',10.6666666666667,...
    'Position',[20 3.37692307692308 5.4 1.53846153846154],...
    'String','6',...
    'Style','edit',...
    'Tag','inputRf',...
    'Callback',@inputRf_Callback);

htextZset = uicontrol(...
    'Parent',hpanel2,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'HorizontalAlignment','right',...
    'Position',[1.6 0.5 17.2 1.85615384615385],...
    'String','Z slice',...
    'Style','text',...
    'Tag','textZf');

hinputZset = uicontrol(...
    'Parent',hpanel2,...
    'Units','characters',...
    'FontUnits','pixels',...
    'BackgroundColor',[1 1 1],...
    'FontSize',10.6666666666667,...
    'Position',[20 1.07 5.4 1.53846153846154],...
    'String','1',...
    'Style','edit',...
    'Tag','inputZset',...
    'Callback',@inputZset_Callback);

bg = uibuttongroup(hfig,'Units','characters',...
    'Position',[154 33 22 2],...
    'SelectionChangedFcn',@slider3_Callback);          
              
bgMIP = uicontrol(bg,'Style',...
                  'radiobutton',...
                  'String','MIP',...
                  'Position',[5 5 40 15]);
              
bgSlice = uicontrol(bg,'Style','radiobutton',...
                  'String','Slice',...
                  'Position',[55 5 50 15]);

slider1 = uicontrol(hfig,'Style','slider',...
    'Min',minSlice,'Max',maxSlice,...
    'Position',[20,30,185,20],...
    'SliderStep',[1/(maxSlice-minSlice) 5/(maxSlice-minSlice)],...
    'Callback',@slider1_Callback);

set(slider1,'Value',startSlice);

slider2 = uicontrol(hfig,'Style','slider',...
    'Min',minImg,'Max',maxImg,...
    'Position',[20,60,20,185],...
    'SliderStep',[10/(maxImg-minImg) 50/(maxImg-minImg)],...
    'Callback',@slider2_Callback);

set(slider2,'Value',maxImg);

zPlanes = str2num(TimepointInfoTable{startSlice,5});
        
slider3 = uicontrol(hfig,'Style','slider',...
    'Min',1,'Max',zPlanes,...
    'Position',[738,370,20,80],...
    'SliderStep',[1/(zPlanes-1) 1/(zPlanes-1)],...
    'Callback',@slider3_Callback);

set(slider3,'Value',1);

slice = round(get(slider1,'Value'));

newMax = round(get(slider2,'Value'));

plotinfo.s1 = uicontrol(hfig,'Style','text',...
    'String','Frame',...
    'Position',[135,50,48,20]);

plotinfo.s2 = uicontrol(hfig,'Style','text',...
    'String',num2str(slice),...
    'Position',[175,50,30,20]);

plotinfo.s3 = uicontrol(hfig,'Style','text',...
    'String','MAX',...
    'Position',[15,245,30,20]);

plotinfo.s4 = uicontrol(hfig,'Style','text',...
    'String',strcat(TimepointInfoTable(slice,2),'_spot_',TimepointInfoTable(slice,4)),...
    'FontSize',10,'FontWeight','bold',...
    'HorizontalAlignment','center',...
    'Position',[220,28,500,20]);

plotinfo.s5 = uicontrol(hfig,'Style','text',...
    'String','Timepoint',...
    'Position',[210,28,48,20]);

plotinfo.s6 = uicontrol(hfig,'Style','text',...
    'String',TimepointInfoTable(slice,3),...
    'HorizontalAlignment','center',...
    'Position',[260,28,20,20]);

plotinfo.s7 = uicontrol(hfig,'Style','text',...
    'String','Z',...
    'HorizontalAlignment','center',...
    'Position',[738,452,20,16]);

checkTrack = uicontrol('Style', 'checkbox',...
    'Position',[110 255 86 30],...
    'FontSize',10,...
    'String','Track Spot',...
    'Value',1);

checkFilter = uicontrol('Style', 'checkbox',...
    'Position',[55 255 50 30],...
    'FontSize',10,...
    'String','Filter',...
    'Value',1);

checkGraph = uicontrol('Style', 'checkbox',...
    'Position',[740 340 150 20],...
    'FontSize',10,...
    'String','Hide Gaussian Fit');

checkZ = uicontrol('Style', 'checkbox',...
    'Position',[740 310 150 20],...
    'FontSize',10,...
    'String','Ignore Z Limits');

plotinfo.sTFI = uicontrol(hfig,'Style','text',...
    'Position',[750,205,120,20],...
    'FontWeight','bold',...
    'FontSize',11,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sI = uicontrol(hfig,'Style','text',...
    'Position',[750,185,120,20],...
    'FontWeight','bold',...
    'FontSize',11,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sZ = uicontrol(hfig,'Style','text',...
    'Position',[750,155,120,20],...
    'FontWeight','bold',...
    'FontSize',10,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sxytitle = uicontrol(hfig,'Style','text',...
    'Position',[40,105,160,40],...
    'String','Click on image to get XY coordinates',...
    'FontWeight','bold',...
    'FontSize',9);

plotinfo.sx = uicontrol(hfig,'Style','text',...
    'Position',[50,85,80,20],...
    'FontSize',10);

plotinfo.sy = uicontrol(hfig,'Style','text',...
    'Position',[120,85,80,20],...
    'FontSize',10);

plotinfo.lasttfi = uicontrol(hfig,'Style','text',...
    'Position',[40,460,160,40],...
    'HorizontalAlignment','left',...
    'FontWeight','bold',...
    'FontSize',10);

plotinfo.slastTFI = uicontrol(hfig,'Style','text',...
    'Position',[40,460,120,20],...
    'FontSize',11,...
    'HorizontalAlignment','left');

plotinfo.slastI = uicontrol(hfig,'Style','text',...
    'Position',[40,440,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',11);

plotinfo.slastZ = uicontrol(hfig,'Style','text',...
    'Position',[40,420,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',10);

plotinfo.nexttfi = uicontrol(hfig,'Style','text',...
    'Position',[40,365,160,40],...
    'HorizontalAlignment','left',...
    'FontWeight','bold',...
    'FontSize',10);

plotinfo.snextTFI = uicontrol(hfig,'Style','text',...
    'Position',[40,365,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',11);

plotinfo.snextI = uicontrol(hfig,'Style','text',...
    'Position',[40,345,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',11);

plotinfo.snextZ = uicontrol(hfig,'Style','text',...
    'Position',[40,325,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',10);

pushSaveXY = uicontrol('Style', 'pushbutton',...
    'Position',[5 550 100 30],...
    'FontWeight','bold',...
    'FontSize',9,...
    'String','Save XY Data',...
    'Callback',@pushSaveXY_Callback);

pushLoad = uicontrol('Style', 'pushbutton',...
    'Position',[105 550 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Load Data',...
    'Callback',@pushLoad_Callback);

pushClear = uicontrol('Style', 'pushbutton',...
    'Position',[5 515 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Clear All',...
    'Callback',@pushClear_Callback);

pushKeepXY = uicontrol('Style', 'pushbutton',...
    'Position',[105 515 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Clear TFI',...
    'Callback',@pushClearTFI_Callback);

pushAutoTrack = uicontrol('Style', 'pushbutton',...
    'Position',[110 285 80 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Track',...
    'Callback',@pushAutoTrack_Callback);

pushAutoDetect = uicontrol('Style', 'pushbutton',...
    'Position',[20 285 90 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Detect',...
    'Callback',@pushAutoDetect_Callback);

pushDot = uicontrol('Style', 'pushbutton',...
    'Position',[760 240 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Gaussian Fit',...
    'Callback',@pushDot_Callback);

pushZero = uicontrol('Style', 'pushbutton',...
    'Position',[738 115 70 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','TFI = 0',...
    'Callback',@pushZero_Callback);

pushNaN = uicontrol('Style', 'pushbutton',...
    'Position',[813 115 70 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Discard',...
    'Callback',@pushNaN_Callback);

pushAUTO = uicontrol('Style', 'pushbutton',...
    'Position',[760 80 100 30],...
    'FontWeight','bold',...
    'FontSize',12,...
    'ForegroundColor',[0 0.498 0],...
    'String','AUTO',...
    'Callback',@pushAUTO_Callback);

pushEXPORTFIGURES = uicontrol('Style', 'pushbutton',...
    'Position',[750 45 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Export Figures',...
    'Callback',@pushEXPORTFIGURES_Callback);

pushREDO2D = uicontrol('Style', 'pushbutton',...
    'Position',[105 585 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','AUTO REDO',...
    'Callback',@pushREDO2D_Callback);

pushLoadAll = uicontrol('Style','pushbutton',...
    'Position',[5 585 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','LOAD ALL',...
    'Callback',@pushLoadAll_Callback);

pushNextSequence = uicontrol('Style', 'pushbutton',...
    'Position',[175 5 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','>>',...
    'Callback',@pushNEXT_Callback);

pushPreviousSequence = uicontrol('Style', 'pushbutton',...
    'Position',[20 5 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','<<',...
    'Callback',@pushPREV_Callback);

pushEND = uicontrol('Style', 'pushbutton',...
    'Position',[750 10 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0.039 0.141 0.416],...
    'String','END Timelapse',...
    'Callback',@pushEND_Callback);

ha = axes('units','pixels','position',[210 59 512 512]);
himage = imshow(S_proj(:,:,round(slice)),...
    'DisplayRange',[minImg round(newMax)],...
    'InitialMagnification',100,'parent',ha);
set(hfig,'WindowButtonMotionFcn',@changepointer)
set(himage,'ButtonDownFcn',@pixelInfo)

    function changepointer(hObj,handles)
        %change pointer to crosshair when hovering himage
        axlim = get(ha,'Position');
        fglim = get(hfig,'Position');
        x1 = axlim(1) + fglim(1);
        x2 = (axlim(1)+axlim(3)) + fglim(1);
        y1 = axlim(2) + fglim(2);
        y2 = (axlim(2)+axlim(4)) + fglim(2);
        pntr = get(0,'PointerLocation');
        if pntr(1)>x1 && pntr(1)<x2 && pntr(2)>y1 && pntr(2)<y2
            set(hfig,'Pointer','crosshair')
        else
            set(hfig,'Pointer','arrow')
        end
    end

    function [x, y, z, detected] = track_xyz(xi,yi,r,stdmeanratio)
        %track (x,y,z) coordinates from (xi,yi) depending on stdmeanratio 
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        B = SforZ(yi-r:yi+r, xi-r:xi+r, :); 
        rf = str2num(get(hinputRf,'String'))/2;
        [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
        sumValues = zeros(num_images,1);
        for m = 1:num_images
            pixelValues = double(sort(reshape(B(:,:,m),1,[]),'descend'));
            sumValues(m) = pixelValues(1) + pixelValues(2) + pixelValues(3) + pixelValues(4);
        end
        z = find(sumValues(:) == max(sumValues),1);
        if ~isempty(pks)
            D = pdist2([xi,yi],pks);
            i_min = find(D == min(D));
            if min(D) <= 2*r && (max(max(std(double(B)))) > mean(mean(mean(double(B))))/stdmeanratio)
                detected = 1;
                x = pks(i_min,1);
                y = pks(i_min,2);
            else
                detected = 0;
                x = xi;
                y = yi;
            end
        else
            detected = 0;
            x = xi;
            y = yi;
        end
    end

    function [x, y, newZ, detected] = track_xynewZ(xi,yi,r,stdmeanratio, newZ)
        %track (x,y,z) coordinates from (xi,yi) depending on stdmeanratio 
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = double(imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+newZ, 'Info', infoString));
        B = SforZ(yi-r:yi+r, xi-r:xi+r); 
        rf = str2num(get(hinputRf,'String'))/2;
        [pks] = dot_detect_MIP(SforZ,rf);
        if ~isempty(pks)
            D = pdist2([xi,yi],pks);
            i_min = find(D == min(D));
            if min(D) <= 2*r && (max(max(std(double(B)))) > mean(mean(mean(double(B))))/stdmeanratio)
                detected = 1;
                x = pks(i_min,1);
                y = pks(i_min,2);
            else
                detected = 0;
                x = xi;
                y = yi;
            end
        else
            detected = 0;
            x = xi;
            y = yi;
        end
    end

    function update_hpp
        figure(hpp)
        plot(tfiSequence(slice2range(slice,1):slice2range(slice,2)),'-bo','LineWidth',1.5,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',4.5);
        hold on;
        plot(slice-slice2range(slice,1)+1,tfiSequence(slice),'o','MarkerSize',6.5,'LineWidth',1.5,'MarkerEdgeColor','r');
        hold off;
        xlabel('Timepoint','FontSize',10);
        ylabel('TFI');
        axis([1 length(tfiSequence(slice2range(slice,1):slice2range(slice,2))) 0 max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))+200]);
        hpp.Renderer = 'painters';
    end

    function update_hpz
        figure(hpz)
        num_images = str2num(TimepointInfoTable{slice,5});
        plot(zSequence(slice2range(slice,1):slice2range(slice,2)),'-ko',...
            'LineWidth',1.5,'MarkerEdgeColor','k','MarkerFaceColor','k',...
            'MarkerSize',3.5);
        hold on;
        plot(slice-slice2range(slice,1)+1,zSequence(slice),'o','MarkerSize',5.5,'LineWidth',1.5,'MarkerEdgeColor','r');
        hold off;
        ylabel('Z');
        axis([1 length(zSequence(slice2range(slice,1):slice2range(slice,2))) 1 num_images]);
        hpz.Renderer = 'painters';
    end

    function update_hpw
        figure(hpw)
        plot(wSequence(slice2range(slice,1):slice2range(slice,2)),'-ko','LineWidth',1.5,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',3.5);
        hold on;
        plot(slice-slice2range(slice,1)+1,wSequence(slice),'o','MarkerSize',5.5,'LineWidth',1.5,'MarkerEdgeColor','r');
        hold off;
        ylabel('W');
        axis([1 length(wSequence(slice2range(slice,1):slice2range(slice,2))) 0 max(wSequence(slice2range(slice,1):slice2range(slice,2)))+0.05]);
        hpw.Renderer = 'painters';
    end

    function update_hpzoom
        figure(hpzoom)
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        singleFrameZoom = SforZ(yList(slice)-rSequence(slice):yList(slice)+rSequence(slice), xList(slice)-rSequence(slice):xList(slice)+rSequence(slice), zSequence(slice));
        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
    end

    function update_hpgauss
        figure(hpgauss)
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        close(hpgauss)
        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);        
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
        B = SforZ(yList(slice)-rfSequence(slice):yList(slice)+rfSequence(slice), xList(slice)-rfSequence(slice):xList(slice)+rfSequence(slice), :); 
        d = double(B(rfSequence(slice)-rfSequence(slice)+1:rfSequence(slice)+rfSequence(slice)+1, rfSequence(slice)-rfSequence(slice)+1:rfSequence(slice)+rfSequence(slice)+1, zSequence(slice)));
        plotgaussfit_in_GUI([gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],d,pSizeBatch,'n');
        axis ([-rfSequence(slice)*pSizeBatch rfSequence(slice)*pSizeBatch -rfSequence(slice)*pSizeBatch rfSequence(slice)*pSizeBatch 0 max(imaxSequence)]);
        caxis ([min(iminSequence) max(imaxSequence)]);
    end

    function update_xy_text
        if (xList(slice) > 0 && yList(slice) > 0)
            set(plotinfo.sx,'String',['X = ' num2str(xList(slice))]);
            set(plotinfo.sy,'String',['Y = ' num2str(yList(slice))]);
        else
            set(plotinfo.sx,'String','');
            set(plotinfo.sy,'String','');
        end
    end

    function update_previous_text
        if ~isnan(tfiSequence(slice-1))
            set(plotinfo.lasttfi,'String','Previous Timepoint');
            set(plotinfo.slastTFI,'String',['TFI = ' num2str(round(tfiSequence(slice-1)))]);
            set(plotinfo.slastI,'String',['W = ' num2str(wSequence(slice-1),3)]);
            set(plotinfo.slastZ,'String',['Z = ' num2str(round(zSequence(slice-1)))]);
        else
            set(plotinfo.lasttfi,'String','');
            set(plotinfo.slastTFI,'String','');
            set(plotinfo.slastI,'String','');
            set(plotinfo.slastZ,'String','');
        end
    end

    function update_next_text
        if ~isnan(tfiSequence(slice+1))
            set(plotinfo.nexttfi,'String','Next Timepoint');
            set(plotinfo.snextTFI,'String',['TFI = ' num2str(round(tfiSequence(slice+1)))]);
            set(plotinfo.snextI,'String',['W = ' num2str(wSequence(slice+1),3)]);
            set(plotinfo.snextZ,'String',['Z = ' num2str(round(zSequence(slice+1)))]);
        else
            set(plotinfo.nexttfi,'String','');
            set(plotinfo.snextTFI,'String','');
            set(plotinfo.snextI,'String','');
            set(plotinfo.snextZ,'String','');
        end
    end

    function clean_hpp
        close(hpp)
        hpp = figure('Name','TFI Plot over time','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,100,400,125]);
    end

    function clean_hpz
        close(hpz)
        hpz = figure('Name','Z Plot over time','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,405,400,100]);
    end

    function clean_hpw
        close(hpw)
        hpw = figure('Name','W Plot over time','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,265,400,100]);
    end

    function clean_hpzoom
        close(hpzoom)
        hpzoom = figure('Name','Z','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,545,161,185]);
    end

    function clean_hpgauss
        close(hpgauss)
        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
    end

    function slider1_Callback(slider1,eventdata,handles)
        % update the displayed image when the slider is adjusted
        bg.SelectedObject = bgMIP;
        slice = round(get(slider1,'Value'));
        a = (minSlice:maxSlice);
        Value1 = slice;
        [~,I] = min(abs(Value1-a));
        Value1 = a(I);
        set(slider1,'Value',Value1);
        slice = round(get(slider1,'Value'));
        set(plotinfo.s2,'String',Value1);
        set(plotinfo.s4,'String',strcat(TimepointInfoTable(slice,2),'_spot_',TimepointInfoTable(slice,4)));
        set(plotinfo.s6,'String',TimepointInfoTable(slice,3));
        if isnan(tfiSequence(slice))
            set(plotinfo.sTFI,'String','');
            set(plotinfo.sI,'String','');
            set(plotinfo.sZ,'String','');
        else
            set(plotinfo.sTFI,'String',['TFI = ' num2str(round(tfiSequence(slice)))]);
            set(plotinfo.sI,'String',['W = ' num2str(wSequence(slice),3)]);
            set(plotinfo.sZ,'String',['Z = ' num2str(round(zSequence(slice)))]);
        end
        if slice > 1 && slice < n
            update_previous_text
            update_next_text
        elseif slice == 1
            set(plotinfo.lasttfi,'String','');
            set(plotinfo.slastTFI,'String','');
            set(plotinfo.slastI,'String','');
            set(plotinfo.slastZ,'String','');
            update_next_text
        elseif slice == n
            update_previous_text
            set(plotinfo.nexttfi,'String','');
            set(plotinfo.snextTFI,'String','');
            set(plotinfo.snextI,'String','');
            set(plotinfo.snextZ,'String','');
        end
        if slice > 1 && get(checkTrack,'Value')
            if xList(slice) == 0 && yList(slice) == 0 && xList(slice-1) > 0 && yList(slice-1) > 0 && slice2range(slice,1) == slice2range(slice-1,1)
                S_proj(:,:,slice) = S_proj_clean(:,:,slice);
                xi = xList(slice-1);
                yi = yList(slice-1);
                if rSequence(slice) == 0 && rSequence(slice-1) > 0
                    r = rSequence(slice-1);
                else
                    r = str2num(get(hinputR,'String'));
                end
                if rfSequence(slice) == 0 || isnan(rfSequence(slice))
                    rf = rfSequence(slice-1);
                else
                    rf = rfSequence(slice);
                end
                stdmeanratio = str2num(get(hinputS,'String'));
                [x, y, z, detected] = track_xyz(xi,yi,r,stdmeanratio);
                fullPathstring = TimepointInfoTable{slice,1};                
                infoString = imfinfo(fullPathstring);
                if (y-r > 0) && (y+r < infoString(1).Height) && (x-r > 0) && (x+r < infoString(1).Height)
                    filterSequence(slice) = detected;
                    xList(slice) = x;
                    yList(slice) = y;
                    zSequence(slice) = z;
                    rSequence(slice) = r;
                    rfSequence(slice) = rf;
                    set(hinputZset,'String',num2str(zSequence(slice)));
                    set(hinputR,'String',num2str(rSequence(slice)));
                    set(hinputRf,'String',num2str(rfSequence(slice)*2));
                    set(plotinfo.sx,'String',['X = ' num2str(x)]);
                    set(plotinfo.sy,'String',['Y = ' num2str(y)]);
                    S_proj(y-r-1:y+r+1, x-r-1, slice) = 2^16;
                    S_proj(y-r-1:y+r+1, x+r+1, slice) = 2^16;
                    S_proj(y-r-1, x-r-1:x+r+1, slice) = 2^16;
                    S_proj(y+r+1, x-r-1:x+r+1, slice) = 2^16;
                else
                    xList(slice) = 0;
                    yList(slice) = 0;
                    zSequence(slice) = NaN;
                end
                if ~isnan(round(max(zSequence(slice2range(slice,1):slice2range(slice,2)))))
                   update_hpz
                end
                figure(hfig);
            else
                update_xy_text
            end
        else
            update_xy_text
        end
        if ~isnan(round(max(zSequence(slice2range(slice,1):slice2range(slice,2)))))
            update_hpz
        else
            clean_hpz
        end
        if ~isnan(zSequence(slice))
            update_hpzoom
        else
            clean_hpzoom
        end
        if ~isnan(round(max(wSequence(slice2range(slice,1):slice2range(slice,2)))))
            update_hpw
        else
            clean_hpw
        end
        if ~isnan(round(max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))))
            update_hpp
        else
            clean_hpp
        end
        if ~isnan(gM1Sequence(slice))
            update_hpgauss
        else
            clean_hpgauss
        end
        figure(hfig);
        zPlanes = str2num(TimepointInfoTable{slice,5});
        set(slider3,'Max',zPlanes);
        set(slider3,'SliderStep',[1/(zPlanes-1) 1/(zPlanes-1)]);
        if ~isnan(zSequence(slice))
            set(hinputZset,'String',num2str(zSequence(slice)));
            set(slider3,'Value',zSequence(slice));
        else
            set(hinputZset,'String','1');
            set(slider3,'Value',1);
        end
        if rSequence(slice) > 0
            set(hinputR,'String',num2str(rSequence(slice)));
        end
        if rfSequence(slice) > 0
            set(hinputRf,'String',num2str(rfSequence(slice)*2));
        end
        himage = imshow(S_proj(:,:,Value1),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        if filterSequence(slice) == 1
            rectangle('Position',[xList(slice)-rSequence(slice),yList(slice)-rSequence(slice),2*rSequence(slice),2*rSequence(slice)],'Curvature',[1,1],'Edgecolor','g');
            drawnow
        else
            rectangle('Position',[xList(slice)-rSequence(slice),yList(slice)-rSequence(slice),2*rSequence(slice),2*rSequence(slice)],'Curvature',[1,1],'Edgecolor','r');
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushNEXT_Callback(pushDot,eventdata,handles)
        bg.SelectedObject = bgMIP;
        slice = round(get(slider1,'Value'));
        if slice2range(slice,2) ~= n
            slice = slice2range(slice,2) + 1;
        end
        set(slider1,'Value',slice);
        slider1_Callback(slider1)
    end

    function pushPREV_Callback(pushDot,eventdata,handles)
        bg.SelectedObject = bgMIP;
        slice = round(get(slider1,'Value'));
        if slice2range(slice,1) ~= 1
            slice = slice2range(slice2range(slice,1) - 1,1);
        end
        if slice2range(slice,1) == 1
            slice = 1;
            set(plotinfo.lasttfi,'String','');
            set(plotinfo.slastTFI,'String','');
            set(plotinfo.slastI,'String','');
            set(plotinfo.slastZ,'String','');
            update_next_text
            if ~isnan(round(max(zSequence(slice2range(slice,1):slice2range(slice,2)))))
                update_hpz
            else
                clean_hpz
            end
            if ~isnan(round(max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))))
                update_hpp
            else
                clean_hpp
            end
            if ~isnan(zSequence(slice))
                update_hpzoom
            else
                clean_hpzoom
            end
            if ~isnan(gM1Sequence(slice))
                update_hpgauss
            else
                clean_hpgauss
            end
            figure(hfig);
        end
        set(slider1,'Value',slice);
        slider1_Callback(slider1)
    end

    function slider2_Callback(slider2,eventdata,handles)
        %adjust image contrast
        newMax = get(slider2,'Value');
        slice = get(slider1,'Value');
        a = (minImg:maxImg);
        Value2 = round(newMax);
        [~,I] = min(abs(Value2-a));
        Value2 = a(I);
        set(slider2,'Value',Value2);
        if ~isnan(zSequence(slice))
            update_hpzoom
        end
        figure(hfig)
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            num_images = str2num(TimepointInfoTable{slice,5});
            fullPathstring = TimepointInfoTable{slice,1};
            SequenceString = TimepointInfoTable{slice,2};
            Timepoint = str2num(TimepointInfoTable{slice,3});
            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
            infoString = imfinfo(fullPathstring);
            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+zSlice, 'Info', infoString);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function slider3_Callback(slider2,eventdata,handles)
        %adjust image contrast
        newZ = floor(get(slider3,'Value'));
        set(slider3,'Value',newZ);
        set(hinputZset,'String',num2str(newZ));
        slice = get(slider1,'Value');
        if xList(slice)~=0
            update_hpzoom
        end
        figure(hfig)
        if strcmp(bg.SelectedObject.String,'MIP')
            if xList(slice)~=0
                slider1_Callback(slider1)
            else
                himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
            end
        elseif strcmp(bg.SelectedObject.String,'Slice')
            num_images = str2num(TimepointInfoTable{slice,5});
            fullPathstring = TimepointInfoTable{slice,1};
            SequenceString = TimepointInfoTable{slice,2};
            Timepoint = str2num(TimepointInfoTable{slice,3});
            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
            infoString = imfinfo(fullPathstring);
            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+newZ, 'Info', infoString);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pixelInfo(hObj,~,~)
        % get coordinates of clicked pixel
        axesHandle  = get(hObj,'Parent');
        cp = get(axesHandle,'CurrentPoint');
        x = cp(1,1);
        y = cp(1,2);
        xi = round(x);
        yi = round(y);
        S_proj(:,:,slice) = S_proj_clean(:,:,slice);
        fullPathstring = TimepointInfoTable{slice,1};
        infoString = imfinfo(fullPathstring);
        if rSequence(slice) == 0
            r = str2num(get(hinputR,'String'));
        else
            r = rSequence(slice);
        end
        if rfSequence(slice) == 0 || isnan(rfSequence(slice))
            rf = str2num(get(hinputRf,'String'))/2;
            rfSequence(slice) = rf;
        else
            rf = rfSequence(slice);
        end
        stdmeanratio = str2num(get(hinputS,'String'));
        newZ = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            [x, y, z, detected] = track_xyz(xi,yi,r,stdmeanratio);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            [x, y, z, detected] = track_xynewZ(xi,yi,r,stdmeanratio,newZ);
        end
        filterSequence(slice) = detected;
        xList(slice) = x;
        yList(slice) = y;
        zSequence(slice) = z;
        rSequence(slice) = r;
        rfSequence(slice) = rf;
        set(hinputZset,'String',num2str(zSequence(slice)));
        set(slider3,'Value',zSequence(slice));
        set(hinputR,'String',num2str(rSequence(slice)));
        set(hinputRf,'String',num2str(rfSequence(slice)*2));
        set(plotinfo.sx,'String',['X = ' num2str(x)]);
        set(plotinfo.sy,'String',['Y = ' num2str(y)]);
        if (y-r > 0) && (y+r < infoString(1).Height) && (x-r > 0) && (x+r < infoString(1).Height)
            S_proj(y-r-1:y+r+1, x-r-1, slice) = 2^16;
            S_proj(y-r-1:y+r+1, x+r+1, slice) = 2^16;
            S_proj(y-r-1, x-r-1:x+r+1, slice) = 2^16;
            S_proj(y+r+1, x-r-1:x+r+1, slice) = 2^16;
        else
            S_proj(yi-r-1:yi+r+1, xi-r-1, slice) = 2^16;
            S_proj(yi-r-1:yi+r+1, xi+r+1, slice) = 2^16;
            S_proj(yi-r-1, xi-r-1:xi+r+1, slice) = 2^16;
            S_proj(yi+r+1, xi-r-1:xi+r+1, slice) = 2^16;
        end
        if ~isnan(round(max(zSequence(slice2range(slice,1):slice2range(slice,2)))))
            update_hpz
        end
        if ~isnan(zSequence(slice))
            update_hpzoom
        end
        figure(hfig);
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100,'parent',ha);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            num_images = str2num(TimepointInfoTable{slice,5});
            fullPathstring = TimepointInfoTable{slice,1};
            SequenceString = TimepointInfoTable{slice,2};
            Timepoint = str2num(TimepointInfoTable{slice,3});
            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
            infoString = imfinfo(fullPathstring);
            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+zSlice, 'Info', infoString);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100,'parent',ha);
        end
        if detected == 1
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','g');
            drawnow
        else
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','r');
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushDot_Callback(pushDot,eventdata,handles)
        %Gaussian Fitting
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        fwhm = str2num(get(hinputFWHM,'String'));
        filterSpot = get(checkFilter,'Value');
        if xList(slice) == 0 && yList(slice) == 0
            warndlg('No XY coordinates for fitting!')
        else
            if (filterSpot == 1) && (filterSequence(slice) == 0)
                pushZero_Callback
            else
                noGraph = get(checkGraph,'Value');
                ignoreZ = get(checkZ,'Value');
                zset = str2num(get(hinputZset,'String'));
                num_images = str2num(TimepointInfoTable{slice,5});
                fullPathString = TimepointInfoTable{slice,1};
                SequenceString = TimepointInfoTable{slice,2};
                Timepoint = str2num(TimepointInfoTable{slice,3});
                dotNumberString = TimepointInfoTable{slice,4};
                [pathString, ~, extString] = fileparts(fullPathString);
                [TFI, W, I_MIN, I_MAX, gM1, gM2, gM3, gM4, gM5, gM6, d, rf] = dot_3D_z_v12(pathString,[SequenceString extString],Timepoint,num_images,pSizeBatch,r,rf,fwhm,zset,ignoreZ,noGraph,xList(slice),yList(slice),zSequence(slice),iminSequence,imaxSequence);
                rSequence(slice) = r;
                rfSequence(slice) = rf;
                iminSequence(slice) = I_MIN;
                imaxSequence(slice) = I_MAX;
                gM1Sequence(slice) = gM1;
                gM2Sequence(slice) = gM2;
                gM3Sequence(slice) = gM3;
                gM4Sequence(slice) = gM4;
                gM5Sequence(slice) = gM5;
                gM6Sequence(slice) = gM6;
                set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI))]);
                set(plotinfo.sI,'String',['W = ' num2str(W,3)]);
                set(plotinfo.sZ,'String',['Z = ' num2str(round(zSequence(slice)))]);            
                tfiSequence(slice) = TFI;
                wSequence(slice) = W;
                set(hinputZset,'String',num2str(zSequence(slice)));
                fullFilePathOutput = fullfile(pathString,[SequenceString '_spot_' dotNumberString '_results' '.xls']);
                xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
                if ignoreZ == 1
                    ignoreString = {'Yes'};
                elseif ignoreZ == 0
                    ignoreString = {'No'};
                end
                xlswrite(fullFilePathOutput,[Timepoint tfiSequence(slice) wSequence(slice) iminSequence(slice) imaxSequence(slice) xList(slice) yList(slice) zSequence(slice) filterSequence(slice) fwhm rfSequence(slice) rSequence(slice) ignoreString gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],'Sheet1',['A' num2str(Timepoint+1)]);
                if ~isnan(round(max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))))
                    update_hpp
                    update_hpz
                    update_hpw
                end
                if ~isnan(gM1Sequence(slice))
                    update_hpgauss
                end
                if ~isnan(zSequence(slice))
                    update_hpzoom
                end
                figure(hfig);
            end
        end
    end

    function pushZero_Callback(pushDot,eventdata,handles)
        %set TFI to 0
        ignoreZ = get(checkZ,'Value');
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        fwhm = str2num(get(hinputFWHM,'String'));
        set(plotinfo.sTFI,'String','TFI = 0');
        set(plotinfo.sI,'String','W = 0');
        set(plotinfo.sZ,'String',['Z = ' num2str(round(zSequence(slice)))]);
        rSequence(slice) = r;
        rfSequence(slice) = rf;
        tfiSequence(slice) = 0;
        wSequence(slice) = 0;
        iminSequence(slice) = NaN;
        imaxSequence(slice) = NaN;
        gM1Sequence(slice) = NaN;
        gM2Sequence(slice) = NaN;
        gM3Sequence(slice) = NaN;
        gM4Sequence(slice) = NaN;
        gM5Sequence(slice) = NaN;
        gM6Sequence(slice) = NaN;
        if ignoreZ == 1
            ignoreString = {'Yes'};
        elseif ignoreZ == 0
            ignoreString = {'No'};
        end
        fullPathString = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        TimepointString = TimepointInfoTable{slice,3};
        dotNumberString = TimepointInfoTable{slice,4};
        [pathString] = fileparts(fullPathString);
        fullFilePathOutput = fullfile(pathString,[SequenceString '_spot_' dotNumberString '_results' '.xls']);
        xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
        xlswrite(fullFilePathOutput,[str2num(TimepointString) tfiSequence(slice) wSequence(slice) iminSequence(slice) imaxSequence(slice) xList(slice) yList(slice) zSequence(slice) filterSequence(slice) fwhm rfSequence(slice) rSequence(slice) ignoreString gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],'Sheet1',['A' num2str(str2num(TimepointString)+1)]);
        if ~isnan(round(max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))))
            update_hpp
            update_hpz
            update_hpw
            clean_hpgauss
        end
        figure(hfig);
    end

    function pushNaN_Callback(pushDot,eventdata,handles)
        %set TFI to NaN
        set(plotinfo.sTFI,'String','TFI = NaN');
        set(plotinfo.sI,'String','W = NaN');
        set(plotinfo.sZ,'String',['Z = ' num2str(round(zSequence(slice)))]);
        xList(slice) = 0;
        yList(slice) = 0;
        zSequence(slice) = NaN;
        tfiSequence(slice) = NaN;
        wSequence(slice) = NaN;
        iminSequence(slice) = NaN;
        imaxSequence(slice) = NaN;
        gM1Sequence(slice) = NaN;
        gM2Sequence(slice) = NaN;
        gM3Sequence(slice) = NaN;
        gM4Sequence(slice) = NaN;
        gM5Sequence(slice) = NaN;
        gM6Sequence(slice) = NaN;
        fullPathString = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        TimepointString = TimepointInfoTable{slice,3};
        dotNumberString = TimepointInfoTable{slice,4};
        [pathString] = fileparts(fullPathString);
        fullFilePathOutput = fullfile(pathString,[SequenceString '_spot_' dotNumberString '_results' '.xls']);
        xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
        xlswrite(fullFilePathOutput,[NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN],'Sheet1',['A' num2str(TimepointString+1)]);
        clean_hpgauss
        if isnan(round(max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))))
            clean_hpp
            clean_hpw
        else
            update_hpp
            update_hpw
        end
        if isnan(round(max(zSequence(slice2range(slice,1):slice2range(slice,2)))))
            clean_hpz
        else
            update_hpz
        end        
        figure(hfig);
    end

    function pushAutoTrack_Callback(pushDot,eventdata,handles)
        %automatically tracks dot over time
        bg.SelectedObject = bgMIP;
        if max(xList(slice2range(slice,1):slice2range(slice,2))) == 0 && max(yList(slice2range(slice,1):slice2range(slice,2))) == 0
            warndlg('No XY coordinates for fitting!')
        else
            set(checkTrack,'Value',1)
            for i = slice:slice2range(slice,2)
                slice = i;
                set(slider1,'Value',slice);
                slider1_Callback(slider1)
                drawnow
            end
        end
    end

    function pushAutoDetect_Callback(pushDot,eventdata,handles)
        %automatically detects spots on nuclei
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);        
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        newZ = get(slider3,'Value');
        stdmeanratio = str2num(get(hinputS,'String'));
        slice = round(get(slider1,'Value'));
        if strcmp(bg.SelectedObject.String,'MIP')
            [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
            drawnow
        elseif strcmp(bg.SelectedObject.String,'Slice')
            SforZ = double(imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+newZ, 'Info', infoString));
            [pks] = dot_detect_MIP(SforZ,rf);
            himage = imshow(SforZ,'DisplayRange',[minImg newMax],'InitialMagnification',100);
            drawnow
        end
        if ~isempty(pks)
            for j = 1:length(pks(:,1))
                if strcmp(bg.SelectedObject.String,'MIP')
                    [~, ~, ~, detected] = track_xyz(round(pks(j,1)),round(pks(j,2)),r,stdmeanratio);
                elseif strcmp(bg.SelectedObject.String,'Slice')
                    [~, ~, ~, detected] = track_xynewZ(round(pks(j,1)),round(pks(j,2)),r,stdmeanratio,newZ);
                end
                if detected == 1
                    rectangle('Position',[pks(j,1)-(rf+8)/2,pks(j,2)-(rf+8)/2,rf+8,rf+8],'Curvature',[1,1],'Edgecolor','g');
                end
            end
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushAUTO_Callback(pushDot,eventdata,handles)
        bg.SelectedObject = bgMIP;
        %automatically performs Gaussian Fitting for dots
        if max(xList) == 0 && max(yList) == 0
            warndlg('No XY coordinates for fitting!')
        else
            p_x = find(xList > 0);
            p_missing = find(isnan(tfiSequence));
            p = intersect(p_x,p_missing);
            numberSlices = length(p);
            for i = 1:numberSlices
                slice = p(i);
                set(slider1,'Value',slice);
                slider1_Callback(slider1)
                pushDot_Callback
                drawnow
            end
            warndlg('All Done!')
        end
    end

    function pushAUTOREDO_Callback(pushDot,eventdata,handles)
        bg.SelectedObject = bgMIP;
        if max(xList) == 0 && max(yList) == 0
            warndlg('No XY coordinates for fitting!')
        else
            p = find(xList > 0);
            numberSlices = length(p);
            for i = 1:numberSlices
                slice = p(i);
                set(slider1,'Value',slice);
                slider1_Callback(slider1)
                pushDot_Callback
                drawnow
            end
            warndlg('All Done!')
        end
    end

    function pushREDO2D_Callback(pushDot,eventdata,handles)
        bg.SelectedObject = bgMIP;
        for i = 1:numberSequences
            slice = TimepointsRange(i,1);
            set(slider1,'Value',slice);
            pushLoad_Callback
        end
        pushAUTOREDO_Callback
    end

    function pushLoadAll_Callback(pushDot,eventdata,handles)
        bg.SelectedObject = bgMIP;
        for i = 1:numberSequences
            slice = TimepointsRange(i,1);
            set(slider1,'Value',slice);
            slider1_Callback(slider1)
            pushLoad_Callback
        end
        set(slider1,'Value',1);
        slider1_Callback(slider1)
        drawnow
    end

    function pushSaveXY_Callback(pushDot,eventdata,handles)
        %save XY coordinates to Excel file
        fwhm = str2num(get(hinputFWHM,'String'));
        fullPathString = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        dotNumberString = TimepointInfoTable{slice,4};
        [pathString] = fileparts(fullPathString);
        if max(xList(slice2range(slice,1):slice2range(slice,2))) == 0
            warndlg('No XY coordinates to save!')
        else
            timepoints = find(xList(slice2range(slice,1):slice2range(slice,2)) ~= 0);
            timepointsForFile = NaN(slice2range(slice,2),1);
            xForFile = NaN(slice2range(slice,2),1);
            yForFile = NaN(slice2range(slice,2),1);
            zForFile = NaN(slice2range(slice,2),1);
            filterForFile = NaN(slice2range(slice,2),1);
            fwhmForFile = NaN(slice2range(slice,2),1);
            rfForFile = NaN(slice2range(slice,2),1);
            rForFile = NaN(slice2range(slice,2),1);
            for i = 1:length(timepoints)
                timepointsForFile(timepoints(i)) = timepoints(i);
                xForFile(timepoints(i)) = xList(slice2range(slice,1) - 1 + timepoints(i));
                yForFile(timepoints(i)) = yList(slice2range(slice,1) - 1 + timepoints(i));
                zForFile(timepoints(i)) = zSequence(slice2range(slice,1) - 1 + timepoints(i));
                filterForFile(timepoints(i)) = filterSequence(slice2range(slice,1) - 1 + timepoints(i));
                fwhmForFile(timepoints(i)) = fwhm;
                rfForFile(timepoints(i)) = rfSequence(slice2range(slice,1) - 1 + timepoints(i));
                rForFile(timepoints(i)) = rSequence(slice2range(slice,1) - 1 + timepoints(i));
            end
            fullFilePathOutput = fullfile(pathString,[SequenceString '_spot_' dotNumberString '_results' '.xls']);
            xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
            xlswrite(fullFilePathOutput,timepointsForFile,'Sheet1','A2');
            xlswrite(fullFilePathOutput,[xForFile yForFile zForFile filterForFile fwhmForFile rfForFile rForFile],'Sheet1','F2');
        end
    end

    function pushLoad_Callback(pushDot,eventdata,handles)
        %load data from Excel file
        bg.SelectedObject = bgMIP;
        S_proj(:,:,slice) = S_proj_clean(:,:,slice);
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        dotNumberString = TimepointInfoTable{slice,4};
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        fullFilePathInput = fullfile(pathString,[SequenceString '_spot_' num2str(dotNumberString) '_results' '.xls']);
        if exist(fullFilePathInput,'file') ~= 2
            warndlg(['No results file for ' SequenceString '_spot_' num2str(dotNumberString) '!'])
        else
            [num,txt,raw] = xlsread(fullFilePathInput,'Sheet1');
            if size(num,2) == 12
                for i = 1:size(num,1)
                    if ~isnan(num(i,1))
                        tfiSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,2);
                        wSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,3);
                        iminSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,4);
                        imaxSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,5);
                        xList(slice2range(slice,1) - 1 + num(i,1)) = num(i,6);
                        yList(slice2range(slice,1) - 1 + num(i,1)) = num(i,7);
                        zSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,8);
                        filterSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,9);
                        rfSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,11);
                        if isnan(num(i,12))
                            rSequence(slice2range(slice,1) - 1 + num(i,1)) = str2num(get(hinputR,'String'));
                        else
                            rSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,12);
                        end
                        if (yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1)) > 0) && (yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1)) < infoString(1).Height) && (xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1)) > 0) && (xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1)) < infoString(1).Height)
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1, xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                        end
                    end
                end
            elseif size(num,2) == 19
                for i = 1:size(num,1)
                    if ~isnan(num(i,1))
                        tfiSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,2);
                        wSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,3);
                        iminSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,4);
                        imaxSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,5);
                        xList(slice2range(slice,1) - 1 + num(i,1)) = num(i,6);
                        yList(slice2range(slice,1) - 1 + num(i,1)) = num(i,7);
                        zSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,8);
                        filterSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,9);
                        rfSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,11);
                        if isnan(num(i,12))
                            rSequence(slice2range(slice,1) - 1 + num(i,1)) = str2num(get(hinputR,'String'));
                        else
                            rSequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,12);
                        end
                        gM1Sequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,14);
                        gM2Sequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,15);
                        gM3Sequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,16);
                        gM4Sequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,17);
                        gM5Sequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,18);
                        gM6Sequence(slice2range(slice,1) - 1 + num(i,1)) = num(i,19);
                        if (yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1)) > 0) && (yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1)) < infoString(1).Height) && (xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1)) > 0) && (xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1)) < infoString(1).Height)
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1, xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                            S_proj(yList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, xList(slice2range(slice,1) - 1 + num(i,1))-rSequence(slice2range(slice,1) - 1 + num(i,1))-1:xList(slice2range(slice,1) - 1 + num(i,1))+rSequence(slice2range(slice,1) - 1 + num(i,1))+1, slice2range(slice,1) - 1 + num(i,1)) = 2^16;
                        end
                    end
                end
            end
            if isnan(round(max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))))
                clean_hpp
            else
                update_hpp
            end
            if isnan(round(max(wSequence(slice2range(slice,1):slice2range(slice,2)))))
                clean_hpw
            else
                update_hpw
            end
            if isnan(round(max(zSequence(slice2range(slice,1):slice2range(slice,2)))))
                clean_hpz
            else
                update_hpz
            end
            if ~isnan(zSequence(slice))
                update_hpzoom
            else
                clean_hpzoom
            end
            if ~isnan(gM1Sequence(slice))
                update_hpgauss
            else
                clean_hpgauss
            end
            figure(hfig)
            set(slider1,'Value',slice);
            slider1_Callback(slider1)
            drawnow
        end
    end

    function pushClear_Callback(pushDot,eventdata,handles)
        %clear all data (and optionally resuts file)
        bg.SelectedObject = bgMIP;
        S_proj(:,:,slice2range(slice,1):slice2range(slice,2)) = S_proj_clean(:,:,slice2range(slice,1):slice2range(slice,2));
        fullPathString = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        dotNumberString = TimepointInfoTable{slice,4};
        [pathString] = fileparts(fullPathString);
        fullFilePathOutput = fullfile(pathString,[SequenceString '_spot_' num2str(dotNumberString) '_results' '.xls']);
        if exist(fullFilePathOutput,'file') == 2
            choice = questdlg('Do you also want to delete the results file?',...
                'WARNING','Yes','No','No');
            if strcmp(choice, 'Yes')
                delete(fullFilePathOutput);
            end
        end
        xList(slice2range(slice,1):slice2range(slice,2)) = 0;
        yList(slice2range(slice,1):slice2range(slice,2)) = 0;
        zSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        tfiSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        wSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        iminSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        imaxSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM1Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM2Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM3Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM4Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM5Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM6Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        rSequence(slice2range(slice,1):slice2range(slice,2)) = 0;
        rfSequence(slice2range(slice,1):slice2range(slice,2)) = 0;
        filterSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        clean_hpp
        clean_hpz
        clean_hpw
        clean_hpzoom
        clean_hpgauss
        figure(hfig)
        set(plotinfo.lasttfi,'String','');
        set(plotinfo.slastTFI,'String','');
        set(plotinfo.slastI,'String','');
        set(plotinfo.slastZ,'String','');
        set(plotinfo.nexttfi,'String','');
        set(plotinfo.snextTFI,'String','');
        set(plotinfo.snextI,'String','');
        set(plotinfo.snextZ,'String','');
        set(plotinfo.sx,'String','');
        set(plotinfo.sy,'String','');
        himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushClearTFI_Callback(pushDot,eventdata,handles)
        %clear all TFI values
        bg.SelectedObject = bgMIP;
        slice_start = slice;
        tfiSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        wSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        iminSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        imaxSequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM1Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM2Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM3Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM4Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM5Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        gM6Sequence(slice2range(slice,1):slice2range(slice,2)) = NaN;
        clean_hpp
        clean_hpz
        clean_hpw
        clean_hpzoom
        clean_hpgauss
        figure(hfig)
        set(slider1,'Value',slice_start);
        slider1_Callback(slider1)
    end

    function pushEXPORTFIGURES_Callback(hObject, eventdata, handles)
        if isnan(tfiSequence)
            warndlg('No Gaussian Fits to export!')
        else
            p = find(~isnan(tfiSequence));
            numberSlices = length(p);
            for i = 1:numberSlices
                slice = p(i);
                set(slider1,'Value',slice);
                slider1_Callback(slider1)
                SequenceString = TimepointInfoTable{slice,2};
                Timepoint = str2num(TimepointInfoTable{slice,3});
                dotNumberString = TimepointInfoTable{slice,4};
                fullFilePathOutput = fullfile(pathstr,[SequenceString '_spot_' num2str(dotNumberString) '_GAUSSIAN_FIT_timepoint_' num2str(Timepoint) '.tif']);
                figure(hpgauss);
                export_fig(fullFilePathOutput,'-m2.5','-r300');
                fullFilePathOutput = fullfile(pathstr,[SequenceString '_spot_' num2str(dotNumberString) '_ZOOM_Z_timepoint_' num2str(Timepoint) '.tif']);
                figure(hpzoom);
                export_fig(fullFilePathOutput,'-m2.5','-r300');
                fullFilePathOutput = fullfile(pathstr,[SequenceString '_spot_' num2str(dotNumberString) '_MIP_timepoint_' num2str(Timepoint) '.tif']);
                figure(hfig);
                export_fig(fullFilePathOutput,'-native');
            end
        end
    end

    function inputR_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
        rSequence(slice) = input;
    end

    function inputStdmeanratio_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
    end

    function inputRf_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
        rfSequence(slice) = input/2;
    end

    function inputFWHM_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0.5')
        end
        grid_size = ceil(input/pSizeBatch)*2;
        rfSequence(slice) = grid_size/2;
        set(hinputRf,'String',num2str(rfSequence(slice)*2));
    end
    
    function inputZset_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','1')
        end
        zPlanes = str2num(TimepointInfoTable{slice,5});
        if input > 0 && input <= zPlanes
            zSequence(slice) = input;
            set(slider3,'Value',input);
            slider3_Callback
        elseif input > zPlanes
            zSequence(slice) = zPlanes;
            set(slider3,'Value',zPlanes);
            slider3_Callback
        end
        figure(hfig);
    end

    function pushEND_Callback(hObject, eventdata, handles)
        bg.SelectedObject = bgMIP;
        for w = 1:numberSequences
            fullPathStr = TimepointInfoTable{TimepointsRange(w,1),1};
            SequenceStr = TimepointInfoTable{TimepointsRange(w,1),2};
            dotNumberStr = TimepointInfoTable{TimepointsRange(w,1),4};
            [pathStr] = fileparts(fullPathStr);
            fileString = [SequenceStr '_spot_' num2str(dotNumberStr) ' - TFI.jpg'];
            PathTFIoutput = fullfile(pathStr,fileString);
            slice = TimepointsRange(w,1) + 1;
            set(slider1,'Value',slice);
            slider1_Callback(slider1)
            if ~isnan(round(max(tfiSequence(slice2range(slice,1):slice2range(slice,2)))))
                figure(hpp)
                title([SequenceStr ' - dot ' num2str(dotNumberStr)],'Interpreter','none');
                saveas(hpp,PathTFIoutput);
            end
        end
        close(hfig);
        close(hpp);
        close(hpw);
        close(hpz);
        close(hpzoom);
        close(hpgauss);
    end

end