function [gM, wm, TFI, res, RESIDUAL] = gauss3d_for_gui_v10(d, fld, md, psize, rf, fwhm, noGraph, a1, a2, a3, a4)

set(0,'defaultlinelinewidth',2);
if (a1 == 0 && a2 == 0 && a3 == 0 )
    [gM, res, RESIDUAL, EXITFLAG] = gaussfit(d(:,:,1),'2d',psize,'n');
    gM(3) = gM(2);
    if noGraph == 0
        plotgaussfit(gM,d(:,:,1),psize,'n');
        axis ([-rf*psize rf*psize -rf*psize rf*psize 0 md]);
        caxis ([fld md]);
    end
    I0 = abs(gM(1));
    w0 = abs(gM(2));
    C0 = abs(gM(4));
    TFI0 = abs(2*I0 * pi * gM(2) * gM(2));
else
    I0 = a1;
    w0 = a2;
    C0 = a4;
    TFI0 = abs(2*a1 * pi * a2 * a2);
    res = 0;
    RESIDUAL = 0;
end
if w0 > fwhm
    TFI = 0;
else
    TFI = TFI0;
end
if (TFI0 > 2^20)
    TFI = 0;
end
wm = w0;