function [results, tfiSelectedALL, timeSequences, nTFISequences] = extract_all_cycles_v6(T, tfiSequence, wSequence, xSequence, ySequence, zSequence, EventMin, EventMax, nZEROS, RSE, tiffFilePath, fullFilePath, batch3D, batch2D, numSlices, TFILower, TFIUpper, Wmin, Wmax)
% runs extract_cycles with lifetimePoints higher than ZEROTFI and maximum TFI value between EventMin and EventMax
% creates results table

results = [];
n = length(tfiSequence);
pointsSequence = (EventMin:EventMax);
tfiSelectedALL = NaN(n,1);
timeSequences = [];
nTFISequences = [];
if nZEROS == 0
    EventMin = n;
    EventMax = n;
end
for i = 1:EventMax-EventMin+1
    newResults = NaN(1000,3);
    newTimeSequences = NaN(1000,EventMax+4);
    newTFISequences = NaN(1000,EventMax+4);
    [timeSequence, nTFISequence, nDELTASequence, timeOfSynthesisSequence, tfiSelected] = extract_cycles_v6(T, tfiSequence, wSequence, pointsSequence(i), nZEROS, TFILower, TFIUpper, Wmin, Wmax);
    if max(~isnan(tfiSelected)) == 1
        sliceSequence = (timeSequence+T) / T;
        rowsSliceSequence = size(sliceSequence,1);
        columnsSliceSequence = size(sliceSequence, 2);
        info = imfinfo(tiffFilePath);
        [path, name] = fileparts(fullFilePath);    
        if batch3D == 1 && RSE ~= 0
            for j = 1:rowsSliceSequence
                for n = 1:columnsSliceSequence
                    if isnan(zSequence(sliceSequence(j,n)))
                        zSequence(sliceSequence(j,n)) = zSequence(sliceSequence(j,nZEROS+1));
                        ySequence(sliceSequence(j,n)) = ySequence(sliceSequence(j,nZEROS+1));
                        xSequence(sliceSequence(j,n)) = xSequence(sliceSequence(j,nZEROS+1));
                    end
                    singleFrame = imread(tiffFilePath,(sliceSequence(j,n)-1)*str2num(numSlices) + zSequence(sliceSequence(j,n)), 'Info', info);
                    singleFrameCropped = singleFrame(ySequence(sliceSequence(j,n))-RSE:ySequence(sliceSequence(j,n))+RSE, xSequence(sliceSequence(j,n))-RSE:xSequence(sliceSequence(j,n))+RSE);
                    fileString = [name ' - ' num2str(sliceSequence(j,n)) '.tif'];
                    PathTFIoutput = fullfile(path,fileString);
                    hsd = figure;
                    imshow(singleFrameCropped,'DisplayRange',[min(min(singleFrameCropped)) max(max(singleFrameCropped))],'InitialMagnification',500)
                    saveas(hsd,PathTFIoutput);
                    close(hsd)
                end
            end
        elseif batch2D == 1 && RSE ~= 0
            rowsSliceSequence = size(sliceSequence,1);
            columnsSliceSequence = size(sliceSequence,2);
            for j = 1:rowsSliceSequence
                for n = 1:columnsSliceSequence
                    singleFrame = imread(tiffFilePath,sliceSequence(j,n), 'Info', info);
                    singleFrameCropped = singleFrame(ySequence(sliceSequence(j,n))-RSE:ySequence(sliceSequence(j,n))+RSE, xSequence(sliceSequence(j,n))-RSE:xSequence(sliceSequence(j,n))+RSE);
                    fileString = [name ' - ' num2str(sliceSequence(j,n)) '.tif'];
                    PathTFIoutput = fullfile(path,fileString);
                    hsd = figure;
                    imshow(singleFrameCropped,'DisplayRange',[min(min(singleFrameCropped)) max(max(singleFrameCropped))],'InitialMagnification',500)
                    saveas(hsd,PathTFIoutput);
                    close(hsd)
                end
            end
        end               
    end     
    tfiSelectedALL(~isnan(tfiSelected)) = tfiSelected(~isnan(tfiSelected));
    newResults(1:length(nDELTASequence),1) = timeOfSynthesisSequence;
    newResults(1:length(nDELTASequence),2) = (pointsSequence(i)+1)*T;
    newResults(1:length(nDELTASequence),3) = nDELTASequence;
    newTimeSequences(1:length(nDELTASequence),1:size(timeSequence,2)) = timeSequence;
    newTFISequences(1:length(nDELTASequence),1:size(nTFISequence,2)) = nTFISequence;
    badrows = all(isnan(newResults),2);
    newResults(badrows,:)=[];
    newTimeSequences(badrows,:)=[];
    newTFISequences(badrows,:)=[];
    if ~isempty(newResults)
        results = [results; newResults];
        timeSequences = [timeSequences; newTimeSequences];
        nTFISequences = [nTFISequences; newTFISequences];
    end
end