function [TfilesMeanT] = dot_3xGFP_list_v12(particleSize,particleThreshold,pixelSize,r,outputImg,userConfirmation)
% for use with dot_2D_single_v8 (faster mean and max TFI - new 2 bleaching events processing)

[files2get, path2get] = uigetfile('*.*','MultiSelect','on');
% If user only selects 1 file, convert files2get to cell array
if ~iscell(files2get)
    files2get = {files2get};
end
n = size(files2get,2);
for i=1:n
    [~, name, ext] = fileparts(files2get{i});
    fullFilePath = fullfile(path2get,files2get{i});
    hgfp = figure;
    [pks, image_x_size, image_y_size] = dot_detect_stack2(fullFilePath,particleSize,particleThreshold);
    if isempty(pks)
        warndlg('Threshold is too high! No peaks detected')
    else
        n_pks = length(pks(:,1));
        info = imfinfo(fullFilePath);
        n_timepoints = numel(info);
        timep = (1:n_timepoints)';
        prfs = zeros (n_pks, n_timepoints);
        fits = zeros (n_pks, n_timepoints);
        fOuts = cell(n_pks,1);
        nStepsT = zeros (n_pks,1);
        TfilesMean1 = zeros (n_pks,1);
        TfilesMean2_1 = zeros (n_pks,1);
        TfilesMean2_2 = zeros (n_pks,1);
        TfilesMean3_1 = zeros (n_pks,1);
        TfilesMean3_2 = zeros (n_pks,1);
        TfilesMean3_3 = zeros (n_pks,1);
        TfilesMeanT = zeros (n_pks,1);
        if i == 1
            replyall = questdlg('Do you want to Proceed?','Check','Yes','No','Yes');
        end
        h = waitbar(0,'Initializing waitbar...','Position',[735,500,280,50]);
        waitbar(i/n,h,sprintf('Timelapse %d of %d',i,n))
        if (strcmp(replyall,'Yes') == 1)
            h2 = waitbar(0,'Initializing waitbar...','Position',[735,420,280,50]);
            for j = 1:n_pks
                waitbar(i/n,h,sprintf('Timelapse %d of %d',i,n))
                waitbar(j/n_pks,h2,sprintf('Fitting Particle %d of %d',j,n_pks))
                if (pks(j,1)-r > 0) && (pks(j,2)-r > 0) && (pks(j,1)+r+1 < image_x_size) && (pks(j,2)+r+1 < image_y_size)
                    [meanTFI, nSteps, prf, prf_fit, fOut] = dot_2D_single_v10(path2get,[name ext],pixelSize,r,pks(j,1),pks(j,2),outputImg);
                    prfs(j,1:n_timepoints) = prf;
                    fits(j,1:n_timepoints) = prf_fit;
                    fOuts{j} = fOut;
                    nStepsT(j) = nSteps;
                    if nSteps == 1
                        TfilesMean1(j) = meanTFI;
                        TfilesMean2_1(j) = 0;
                        TfilesMean2_2(j) = 0;
                        TfilesMean3_1(j) = 0;
                        TfilesMean3_2(j) = 0;
                        TfilesMean3_3(j) = 0;
                        TfilesMeanT(j) = meanTFI;
                    elseif nSteps == 2
                        TfilesMean1(j) = 0;
                        TfilesMean2_1(j) = meanTFI(1,1);
                        TfilesMean2_2(j) = meanTFI(1,2);
                        TfilesMean3_1(j) = 0;
                        TfilesMean3_2(j) = 0;
                        TfilesMean3_3(j) = 0;
                        TfilesMeanT(j) = meanTFI(1,1) + meanTFI(1,2);
                    elseif nSteps == 3
                        TfilesMean1(j) = 0;
                        TfilesMean2_1(j) = 0;
                        TfilesMean2_2(j) = 0;
                        TfilesMean3_1(j) = meanTFI(1,1);
                        TfilesMean3_2(j) = meanTFI(1,2);
                        TfilesMean3_3(j) = meanTFI(1,3);
                        TfilesMeanT(j) = meanTFI(1,1) + meanTFI(1,2) + meanTFI(1,3);
                    end
                else
                    TfilesMean1(j) = 0;
                    TfilesMean2_1(j) = 0;
                    TfilesMean2_2(j) = 0;
                    TfilesMean3_1(j) = 0;
                    TfilesMean3_2(j) = 0;
                    TfilesMean3_3(j) = 0;
                    TfilesMeanT(j) = 0;
                end
                waitbar(i/n,h,sprintf('Timelapse %d of %d',i,n))
                waitbar(j/n_pks,h2,sprintf('Fitting Particle %d of %d',j,n_pks))
            end
            h3 = waitbar(0,'Initializing waitbar...','Position',[735,340,280,50]);
            for l = 1:n_pks
                waitbar(i/n,h,sprintf('Timelapse %d of %d',i,n))
                waitbar(l/n_pks,h3,sprintf('Checking Particle %d of %d',l,n_pks))
                if nStepsT(l) == 1
                   hf1 = figure('Position',[50 50 300 300]);
                   plot(prfs(l,:));
                   hold on
                   plot(timep,fits(l,:),'r','linewidth',2);
                   fullFilePathJpg = fullfile(path2get,['ONE - ' fOuts{l} '.jpg']);
                   if userConfirmation == 1
                        reply = questdlg('ONE bleaching event OK?','User Confirmation','Yes','No','Yes');
                        if(strcmp(reply,'No') == 1)
                            TfilesMean1(l) = 0;
                            TfilesMeanT(l) = 0;
                        elseif(strcmp(reply,'Yes') == 1)
                            fullFilePathJpg = fullfile(path2get,['OK ONE - ' fOuts{l} '.jpg']);
                        end
                    end
                    if outputImg == 1
                        saveas(hf1,fullFilePathJpg);
                    end
                    close(hf1)
                elseif nStepsT(l) == 2
                    hf2 = figure('Position',[50 50 300 300]);
                    plot(prfs(l,:));
                    hold on
                    plot(timep,fits(l,:),'r','linewidth',2);
                    fullFilePathJpg = fullfile(path2get,['TWO - ' fOuts{l} '.jpg']);
                    if userConfirmation == 1
                        reply = questdlg('TWO bleaching events OK?','User Confirmation','Yes','No','Yes');
                        if(strcmp(reply,'No') == 1)
                            TfilesMean2_1(l) = 0;
                            TfilesMean2_2(l) = 0;
                            TfilesMeanT(l) = 0;
                        elseif(strcmp(reply,'Yes') == 1)
                            fullFilePathJpg = fullfile(path2get,['OK TWO - ' fOuts{l} '.jpg']);
                        end
                    end
                    if outputImg == 1
                        saveas(hf2,fullFilePathJpg);
                    end
                    close(hf2)
                elseif nStepsT(l) == 3
                    hf3 = figure('Position',[50 50 300 300]);
                    plot(prfs(l,:));
                    hold on
                    plot(timep,fits(l,:),'r','linewidth',2);
                    fullFilePathJpg = fullfile(path2get,['THREE - ' fOuts{l} '.jpg']);
                    if userConfirmation == 1
                       reply = questdlg('THREE bleaching events OK?','User Confirmation','Yes','No','Yes');
                       if(strcmp(reply,'No') == 1)
                           TfilesMean3_1(l) = 0;
                           TfilesMean3_2(l) = 0;
                           TfilesMean3_3(l) = 0;
                           TfilesMeanT(l) = 0;
                       elseif(strcmp(reply,'Yes') == 1)
                           fullFilePathJpg = fullfile(path2get,['OK THREE - ' fOuts{l} '.jpg']);
                       end
                    end
                    if outputImg == 1
                        saveas(hf3,fullFilePathJpg);
                    end
                    close(hf3)
                end
            end
            TfilesMean1 = TfilesMean1(TfilesMean1 ~= 0);
            TfilesMean2_1 = TfilesMean2_1(TfilesMean2_1 ~= 0);
            TfilesMean2_2 = TfilesMean2_2(TfilesMean2_2 ~= 0);
            TfilesMean3_1 = TfilesMean3_1(TfilesMean3_1 ~= 0);
            TfilesMean3_2 = TfilesMean3_2(TfilesMean3_2 ~= 0);
            TfilesMean3_3 = TfilesMean3_3(TfilesMean3_3 ~= 0);
            TfilesMeanT = TfilesMeanT(TfilesMeanT ~= 0);
            if isempty(TfilesMean1)
                TfilesMean1 = 0;
            end
            if isempty(TfilesMean2_1)
                TfilesMean2_1 = 0;
            end
            if isempty(TfilesMean2_2)
                TfilesMean2_2 = 0;
            end
            if isempty(TfilesMean3_1)
                TfilesMean3_1 = 0;
            end
            if isempty(TfilesMean3_2)
                TfilesMean3_2 = 0;
            end
            if isempty(TfilesMean3_3)
                TfilesMean3_3 = 0;
            end
            if isempty(TfilesMeanT)
                TfilesMeanT = 0;
            end
            fullFilePathOutputTFIMean = fullfile(path2get,[name '_results_TFI_MEAN' '.xls']);
            xlswrite(fullFilePathOutputTFIMean,{'TFI 1', 'TFI 2_1', 'TFI 2_2', 'TFI 3_1', 'TFI 3_2', 'TFI 3_3', 'TFI T'},'Sheet1','A1');
            xlswrite(fullFilePathOutputTFIMean,TfilesMean1,'Sheet1','A2');
            xlswrite(fullFilePathOutputTFIMean,TfilesMean2_1,'Sheet1','B2');
            xlswrite(fullFilePathOutputTFIMean,TfilesMean2_2,'Sheet1','C2');
            xlswrite(fullFilePathOutputTFIMean,TfilesMean3_1,'Sheet1','D2');
            xlswrite(fullFilePathOutputTFIMean,TfilesMean3_2,'Sheet1','E2');
            xlswrite(fullFilePathOutputTFIMean,TfilesMean3_3,'Sheet1','F2');
            xlswrite(fullFilePathOutputTFIMean,TfilesMeanT,'Sheet1','G2');
            close(h2)
            close(h3)
        end
        waitbar(i/n,h,sprintf('Timelapse %d of %d',i,n))
        close(h)
        close(hgfp)
    end
end