function [Tfile, Wfile, I_MIN, I_MAX, gM1, gM2, gM3, gM4, gM5, gM6, d, rf] = dot_3D_z_v12(folder,fname,timepoint,num_images,psize,r,rf,fwhm,zset,ignoreZ,noGraph,x,y,z,iminSequence,imaxSequence)
fullFilePath = fullfile(folder,fname);
info = imfinfo(fullFilePath);
r = rf;
[A, B] = dot_readstack_3D_v5(fullFilePath,timepoint,num_images,x,y,z,r);
if (y-r < 1) || (y+r > info(1).Height-1) || (x-r < 1) || (x+r > info(1).Height-1)
    r = min(y-1,x-1,info(1).Height-y+1,info(1).Height-x+1);
end
if zset == 0
    zset = z;
end
if ((zset == 1) || (zset == size(A,3))) && ignoreZ == 0
    d = B(r-rf+1:r+rf+1, r-rf+1:r+rf+1, zset);
    Tfile = NaN;
    Wfile = NaN;
    I_MIN = NaN;
    I_MAX = NaN;
    gM1 = NaN;
    gM2 = NaN;
    gM3 = NaN;
    gM4 = NaN;
    gM5 = NaN;
    gM6 = NaN;
else
    d = B(r-rf+1:r+rf+1, r-rf+1:r+rf+1, zset);
    I_MAX = max(max(max(d)));
    I_MIN = min(min(min(d)));
    imaxSequence(timepoint) = I_MAX;
    iminSequence(timepoint) = I_MIN; 
    md = max(imaxSequence);
    fld = min(iminSequence);
    [gM, w0, TFI] = gauss3d_for_gui_v10(d, fld, md, psize, rf, fwhm, noGraph,0,0,0,0);
    Tfile = TFI;
    Wfile = w0;
    gM1 = gM(1);
    gM2 = gM(2);
    gM3 = gM(3);
    gM4 = gM(4);
    gM5 = gM(5);
    gM6 = gM(6);
    if noGraph == 0
        pause(.4);
        close('Gaussian Fit');
    end
end