function varargout = TFI_W_Distributions(varargin)
% TFI_W_DISTRIBUTIONS MATLAB code for TFI_W_Distributions.fig
%      TFI_W_DISTRIBUTIONS, by itself, creates a new TFI_W_DISTRIBUTIONS or raises the existing
%      singleton*.
%
%      H = TFI_W_DISTRIBUTIONS returns the handle to a new TFI_W_DISTRIBUTIONS or the handle to
%      the existing singleton*.
%
%      TFI_W_DISTRIBUTIONS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TFI_W_DISTRIBUTIONS.M with the given input arguments.
%
%      TFI_W_DISTRIBUTIONS('Property','Value',...) creates a new TFI_W_DISTRIBUTIONS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before TFI_W_Distributions_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to TFI_W_Distributions_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help TFI_W_Distributions

% Last Modified by GUIDE v2.5 29-Jun-2015 14:49:26

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @TFI_W_Distributions_OpeningFcn, ...
                   'gui_OutputFcn',  @TFI_W_Distributions_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before TFI_W_Distributions is made visible.
function TFI_W_Distributions_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to TFI_W_Distributions (see VARARGIN)

% Choose default command line output for TFI_W_Distributions
handles.output = hObject;

%initialize this variable
handles.selectedCells = [];

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes TFI_W_Distributions wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = TFI_W_Distributions_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushAdd.
function pushAdd_Callback(hObject, eventdata, handles)
% hObject    handle to pushAdd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[files2get, path2get] = uigetfile('*.xls','Select the Excel file','MultiSelect','on');
% If user only selects 1 file, convert files2get to cell array
if ~iscell(files2get)
    files2get = {files2get};
end
nFiles = size(files2get,2);
filePathForTable = cell(nFiles,1);
spotNumberForTable = cell(nFiles,1);
for i=1:nFiles
    [~, nameFile] = fileparts(files2get{i});
    filePath = fullfile(path2get,files2get{i});
    [num] = xlsread(filePath);
    tfiSequence = num(:,2);
    tfiSequence(any(isnan(tfiSequence),2)|any(tfiSequence==0,2),:) = [];
    n_spots = size(tfiSequence,1);
    spotNumberForTable(i) = {num2str(n_spots)};
    filePathForTable(i) = {filePath};
end
currentData = get(handles.uitableList,'data');
newDataForTable = [spotNumberForTable filePathForTable];
dataForTable = [currentData; newDataForTable];
set(handles.uitableList,'data',dataForTable);
ndataFiles = size(dataForTable,1);
if ndataFiles == 1
    set(handles.textNFiles,'String',[num2str(ndataFiles) ' file']);
    set(handles.textNSpots,'String',[num2str(dataForTable{:,1}) ' spots']);
elseif ndataFiles > 1
    set(handles.textNFiles,'String',[num2str(ndataFiles) ' files']);
    ndataFilesInt = zeros(ndataFiles);
    for i=1:ndataFiles
        ndataFilesInt(i) = str2num(dataForTable{i,1});
    end
    set(handles.textNSpots,'String',[num2str(sum(sum(ndataFilesInt))) ' spots']);
elseif ndataFiles == 0
    set(handles.textNFiles,'String','');
    set(handles.textNSpots,'String','');
end
guidata(hObject, handles);

% --- Executes on button press in pushRemove.
function pushRemove_Callback(hObject, eventdata, handles)
% hObject    handle to pushRemove (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataForTable = get(handles.uitableList,'data');
if isempty(handles.selectedCells);
    warndlg('No sequence(s) selected!')
else
    rowsToRemove = unique(handles.selectedCells(:,1));
    dataForTable(rowsToRemove,:) = [];
    set(handles.uitableList,'data',dataForTable);
end
ndataFiles = size(dataForTable,1);
if ndataFiles == 1
    set(handles.textNFiles,'String',[num2str(ndataFiles) ' file']);
    set(handles.textNSpots,'String',[num2str(dataForTable{:,1}) ' spots']);
elseif ndataFiles > 1
    set(handles.textNFiles,'String',[num2str(ndataFiles) ' files']);
    ndataFilesInt = zeros(ndataFiles);
    for i=1:ndataFiles
        ndataFilesInt(i) = str2num(dataForTable{i,1});
    end
    set(handles.textNSpots,'String',[num2str(sum(sum(ndataFilesInt))) ' spots']);
elseif ndataFiles == 0
    set(handles.textNFiles,'String','');
    set(handles.textNSpots,'String','');
end
guidata(hObject, handles);

% --- Executes on button press in pushSave.
function pushSave_Callback(hObject, eventdata, handles)
% hObject    handle to pushSave (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataFromTable = get(handles.uitableList,'data');
if isempty(dataFromTable)
    warndlg('No sequence list to save!')
else
    nSpotsList = dataFromTable(:,1);
    filePathList = dataFromTable(:,2);
    [FileName,PathName] = uiputfile('*.xls','Save sequence list to Excel file');
    fullFilePathOutput = fullfile(PathName,FileName);
    if exist(fullFilePathOutput,'file')
        delete(fullFilePathOutput)
    end
    xlswrite(fullFilePathOutput,[nSpotsList filePathList],'Sheet1','A1');
end
guidata(hObject, handles);

% --- Executes on button press in pushLoad.
function pushLoad_Callback(hObject, eventdata, handles)
% hObject    handle to pushLoad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataForTable = [];
set(handles.uitableList,'data',dataForTable);
[FileName,PathName] = uigetfile('*.xls','Select sequence list Excel file');
fullFilePathInput = fullfile(PathName,FileName);
[num,~,raw] = xlsread(fullFilePathInput);
numSequences = size(num,1);
nSpotsList = cell(numSequences,1);
filePathList = cell(numSequences,1);
for i=1:numSequences
    nSpotsList(i) = {num2str(num(i,1))};
    filePathList(i) = raw(i,2);
end
dataForTable = [nSpotsList filePathList];
set(handles.uitableList,'data',dataForTable);
ndataFiles = size(dataForTable,1);
if ndataFiles == 1
    set(handles.textNFiles,'String',[num2str(ndataFiles) ' file']);
    set(handles.textNSpots,'String',[num2str(dataForTable{:,1}) ' spots']);
elseif ndataFiles > 1
    set(handles.textNFiles,'String',[num2str(ndataFiles) ' files']);
    ndataFilesInt = zeros(ndataFiles);
    for i=1:ndataFiles
        ndataFilesInt(i) = str2num(dataForTable{i,1});
    end
    set(handles.textNSpots,'String',[num2str(sum(sum(ndataFilesInt))) ' spots']);
elseif ndataFiles == 0
    set(handles.textNFiles,'String','');
    set(handles.textNSpots,'String','');
end
guidata(hObject, handles);

% --- Executes on button press in pushW.
function pushW_Callback(hObject, eventdata, handles)
% hObject    handle to pushW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataFromTable = get(handles.uitableList,'data');
numFiles = length(dataFromTable(:,1));
dataW = [];
for i = 1:numFiles
    [num] = xlsread(dataFromTable{i,2});
    dataW = [dataW; num(:,3)];
end
dataW(any(isnan(dataW),2)|any(dataW==0,2),:) = [];
binW = str2num(get(handles.binW,'String'));
maxW = str2num(get(handles.maxW,'String'));
limitW = str2num(get(handles.limitW,'String'));
maxW = binW*round(maxW/binW);
limitW = binW*round(limitW/binW);
range = (0:binW:maxW);
range_for_gauss = (0:binW:limitW);
n = histc(dataW,range);
n_for_gauss = histc(dataW,range_for_gauss);
l_for_gauss = length(n_for_gauss);
gT = fit((1:l_for_gauss)',n_for_gauss,'gauss1');
axes(handles.axesW)
fbar = bar(n);
xlabel = str2double(get(handles.axesW,'XTickLabel'));
set(handles.axesW,'XTickLabel', xlabel*binW);
set(fbar,'FaceColor',[.5 .7 1])
hold on;
p = plot(gT,'k');
p.LineWidth = 2;
legend('hide')
hold off;
set(get(handles.axesW,'XLabel'),'String','W')
set(get(handles.axesW,'YLabel'),'String','Counts')
set(handles.textWaverage,'String',num2str(gT.b1*binW));
set(handles.textW_lower_68,'String',num2str(gT.b1*binW-gT.c1*binW/sqrt(2)));
set(handles.textW_upper_68,'String',num2str(gT.b1*binW+gT.c1*binW/sqrt(2)));
set(handles.textW_lower_95,'String',num2str(gT.b1*binW-2*gT.c1*binW/sqrt(2)));
set(handles.textW_upper_95,'String',num2str(gT.b1*binW+2*gT.c1*binW/sqrt(2)));
guidata(hObject, handles);


function limitW_Callback(hObject, eventdata, handles)
% hObject    handle to limitW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of limitW as text
%        str2double(get(hObject,'String')) returns contents of limitW as a double


% --- Executes during object creation, after setting all properties.
function limitW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to limitW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function maxW_Callback(hObject, eventdata, handles)
% hObject    handle to maxW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of maxW as text
%        str2double(get(hObject,'String')) returns contents of maxW as a double


% --- Executes during object creation, after setting all properties.
function maxW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to maxW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function binW_Callback(hObject, eventdata, handles)
% hObject    handle to binW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of binW as text
%        str2double(get(hObject,'String')) returns contents of binW as a double


% --- Executes during object creation, after setting all properties.
function binW_CreateFcn(hObject, eventdata, handles)
% hObject    handle to binW (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function binTFI_Callback(hObject, eventdata, handles)
% hObject    handle to binTFI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of binTFI as text
%        str2double(get(hObject,'String')) returns contents of binTFI as a double


% --- Executes during object creation, after setting all properties.
function binTFI_CreateFcn(hObject, eventdata, handles)
% hObject    handle to binTFI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function maxTFI_Callback(hObject, eventdata, handles)
% hObject    handle to maxTFI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of maxTFI as text
%        str2double(get(hObject,'String')) returns contents of maxTFI as a double


% --- Executes during object creation, after setting all properties.
function maxTFI_CreateFcn(hObject, eventdata, handles)
% hObject    handle to maxTFI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function limitTFI_Callback(hObject, eventdata, handles)
% hObject    handle to limitTFI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of limitTFI as text
%        str2double(get(hObject,'String')) returns contents of limitTFI as a double


% --- Executes during object creation, after setting all properties.
function limitTFI_CreateFcn(hObject, eventdata, handles)
% hObject    handle to limitTFI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushTFI.
function pushTFI_Callback(hObject, eventdata, handles)
% hObject    handle to pushTFI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataFromTable = get(handles.uitableList,'data');
numFiles = length(dataFromTable(:,1));
dataTFI = [];
for i = 1:numFiles
    [num] = xlsread(dataFromTable{i,2});
    dataTFI = [dataTFI; num(:,2)];
end
dataTFI(any(isnan(dataTFI),2)|any(dataTFI==0,2),:) = [];
binTFI = str2num(get(handles.binTFI,'String'));
maxTFI = str2num(get(handles.maxTFI,'String'));
limitTFI = str2num(get(handles.limitTFI,'String'));
maxTFI = binTFI*round(maxTFI/binTFI);
limitTFI = binTFI*round(limitTFI/binTFI);
range = (0:binTFI:maxTFI);
range_for_gauss = (0:binTFI:limitTFI);
n = histc(dataTFI,range);
n_for_gauss = histc(dataTFI,range_for_gauss);
l_for_gauss = length(n_for_gauss);
gT = fit((1:l_for_gauss)',n_for_gauss,'gauss1');
axes(handles.axesTFI)
fbar = bar(n);
xlabel = str2double(get(handles.axesTFI,'XTickLabel'));
set(handles.axesTFI,'XTickLabel', xlabel*binTFI);
set(fbar,'FaceColor',[.5 .7 1])
hold on;
p = plot(gT,'k');
p.LineWidth = 2;
legend('hide')
hold off;
set(get(handles.axesTFI,'XLabel'),'String','TFI')
set(get(handles.axesTFI,'YLabel'),'String','Counts')
set(handles.textTFIaverage,'String',num2str(gT.b1*binTFI));
set(handles.textTFI_lower_68,'String',num2str(gT.b1*binTFI-gT.c1*binTFI/sqrt(2)));
set(handles.textTFI_upper_68,'String',num2str(gT.b1*binTFI+gT.c1*binTFI/sqrt(2)));
set(handles.textTFI_lower_95,'String',num2str(gT.b1*binTFI-2*gT.c1*binTFI/sqrt(2)));
set(handles.textTFI_upper_95,'String',num2str(gT.b1*binTFI+2*gT.c1*binTFI/sqrt(2)));
guidata(hObject, handles);

% --- Executes when selected cell(s) is changed in uitableBatch.
function uitableList_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to uitableBatch (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)

%every time the cell selection changes, we update this data
%eventdata stores the indices of the selected cells
handles.selectedCells = eventdata.Indices;

%update the gui data
guidata(hObject, handles);

% --- Executes during object deletion, before destroying properties.
function uitableList_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to uitableBatch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function uitableList_CreateFcn(hObject, eventdata, handles)
% hObject    handle to uitableList (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
