function varargout = STaQTool(varargin)
% STAQTOOL MATLAB code for STaQTool.fig
%      STAQTOOL, by itself, creates a new STAQTOOL or raises the existing
%      singleton*.
%
%      H = STAQTOOL returns the handle to a new STAQTOOL or the handle to
%      the existing singleton*.
%
%      STAQTOOL('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in STAQTOOL.M with the given input arguments.
%
%      STAQTOOL('Property','Value',...) creates a new STAQTOOL or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before STaQTool_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to STaQTool_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help STaQTool

% Last Modified by GUIDE v2.5 17-Feb-2016 13:50:04

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @STaQTool_OpeningFcn, ...
                   'gui_OutputFcn',  @STaQTool_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before STaQTool is made visible.
function STaQTool_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to STaQTool (see VARARGIN)

% Choose default command line output for STaQTool
handles.output = hObject;

%initialize this variable
handles.selectedCells = [];

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes STaQTool wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = STaQTool_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushSingleLog.
function pushSingleLog_Callback(hObject, eventdata, handles)
% hObject    handle to pushSingleLog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[LogFileName,PathName] = uigetfile('*.log','Select the LOG file');
[~, name] = fileparts(LogFileName);
fullLogFilePath = fullfile(PathName, LogFileName);
logFID = fopen(fullLogFilePath,'r');
logData = textscan(logFID, '%s', 'delimiter', {'\n','\t'}, 'whitespace', '');
logStrings = logData{1};
fclose(logFID);
indexesT = strfind(logStrings, 'Time Points: ');
indexT = find(~cellfun('isempty', indexesT), 1);
N = strrep(logStrings{indexT}, 'Time Points: ', '');
set(handles.inputN,'String',N);
indexesZ = strfind(logStrings, 'Z Planes: ');
indexZ = find(~cellfun('isempty', indexesZ), 1);
zPlanes = strrep(logStrings{indexZ}, 'Z Planes: ', '');
set(handles.inputZ,'String',zPlanes);
indexesC = strfind(logStrings, 'Channels: ');
indexC = find(~cellfun('isempty', indexesC), 1);
channels = strrep(logStrings{indexC}, 'Channels: ', '');
set(handles.inputChannels,'String', channels);
indexesIFD = strfind(logStrings, 'IFD');
indexIFD = find(~cellfun('isempty', indexesIFD), 1);
if str2num(channels) == 1
    channel1Name = logStrings{indexIFD+12,:};
    channel1File = logStrings{indexIFD+13,:};
    fullFilePath1 = fullfile(PathName, channel1File);
    set(handles.fullFileName1,'String',fullFilePath1);
    set(handles.fullFileName2,'String','');
    set(handles.answerFile,'String',name);
else
    channel1Name = logStrings{indexIFD+12,:};
    channel1File = logStrings{indexIFD+13,:};
    fullFilePath1 = fullfile(PathName, channel1File);
    set(handles.fullFileName1,'String',fullFilePath1);
    channel2Name = logStrings{indexIFD+19,:};
    channel2File = logStrings{indexIFD+20,:};
    fullFilePath2 = fullfile(PathName, channel2File);
    set(handles.fullFileName2,'String',fullFilePath2);
    set(handles.answerFile,'String',name);
end
indexesP = strfind(logStrings, 'Microns Per Pixel: ');
indexP = find(~cellfun('isempty', indexesP), 1);
Psize = strrep(logStrings{indexP}, 'Microns Per Pixel: ', '');
set(handles.inputPsize,'String',Psize);
nZ = str2num(zPlanes);
if nZ == 1
    set(handles.inputSingleDot2D,'Value',1);
else
    set(handles.inputSingleDot3D,'Value',1);
end
name = strrep(name,['_' channel1Name],'');
set(handles.answerFile,'String',name);
guidata(hObject, handles);


function inputPsize_Callback(hObject, eventdata, handles)
% hObject    handle to inputPsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of inputPsize as text
%        str2double(get(hObject,'String')) returns contents of inputPsize as a double
input = str2num(get(hObject,'String'));
if (isempty(input))
     set(hObject,'String','0')
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function inputPsize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to inputPsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function inputN_Callback(hObject, eventdata, handles)
% hObject    handle to inputN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of inputN as text
%        str2double(get(hObject,'String')) returns contents of inputN as a double
input = str2num(get(hObject,'String'));
if (isempty(input))
     set(hObject,'String','0')
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function inputN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to inputN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in pushGoSingle.
function pushGoSingle_Callback(hObject, eventdata, handles)
% hObject    handle to pushGoSingle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%twoDFit = get(handles.input2D,'Value');
%ignoreZ = get(handles.inputIgnoreZ,'Value');
SingleDot3D = get(handles.inputSingleDot3D,'Value');
SingleDot2D = get(handles.inputSingleDot2D,'Value');
MultipleDots = get(handles.inputMultipleDots,'Value');
MultipleDots2D = get(handles.inputMultipleDots2D,'Value');
fullFilePath1 = get(handles.fullFileName1,'String');
fullFilePath2 = get(handles.fullFileName2,'String');
sequenceName = get(handles.answerFile,'String');
dotNumber = str2num(get(handles.inputDot,'String'));
n = str2num(get(handles.inputN,'String'));
zPlanes = str2num(get(handles.inputZ,'String'));
pSize = str2num(get(handles.inputPsize,'String'));
channels = str2num(get(handles.inputChannels,'String'));
[pathstr, name1, ext] = fileparts(fullFilePath1);
[~, name2] = fileparts(fullFilePath2);
info = imfinfo(fullFilePath1);
if SingleDot3D == 1 && channels == 1
    if n == 1
        warndlg('Single Spot Mode works only with timelapses! (Timepoints > 1)')
        set(handles.inputMultipleDots,'Value',1);
    else
        interfaceImage3D_timelapse_v15(pathstr,name1,ext,info,dotNumber,n,zPlanes,pSize);
    end
elseif SingleDot3D == 1 && channels == 2
    if n == 1
        warndlg('Single Spot Mode works only with timelapses! (Timepoints > 1)')
        set(handles.inputMultipleDots,'Value',1);
    else
        interfaceImage3D_timelapse_2channels_v5(pathstr,name1,name2,ext,dotNumber,n,zPlanes,pSize)
    end
elseif SingleDot2D == 1 && channels == 1
    if n == 1
        warndlg('Single Spot Mode works only with timelapses! (Timepoints > 1)')
        set(handles.inputMultipleDots2D,'Value',1);
    else
        interfaceImage2D_timelapse_v6(pathstr,name1,ext,info,dotNumber,n,pSize);
    end
elseif SingleDot2D == 1 && channels == 2
    if n == 1
        warndlg('Single Spot Mode works only with timelapses! (Timepoints > 1)')
        set(handles.inputMultipleDots2D,'Value',1);
    else
        interfaceImage2D_timelapse_2channels_v5(pathstr,name1,name2,ext,dotNumber,n,pSize);
    end
elseif MultipleDots == 1 && channels == 1
    interfaceImage3D_multipleDots_v8(pathstr,name1,ext,info,n,zPlanes,pSize);
elseif MultipleDots == 1 && channels == 2
    interfaceImage3D_multipleDots_2channels_v1(pathstr,name1,name2,ext,n,zPlanes,pSize);
elseif MultipleDots2D == 1 && channels == 1
    interfaceImage2D_multipleDots_v6(pathstr,name1,ext,info,n,pSize);
elseif MultipleDots2D == 1 && channels == 2
    interfaceImage2D_multipleDots_2channels_v1(pathstr,name1,name2,ext,n,pSize);
end
guidata(hObject, handles);

function inputDot_Callback(hObject, eventdata, handles)
% hObject    handle to inputDot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of inputDot as text
%        str2double(get(hObject,'String')) returns contents of inputDot as a double
input = str2num(get(hObject,'String'));
if (isempty(input))
     set(hObject,'String','0')
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function inputDot_CreateFcn(hObject, eventdata, handles)
% hObject    handle to inputDot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes when selected object is changed in inputMode.
function inputMode_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in inputMode 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushLoadBatch.
function pushLoadBatch_Callback(hObject, eventdata, handles)
% hObject    handle to pushLoadBatch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[files2get, path2get] = uigetfile('*.log','Select the LOG file','MultiSelect','on');
% If user only selects 1 file, convert files2get to cell array
if ~iscell(files2get)
    files2get = {files2get};
end
nFiles = size(files2get,2);
fileNameForTable = cell(nFiles,1);
sequenceNameForTable = cell(nFiles,1);
channelsForTable = cell(nFiles,1);
dotNumberForTable = cell(nFiles,1);
nTimepointsForTable = cell(nFiles,1);
zSlicesForTable = cell(nFiles,1);
for i=1:nFiles
    [~, nameFile] = fileparts(files2get{i});
    logFilePath = fullfile(path2get,files2get{i});
    logFID = fopen(logFilePath,'r');
    logData = textscan(logFID, '%s', 'delimiter', {'\n','\t'}, 'whitespace', '');
    logStrings = logData{1};
    fclose(logFID);
    indexesT = strfind(logStrings, 'Time Points: ');
    indexT = find(~cellfun('isempty', indexesT), 1);
    nTimepointsForTable(i) = {strrep(logStrings{indexT}, 'Time Points: ', '')};
    indexesZ = strfind(logStrings, 'Z Planes: ');
    indexZ = find(~cellfun('isempty', indexesZ), 1);
    zSlicesForTable(i) = {strrep(logStrings{indexZ}, 'Z Planes: ', '')};
    indexesC = strfind(logStrings, 'Channels: ');
    indexC = find(~cellfun('isempty', indexesC), 1);
    channelsForTable(i) = {strrep(logStrings{indexC}, 'Channels: ', '')};
    indexesIFD = strfind(logStrings, 'IFD');
    indexIFD = find(~cellfun('isempty', indexesIFD), 1);
    channel1Name = logStrings{indexIFD+12,:};
    indexesP = strfind(logStrings, 'Microns Per Pixel: ');
    indexP = find(~cellfun('isempty', indexesP), 1);
    Psize = strrep(logStrings{indexP}, 'Microns Per Pixel: ', '');
    set(handles.inputPSizeBatch,'String',Psize);
    nZ = str2num(zSlicesForTable{i});
    if nZ == 1
        set(handles.radioBatch2D,'Value',1);
    else
        set(handles.radioBatch3D,'Value',1);
    end
    dotNumberForTable(i) = {num2str(1)};
    nameFile = strrep(nameFile,['_' channel1Name],'');
    sequenceNameForTable(i) = {nameFile};
    fileNameForTable(i) = {logFilePath};
end
currentData = get(handles.uitableBatch,'data');
newDataForTable = [sequenceNameForTable channelsForTable dotNumberForTable nTimepointsForTable zSlicesForTable fileNameForTable];
dataForTable = [currentData; newDataForTable];
set(handles.uitableBatch,'data',dataForTable);
guidata(hObject, handles);


% --- Executes on button press in pushRemoveFiles.
function pushRemoveFiles_Callback(hObject, eventdata, handles)
% hObject    handle to pushRemoveFiles (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataForTable = get(handles.uitableBatch,'data');
if isempty(handles.selectedCells);
    warndlg('No sequence(s) selected!')
else
    rowsToRemove = unique(handles.selectedCells(:,1));
    dataForTable(rowsToRemove,:) = [];
    set(handles.uitableBatch,'data',dataForTable);
end
guidata(hObject, handles);

% --- Executes on button press in pushGoBatch.
function pushGoBatch_Callback(hObject, eventdata, handles)
% hObject    handle to pushGoBatch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
batch3D = get(handles.radioBatch3D,'Value');
batch2D = get(handles.radioBatch2D,'Value');
dataFromTable = get(handles.uitableBatch,'data');
numImagesInSequenceTimepoint = dataFromTable(:,5);
fileNameForTable = dataFromTable(:,6);
numZ = zeros (length(numImagesInSequenceTimepoint),1);
PSizes = zeros (length(numImagesInSequenceTimepoint),1);
for i = 1:length(numImagesInSequenceTimepoint)
    numZ(i) = str2num(numImagesInSequenceTimepoint{i});
    logFID = fopen(fileNameForTable{i},'r');
    logData = textscan(logFID, '%s', 'delimiter', {'\n','\t'}, 'whitespace', '');
    logStrings = logData{1};
    fclose(logFID);
    indexesP = strfind(logStrings, 'Microns Per Pixel: ');
    indexP = find(~cellfun('isempty', indexesP), 1);
    PSizes(i) = str2num(strrep(logStrings{indexP}, 'Microns Per Pixel: ', ''));
end
if min(numZ) == 1 && max(numZ) > 1
    warndlg('Batch list must not contain mixed 2D and 3D sequences!')
elseif length(unique(PSizes)) > 1
    warndlg('Batch list must not contain sequences with different Pixel Sizes!')
else
    pSizeBatch = str2num(get(handles.inputPSizeBatch,'String'));
    if batch3D == 1
        interfaceImage3D_timelapse_batch_2channels_v5(dataFromTable,pSizeBatch);
    elseif batch2D == 1
        interfaceImage2D_timelapse_batch_2channels_v5(dataFromTable,pSizeBatch);
    end
end
guidata(hObject, handles);


function inputPSizeBatch_Callback(hObject, eventdata, handles)
% hObject    handle to inputPSizeBatch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of inputPSizeBatch as text
%        str2double(get(hObject,'String')) returns contents of inputPSizeBatch as a double
input = str2num(get(hObject,'String'));
if (isempty(input))
     set(hObject,'String','0')
end
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function inputPSizeBatch_CreateFcn(hObject, eventdata, handles)
% hObject    handle to inputPSizeBatch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes when selected cell(s) is changed in uitableBatch.
function uitableBatch_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to uitableBatch (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)

%every time the cell selection changes, we update this data
%eventdata stores the indices of the selected cells
handles.selectedCells = eventdata.Indices;

%update the gui data
guidata(hObject, handles);


% --- Executes on button press in pushbuttonAddDot.
function pushbuttonAddDot_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAddDot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataForTable = get(handles.uitableBatch,'data');
if isempty(handles.selectedCells);
    warndlg('No sequence(s) selected!')
else
    rowsToAdd = unique(handles.selectedCells(:,1));
    numRowsToAdd = length(rowsToAdd);
    fileNameForTable = cell(numRowsToAdd,1);
    sequenceNameForTable = cell(numRowsToAdd,1);
    channelsForTable = cell(numRowsToAdd,1);
    dotNumberForTable = cell(numRowsToAdd,1);
    nTimepointsForTable = cell(numRowsToAdd,1);
    zSlicesForTable = cell(numRowsToAdd,1);
    for i=1:numRowsToAdd
        sequenceNameForTable(i) = dataForTable(rowsToAdd(i),1);
        channelsForTable(i) = dataForTable(rowsToAdd(i),2);
        dotNumberForTable(i) = {num2str(str2num(dataForTable{rowsToAdd(i),3})+1)};
        nTimepointsForTable(i) = dataForTable(rowsToAdd(i),4);
        zSlicesForTable(i) = dataForTable(rowsToAdd(i),5);
        fileNameForTable(i) = dataForTable(rowsToAdd(i),6);
    end
    dataToAdd = [sequenceNameForTable channelsForTable dotNumberForTable nTimepointsForTable zSlicesForTable fileNameForTable];
    newDataForTable = insertrows(dataForTable,dataToAdd,rowsToAdd);
    set(handles.uitableBatch,'data',newDataForTable);
end
guidata(hObject, handles);


% --- Executes on button press in pushbuttonFromBatch.
function pushbuttonFromBatch_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonFromBatch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataForTable = get(handles.uitableBatch,'data');
if isempty(handles.selectedCells);
    warndlg('No sequence selected!')
elseif length(unique(handles.selectedCells(:,1))) > 1
    warndlg('Select only ONE sequence')
else
    selectedSequence = unique(handles.selectedCells(:,1));
    sequenceName = dataForTable{selectedSequence,1};
    channels = dataForTable{selectedSequence,2};
    dotNumber = dataForTable{selectedSequence,3};
    nTimepoints = dataForTable{selectedSequence,4};
    zSlices = dataForTable{selectedSequence,5};
    if str2num(zSlices) > 1
        set(handles.inputSingleDot3D,'Value',1);
    elseif str2num(zSlices) == 1
        set(handles.inputSingleDot2D,'Value',1);
    end
    logFileName = dataForTable{selectedSequence,6};
    [PathName, name] = fileparts(logFileName);
    set(handles.answerFile,'String',sequenceName);
    set(handles.inputChannels,'String',channels);
    set(handles.inputDot,'String',dotNumber);
    set(handles.inputN,'String',nTimepoints);
    set(handles.inputZ,'String',zSlices);    
    if str2num(channels) == 1
        logFID = fopen(logFileName,'r');
        logData = textscan(logFID, '%s', 'delimiter', {'\n','\t'}, 'whitespace', '');
        logStrings = logData{1};
        fclose(logFID);
        indexesIFD = strfind(logStrings, 'IFD');
        indexIFD = find(~cellfun('isempty', indexesIFD), 1);
        indexesP = strfind(logStrings, 'Microns Per Pixel: ');
        indexP = find(~cellfun('isempty', indexesP), 1);
        pSize = str2num(strrep(logStrings{indexP}, 'Microns Per Pixel: ', ''));
        set(handles.inputPsize,'String',pSize);
        channel1Name = logStrings{indexIFD+12,:};
        channel1File = logStrings{indexIFD+13,:};
        fullFilePath1 = fullfile(PathName, channel1File);
        set(handles.fullFileName1,'String',fullFilePath1);
        set(handles.fullFileName2,'String','');
    elseif str2num(channels) == 2
        [pathstr, name] = fileparts(logFileName);
        logFID = fopen(logFileName,'r');
        logData = textscan(logFID, '%s', 'delimiter', {'\n','\t'}, 'whitespace', '');
        logStrings = logData{1};
        fclose(logFID);
        indexesIFD = strfind(logStrings, 'IFD');
        indexIFD = find(~cellfun('isempty', indexesIFD), 1);
        indexesP = strfind(logStrings, 'Microns Per Pixel: ');
        indexP = find(~cellfun('isempty', indexesP), 1);
        pSize = str2num(strrep(logStrings{indexP}, 'Microns Per Pixel: ', ''));
        set(handles.inputPsize,'String',pSize);
        channel1Name = logStrings{indexIFD+12,:};
        channel1File = logStrings{indexIFD+13,:};
        fullFilePath1 = fullfile(PathName, channel1File);
        set(handles.fullFileName1,'String',fullFilePath1);
        channel2Name = logStrings{indexIFD+19,:};
        channel2File = logStrings{indexIFD+20,:};
        fullFilePath2 = fullfile(PathName, channel2File);
        set(handles.fullFileName2,'String',fullFilePath2);
        set(handles.answerFile,'String',name);
    end
    name = strrep(name,['_' channel1Name],'');
    set(handles.answerFile,'String',name);
end
guidata(hObject, handles);


% --- Executes on button press in pushBatchSave.
function pushBatchSave_Callback(hObject, eventdata, handles)
% hObject    handle to pushBatchSave (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataFromTable = get(handles.uitableBatch,'data');
if isempty(dataFromTable)
    warndlg('No sequence list to save!')
else
    sequenceList = dataFromTable(:,1);
    channels = dataFromTable(:,2);
    dotNumberInSequences = dataFromTable(:,3);
    numberImagesInSequences = dataFromTable(:,4);
    numberSlicesInZ = dataFromTable(:,5);
    fullFilePathSequences = dataFromTable(:,6);
    [FileName,PathName] = uiputfile('*.xls','Save sequence list to Excel file');
    fullFilePathOutput = fullfile(PathName,FileName);
    if exist(fullFilePathOutput,'file')
        delete(fullFilePathOutput)
    end
    xlswrite(fullFilePathOutput,[sequenceList channels dotNumberInSequences numberImagesInSequences numberSlicesInZ fullFilePathSequences],'Sheet1','A1');
end
guidata(hObject, handles);
    
% --- Executes on button press in pushBatchLoad.
function pushBatchLoad_Callback(hObject, eventdata, handles)
% hObject    handle to pushBatchLoad (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dataForTable = [];
set(handles.uitableBatch,'data',dataForTable);
[FileName,PathName] = uigetfile('*.xls','Select sequence list Excel file');
fullFilePathInput = fullfile(PathName,FileName);
[num,~,raw] = xlsread(fullFilePathInput);
numSequences = size(raw,1);
fileNameForTable = cell(numSequences,1);
sequenceNameForTable = cell(numSequences,1);
channelsForTable = cell(numSequences,1);
dotNumberForTable = cell(numSequences,1);
nTimepointsForTable = cell(numSequences,1);
zSlicesForTable = cell(numSequences,1);
for i=1:numSequences
    sequenceNameForTable(i) = raw(i,1);
    channelsForTable(i) = {num2str(num(i,1))};
    dotNumberForTable(i) = {num2str(num(i,2))};
    nTimepointsForTable(i) = {num2str(num(i,3))};
    zSlicesForTable(i) = {num2str(num(i,4))};
    fileNameForTable(i) = raw(i,6);
end
dataForTable = [sequenceNameForTable channelsForTable dotNumberForTable nTimepointsForTable zSlicesForTable fileNameForTable];
set(handles.uitableBatch,'data',dataForTable);
logFID = fopen(fileNameForTable{1},'r');
logData = textscan(logFID, '%s', 'delimiter', '\n', 'whitespace', '');
logStrings = logData{1};
fclose(logFID);
indexesP = strfind(logStrings, 'Microns Per Pixel: ');
indexP = find(~cellfun('isempty', indexesP), 1);
Psize = strrep(logStrings{indexP}, 'Microns Per Pixel: ', '');
set(handles.inputPSizeBatch,'String',Psize);
guidata(hObject, handles);


function inputZ_Callback(hObject, eventdata, handles)
% hObject    handle to inputZ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of inputZ as text
%        str2double(get(hObject,'String')) returns contents of inputZ as a double
input = str2num(get(hObject,'String'));
if (isempty(input))
     set(hObject,'String','0')
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function inputZ_CreateFcn(hObject, eventdata, handles)
% hObject    handle to inputZ (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function inputChannels_Callback(hObject, eventdata, handles)
% hObject    handle to inputChannels (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of inputChannels as text
%        str2double(get(hObject,'String')) returns contents of inputChannels as a double
input = str2num(get(hObject,'String'));
if (isempty(input))
     set(hObject,'String','0')
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function inputChannels_CreateFcn(hObject, eventdata, handles)
% hObject    handle to inputChannels (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushSingleEventDetection.
function pushSingleEventDetection_Callback(hObject, eventdata, handles)
% hObject    handle to pushSingleEventDetection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
batch3D = get(handles.radioBatch3D,'Value');
batch2D = get(handles.radioBatch2D,'Value');
dataFromTable = get(handles.uitableBatch,'data');
Single_Event_Detection(dataFromTable,batch2D,batch3D)
guidata(hObject, handles);

% --- Executes on button press in pushCreateSingleLog.
function pushCreateSingleLog_Callback(hObject, eventdata, handles)
% hObject    handle to pushCreateSingleLog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
n = get(handles.inputN,'String');
zPlanes = get(handles.inputZ,'String');
pSize = get(handles.inputPsize,'String');
channels = str2num(get(handles.inputChannels,'String'));
if channels == 1
    [tiffFileName,PathName] = uigetfile('*.*','Select the TIFF file');
    [~, name] = fileparts(tiffFileName);
    fullLogFilePath = fullfile(PathName, [name '.log']);
    logFID = fopen(fullLogFilePath,'wt');
    fprintf(logFID,'%s\n','Export Date-Time: unknown');
    fprintf(logFID,'%s\n','Capture Date-Time: unknown');
    fprintf(logFID,'%s%s\n','Z Planes: ',zPlanes);
    fprintf(logFID,'%s%s\n','Time Points: ',n);
    fprintf(logFID,'%s%s\n','Channels: ',num2str(channels));
    fprintf(logFID,'%s%s\n','Microns Per Pixel: ', pSize);
    fprintf(logFID,'%s\n','Z Step Size Microns: unknown');
    fprintf(logFID,'%s\n','Average Timelapse Interval: unknown');
    fprintf(logFID,'%s\t%s\t%s\t%s\t%s\t%s\t%s\n','IFD','X Position (um)','Y Position (um)','Z Position (um)','Elapsed Time (ms)','Channel Name','TIFF File Name');
    fprintf(logFID,'%s\t%s\t%s\t%s\t%s\t%s\t%s\n','0','0','0','0','0','Channel_1',tiffFileName);
    fclose(logFID);
    warndlg([name '.log' ' created!']);
elseif channels == 2
    [tiffFileName1,PathName] = uigetfile('*.*','Select the TIFF file for CHANNEL 1');
    [tiffFileName2] = uigetfile('*.*','Select the TIFF file for CHANNEL 2');
    [~, name1] = fileparts(tiffFileName1);
    fullLogFilePath = fullfile(PathName, [name1 '.log']);
    logFID = fopen(fullLogFilePath,'wt');
    fprintf(logFID,'%s\n','Export Date-Time: unknown');
    fprintf(logFID,'%s\n','Capture Date-Time: unknown');
    fprintf(logFID,'%s%s\n','Z Planes: ',zPlanes);
    fprintf(logFID,'%s%s\n','Time Points: ',n);
    fprintf(logFID,'%s%s\n','Channels: ',num2str(channels));
    fprintf(logFID,'%s%s\n','Microns Per Pixel: ', pSize);
    fprintf(logFID,'%s\n','Z Step Size Microns: unknown');
    fprintf(logFID,'%s\n','Average Timelapse Interval: unknown');
    fprintf(logFID,'%s\t%s\t%s\t%s\t%s\t%s\t%s\n','IFD','X Position (um)','Y Position (um)','Z Position (um)','Elapsed Time (ms)','Channel Name','TIFF File Name');
    fprintf(logFID,'%s\t%s\t%s\t%s\t%s\t%s\t%s\n','0','0','0','0','0','Channel_1',tiffFileName1);
    fprintf(logFID,'%s\t%s\t%s\t%s\t%s\t%s\t%s\n','0','0','0','0','0','Channel_2',tiffFileName2);
    fclose(logFID);
    warndlg([name1 '.log' ' created!']);
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
ha = axes('units','pixels', ...
            'position',[13 450 341 80]);
% Move the background axes to the bottom
uistack(ha,'top');

% Load in a background image and display it using the correct colors
% The image used below, is in the Image Processing Toolbox.  If you do not have %access to this toolbox, you can use another image file instead.
I = imread('STaQTool.tif');
hi = imagesc(I);

% Turn the handlevisibility off so that we don't inadvertently plot into the axes again
% Also, make the axes invisible
set(ha,'handlevisibility','off', 'visible','off')

% --- Executes on button press in pushAbout.
function pushAbout_Callback(hObject, eventdata, handles)
% hObject    handle to pushAbout (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
figure('Name','About','numberTitle','off','Toolbar','none',...
            'Menubar','none','Units','pixels','Position',[400, 80, 504 698]);
set(gca,'position',[0 0 1 1],'units','normalized')
imshow('About.tif','InitialMagnification',100)


% --- Executes on button press in pushTFIWDistributions.
function pushTFIWDistributions_Callback(hObject, eventdata, handles)
% hObject    handle to pushTFIWDistributions (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
TFI_W_Distributions
guidata(hObject, handles);


% --- Executes during object deletion, before destroying properties.
function uitableBatch_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to uitableBatch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushGFP.
function pushGFP_Callback(hObject, eventdata, handles)
% hObject    handle to pushGFP (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
GFP_Distributions
guidata(hObject, handles);
