function [pks, image_x_size, image_y_size] = dot_detect_stack2(fname, size, threshold)
info = imfinfo(fname);
num_images = numel(info);
a = zeros(info(1).Height, info(1).Width, num_images);
image_x_size = info(1).Width;
image_y_size = info(1).Height;
for k = 1:num_images
    a(:,:,k) = imread(fname, k, 'Info', info);
end
a_proj = zeros (info(1).Width, info(1).Height);
for j = 1:info(1).Width
    for i = 1:info(1).Height
        a_proj(i,j) = max(a(i,j,:));
    end
end
pks = dot_detect(a_proj, size, threshold);
colormap('gray'), imagesc(a_proj), truesize, axis off;
if ~isempty(pks)
    for n = 1:length(pks(:,1))
        rectangle('Position',[pks(n,1)-(size+8)/2,pks(n,2)-(size+8)/2,size+8,size+8],'Curvature',[1,1],'Edgecolor','r');
    end
end