function interfaceImage3D_multipleDots_v8(pathstr,Sequence,ext,info,n,num_images,pSize)

S = zeros(info(1).Height, info(1).Width, num_images);
S_proj = zeros(info(1).Height, info(1).Width, n);
ho = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
for k = 1:n
    waitbar(k/n,ho,sprintf('Loading z-stack from timepoint %d of %d',k,n))
    for l = 1:num_images
        S(:,:,l) = imread(fullfile(pathstr, [Sequence ext]),(k-1)*num_images+l, 'Info', info);
    end
    S_proj(:,:,k) = max(S,[],3);
end
xList = zeros(1,n);
yList = zeros(1,n);
iminSequence = NaN(1,n);
imaxSequence = NaN(1,n);
gM1Sequence = NaN(1,n);
gM2Sequence = NaN(1,n);
gM3Sequence = NaN(1,n);
gM4Sequence = NaN(1,n);
gM5Sequence = NaN(1,n);
gM6Sequence = NaN(1,n);
zSequence = NaN(1,n);
rSequence = zeros(1,n);
rfSequence = zeros(1,n);
close(ho)

sizeImg = size(S_proj);
minImg = min(min(min(S_proj)));
maxImg = max(max(max(S_proj)));
minSlice = 1;
if numel(sizeImg) == 3
    maxSlice = sizeImg(3);
else
    maxSlice = 1;
end
startSlice = 1;

S_proj_clean = S_proj;
S_proj_clean_for_fit = S_proj;

% Create a figure for zoomed image on brightest plane
hpzoom = figure('Name','Z','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,545,161,185]);        

% Create a figure for Gaussian Fit
hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure',...
            'Menubar','none','Position',[1116,545,221,185]);        
hpgaussbuttons = findall(hpgauss);
hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(hpgaussbutton1,'Visible','Off')
set(hpgaussbutton2,'Visible','Off')
set(hpgaussbutton4,'Visible','Off')
set(hpgaussbutton5,'Visible','Off')
set(hpgaussbutton7,'Visible','Off')
set(hpgaussbutton8,'Visible','Off')
set(hpgaussbutton9,'Visible','Off')
set(hpgaussbutton10,'Visible','Off')
set(hpgaussbutton11,'Visible','Off')
set(hpgaussbutton12,'Visible','Off')
set(hpgaussbutton13,'Visible','Off')

% Create a figure without toolbar and menubar
hfig = figure('Toolbar','figure',...
    'Menubar','none',...
    'Name','Max Projection Timelapse Viewer - Multiple Spots 3D (single channel)',...
    'Position',[20,100,900,630],...
    'NumberTitle','off',...
    'IntegerHandle','off');
hfigbuttons = findall(hfig);
button1 = findall(hfigbuttons,'ToolTipString','New Figure');
button2 = findall(hfigbuttons,'ToolTipString','Open File');
button3 = findall(hfigbuttons,'ToolTipString','Save Figure');
button4 = findall(hfigbuttons,'ToolTipString','Print Figure');
button5 = findall(hfigbuttons,'ToolTipString','Edit Plot');
button6 = findall(hfigbuttons,'ToolTipString','Rotate 3D');
button7 = findall(hfigbuttons,'ToolTipString','Data Cursor');
button8 = findall(hfigbuttons,'ToolTipString','Brush/Select Data');
button9 = findall(hfigbuttons,'ToolTipString','Link Plot');
button10 = findall(hfigbuttons,'ToolTipString','Insert Colorbar');
button11 = findall(hfigbuttons,'ToolTipString','Insert Legend');
button12 = findall(hfigbuttons,'ToolTipString','Hide Plot Tools');
button13 = findall(hfigbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(button1,'Visible','Off')
set(button2,'Visible','Off')
set(button3,'Visible','Off')
set(button4,'Visible','Off')
set(button5,'Visible','Off')
set(button6,'Visible','Off')
set(button7,'Visible','Off')
set(button8,'Visible','Off')
set(button9,'Visible','Off')
set(button10,'Visible','Off')
set(button11,'Visible','Off')
set(button12,'Visible','Off')
set(button13,'Visible','Off')

hpanel1 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Recenter Spot',...
    'Clipping','on',...
    'Position',[10 12 30 6.69230769230769]);

htextR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 2.69230769230769 17.2 1.84615384615385],...
'String','Search Radius',...
'Style','text',...
'Tag','text4');

hinputR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 3.07692307692308 5.4 1.53846153846154],...
'String','6',...
'Style','edit',...
'Tag','inputR',...
'Callback',@inputR_Callback);

htextS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.3 0.466153846153846 17.4 1.85615384615385],...
'String','Sensitivity ',...
'Style','text',...
'Tag','text5');

hinputS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 1.015384615384615 5.4 1.43846153846154],...
'String','10',...
'Style','edit',...
'Tag','inputStdmeanratio',...
'Callback',@inputStdmeanratio_Callback);

hpanel2 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Gaussian Fitting',...
    'Clipping','on',...
    'Position',[146 36 30 10]);

htextFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 5.19230769230769 17.2 1.84615384615385],...
'String','PSF FWHM',...
'Style','text',...
'Tag','textRf');

hinputFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 5.68692307692308 7.4 1.53846153846154],...
'String','0.500',...
'Style','edit',...
'Tag','inputRf',...
'Callback',@inputFWHM_Callback);

htextRf = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 2.89230769230769 17.2 1.84615384615385],...
'String','Grid Size',...
'Style','text',...
'Tag','textRf');

hinputRf = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 3.37692307692308 5.4 1.53846153846154],...
'String','6',...
'Style','edit',...
'Tag','inputRf',...
'Callback',@inputRf_Callback);

htextZset = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 0.5 17.2 1.85615384615385],...
'String','Z slice',...
'Style','text',...
'Tag','textZset');

hinputZset = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 1.07 5.4 1.53846153846154],...
'String','1',...
'Style','edit',...
'Tag','inputZset',...
'Callback',@inputZset_Callback);

bg = uibuttongroup(hfig,'Units','characters',...
    'Position',[154 33 22 2],...
    'SelectionChangedFcn',@slider3_Callback);          
              
bgMIP = uicontrol(bg,'Style',...
                  'radiobutton',...
                  'String','MIP',...
                  'Position',[5 5 40 15]);
              
bgSlice = uicontrol(bg,'Style','radiobutton',...
                  'String','Slice',...
                  'Position',[55 5 50 15]);

if maxSlice > 1
    sliceRange = maxSlice - minSlice;
else
    sliceRange = 1;
end

slider1 = uicontrol(hfig,'Style','slider',...
    'Min',minSlice,'Max',maxSlice,...
    'Position',[20,30,185,20],...
    'SliderStep',[1/sliceRange 5/sliceRange],...
    'Callback',@slider1_Callback);

set(slider1,'Value',startSlice);

slider2 = uicontrol(hfig,'Style','slider',...
    'Min',minImg,'Max',maxImg,...
    'Position',[20,60,20,185],...
    'SliderStep',[10/(maxImg-minImg) 50/(maxImg-minImg)],...
    'Callback',@slider2_Callback);

set(slider2,'Value',maxImg);

slider3 = uicontrol(hfig,'Style','slider',...
    'Min',1,'Max',num_images,...
    'Position',[738,370,20,80],...
    'SliderStep',[1/(num_images-1) 1/(num_images-1)],...
    'Callback',@slider3_Callback);

set(slider3,'Value',1);

slice = round(get(slider1,'Value'));

newMax = round(get(slider2,'Value'));

plotinfo.s1 = uicontrol(hfig,'Style','text',...
    'String','Timepoint',...
    'Position',[135,50,48,20]);

plotinfo.s2 = uicontrol(hfig,'Style','text',...
    'String',num2str(slice),...
    'Position',[185,50,20,20]);

plotinfo.s3 = uicontrol(hfig,'Style','text',...
    'String','MAX',...
    'Position',[15,245,30,20]);

plotinfo.s4 = uicontrol(hfig,'Style','text',...
    'String','Spot',...
    'Position',[744 239 30 20]);

plotinfo.s5 = uicontrol(hfig,'Style','text',...
    'String','Z',...
    'HorizontalAlignment','center',...
    'Position',[738,452,20,16]);

checkFilter = uicontrol('Style', 'checkbox',...
    'Position',[55 260 50 30],...
    'FontSize',10,...
    'String','Filter',...
    'Value',1);

checkGraph = uicontrol('Style', 'checkbox',...
    'Position',[740 340 150 20],...
    'FontSize',10,...
    'String','Hide Gaussian Fit');

checkZ = uicontrol('Style', 'checkbox',...
    'Position',[740 310 150 20],...
    'FontSize',10,...
    'String','Ignore Z Limits');

plotinfo.sDot = uicontrol(hfig,'Style','text',...
    'Position',[750,205,120,20],...
    'FontWeight','bold',...
    'FontSize',12,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sTFI = uicontrol(hfig,'Style','text',...
    'Position',[750,175,120,20],...
    'FontWeight','bold',...
    'FontSize',11,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sI = uicontrol(hfig,'Style','text',...
    'Position',[750,155,120,20],...
    'FontWeight','bold',...
    'FontSize',11,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sZ = uicontrol(hfig,'Style','text',...
    'Position',[750,125,120,20],...
    'FontWeight','bold',...
    'FontSize',10,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sxytitle = uicontrol(hfig,'Style','text',...
    'Position',[40,105,160,40],...
    'String','Click on image to get XY coordinates',...
    'FontWeight','bold',...
    'FontSize',9);

plotinfo.sx = uicontrol(hfig,'Style','text',...
    'Position',[50,85,80,20],...
    'FontSize',10);

plotinfo.sy = uicontrol(hfig,'Style','text',...
    'Position',[120,85,80,20],...
    'FontSize',10);

editDot = uicontrol('Style', 'edit',...
    'Position',[745 245 30 20],...
    'Callback',@editDot_Callback);

set(editDot,'String',num2str(1));

dot_number = round(str2num(get(editDot,'String')));

pushAutoDetect = uicontrol('Style', 'pushbutton',...
    'Position',[20 290 90 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Detect',...
    'Callback',@pushAutoDetect_Callback);

pushAutoFIT = uicontrol('Style', 'pushbutton',...
    'Position',[110 290 84 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Fit',...
    'Callback',@pushAutoFIT_Callback);

pushDot = uicontrol('Style', 'pushbutton',...
    'Position',[780 240 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Gaussian Fit',...
    'Callback',@pushDot_Callback);

pushEXPORTFIGURES = uicontrol('Style', 'pushbutton',...
    'Position',[750 45 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Export Figures',...
    'Callback',@pushEXPORTFIGURES_Callback);

pushAutoFitAll = uicontrol('Style', 'pushbutton',...
    'Position',[750 80 120 30],...
    'FontWeight','bold',...
    'FontSize',11,...
    'ForegroundColor',[0 0.498 0],...
    'String','AUTO FIT ALL',...
    'Callback',@AutoFitAll_Callback);

pushNextSpot = uicontrol('Style','pushbutton',...
    'Position',[760 273 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','>',...
    'Callback',@pushNEXTSpot_Callback);

pushPreviousSpot = uicontrol('Style','pushbutton',...
    'Position',[730 273 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','<',...
    'Callback',@pushPREVSpot_Callback);

pushEND = uicontrol('Style', 'pushbutton',...
    'Position',[750 10 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0.043 0.518 0.78],...
    'String','END Timelapse',...
    'Callback',@pushEND_Callback);

ha = axes('units','pixels','position',[210 59 512 512]);
himage = imshow(S_proj(:,:,round(slice)),...
        'DisplayRange',[minImg round(newMax)],...
        'InitialMagnification',100,'parent',ha);
set(hfig,'WindowButtonMotionFcn',@changepointer)
set(himage,'ButtonDownFcn',@pixelInfo)

    function changepointer(hObj,handles)
            %change pointer to crosshair when hovering himage
            axlim = get(ha,'Position');
            fglim = get(hfig,'Position');
            x1 = axlim(1) + fglim(1);
            x2 = (axlim(1)+axlim(3)) + fglim(1);
            y1 = axlim(2) + fglim(2);
            y2 = (axlim(2)+axlim(4)) + fglim(2);
            pntr = get(0,'PointerLocation');
            if pntr(1)>x1 && pntr(1)<x2 && pntr(2)>y1 && pntr(2)<y2
                set(hfig,'Pointer','crosshair')
            else
                set(hfig,'Pointer','arrow')
            end
    end

    function [x, y, z, detected] = track_xyz(xi,yi,r,stdmeanratio)
        %track (x,y,z) coordinates from (xi,yi) depending on stdmeanratio 
        SforZ = zeros(info(1).Height, info(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+j, 'Info', info);
        end
        B = SforZ(yi-r:yi+r, xi-r:xi+r, :);
        rf = str2num(get(hinputRf,'String'))/2;
        [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
        sumValues = zeros(num_images,1);
        for m = 1:num_images
            pixelValues = double(sort(reshape(B(:,:,m),1,[]),'descend'));
            sumValues(m) = pixelValues(1) + pixelValues(2) + pixelValues(3) + pixelValues(4);
        end
        z = find(sumValues(:) == max(sumValues),1);
        if ~isempty(pks)
            D = pdist2([xi,yi],pks);
            i_min = find(D == min(D));
            if min(D) <= 2*r && (max(max(std(double(B)))) > mean(mean(mean(double(B))))/stdmeanratio)
                detected = 1;
                x = pks(i_min,1);
                y = pks(i_min,2);
            else
                detected = 0;
                x = xi;
                y = yi;
            end
        else
            detected = 0;
            x = xi;
            y = yi;
        end
    end

    function [x, y, newZ, detected] = track_xynewZ(xi,yi,r,stdmeanratio, newZ)
        %track (x,y,z) coordinates from (xi,yi) depending on stdmeanratio 
        SforZ = double(imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+newZ, 'Info', info));
        B = SforZ(yi-r:yi+r, xi-r:xi+r); 
        rf = str2num(get(hinputRf,'String'))/2;
        [pks] = dot_detect_MIP(SforZ,rf);
        if ~isempty(pks)
            D = pdist2([xi,yi],pks);
            i_min = find(D == min(D));
            if min(D) <= 2*r && (max(max(std(double(B)))) > mean(mean(mean(double(B))))/stdmeanratio)
                detected = 1;
                x = pks(i_min,1);
                y = pks(i_min,2);
            else
                detected = 0;
                x = xi;
                y = yi;
            end
        else
            detected = 0;
            x = xi;
            y = yi;
        end
    end

    function update_hpzoom
        figure(hpzoom)
        SforZ = zeros(info(1).Height, info(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+j, 'Info', info);
        end
        singleFrameZoom = SforZ(yList(slice)-rSequence(slice):yList(slice)+rSequence(slice), xList(slice)-rSequence(slice):xList(slice)+rSequence(slice), zSequence(slice));
        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
    end

    function update_hpgauss
        figure(hpgauss)
        SforZ = zeros(info(1).Height, info(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+j, 'Info', info);
        end
        close(hpgauss)
        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);        
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
        B = SforZ(yList(slice)-rfSequence(slice):yList(slice)+rfSequence(slice), xList(slice)-rfSequence(slice):xList(slice)+rfSequence(slice), :); 
        d = double(B(rfSequence(slice)-rfSequence(slice)+1:rfSequence(slice)+rfSequence(slice)+1, rfSequence(slice)-rfSequence(slice)+1:rfSequence(slice)+rfSequence(slice)+1, zSequence(slice)));
        plotgaussfit_in_GUI([gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],d,pSize,'n');
        axis ([-rfSequence(slice)*pSize rfSequence(slice)*pSize -rfSequence(slice)*pSize rfSequence(slice)*pSize 0 max(imaxSequence)]);
        caxis ([min(iminSequence) max(imaxSequence)]);
    end

    function clean_hpzoom
        close(hpzoom)
        hpzoom = figure('Name','Z','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,545,161,185]);
    end

    function clean_hpgauss
        close(hpgauss)
        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
    end

    function slider1_Callback(slider1,eventdata,handles)
        % update the displayed image when the slider is adjusted
        slice = round(get(slider1,'Value'));
        a = (minSlice:maxSlice);
        Value1 = slice;
        [~,I] = min(abs(Value1-a));
        Value1 = a(I);
        set(slider1,'Value',Value1);
        slice = round(get(slider1,'Value'));
        set(plotinfo.s2,'String',Value1);
        if xList(slice) == 0 
            set(plotinfo.sx,'String','');
            set(plotinfo.sy,'String','');
            clean_hpzoom
        else
            set(plotinfo.sx,'String',['X = ' num2str(round(xList(slice)))]);
            set(plotinfo.sy,'String',['Y = ' num2str(round(yList(slice)))]);
            update_hpzoom
        end
        clean_hpgauss
        figure(hfig)
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,Value1),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            singleFrame = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+zSlice, 'Info', info);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushNEXTSpot_Callback(hObject, eventdata, handles)
        fullFilePathInput = fullfile(pathstr,[Sequence '_MULTIPLE_results' '.xls']);
        if exist(fullFilePathInput,'file') ~= 2
            warndlg('No results file!')
        else
            [num,~,~] = xlsread(fullFilePathInput,'Sheet1');
            n_dots = size(num,1);
            if ~(size(num,2) == 20 || size(num,2) == 13)
                warndlg('Results file does not have the right format')
            elseif dot_number+1 > n_dots
                warndlg('No more spots on results file!')
            elseif dot_number+1 <= n_dots
                if ~isnan(num(dot_number+1,1))
                    i_minSequence = NaN(1,n_dots);
                    i_maxSequence = NaN(1,n_dots);
                    x_Sequence = NaN(1,n_dots);
                    z_Sequence = NaN(1,n_dots);
                    y_Sequence = NaN(1,n_dots);
                    t_Sequence = NaN(1,n_dots);
                    rf_Sequence = NaN(1,n_dots);
                    r_Sequence = NaN(1,n_dots);
                    gM1_Sequence = NaN(1,n_dots);
                    gM2_Sequence = NaN(1,n_dots);
                    gM3_Sequence = NaN(1,n_dots);
                    gM4_Sequence = NaN(1,n_dots);
                    gM5_Sequence = NaN(1,n_dots);
                    gM6_Sequence = NaN(1,n_dots);
                    for i = 1:size(num,1)
                        if ~isnan(num(i,1))
                            i_minSequence(num(i,1)) = num(i,4);
                            i_maxSequence(num(i,1)) = num(i,5);
                            x_Sequence(num(i,1)) = num(i,6);
                            y_Sequence(num(i,1)) = num(i,7);
                            z_Sequence(num(i,1)) = num(i,8);
                            t_Sequence(num(i,1)) = num(i,9);
                            rf_Sequence(num(i,1)) = num(i,12);
                            r_Sequence(num(i,1)) = num(i,13);
                            if size(num,2) == 20
                                gM1_Sequence(num(i,1)) = num(i,15);
                                gM2_Sequence(num(i,1)) = num(i,16);
                                gM3_Sequence(num(i,1)) = num(i,17);
                                gM4_Sequence(num(i,1)) = num(i,18);
                                gM5_Sequence(num(i,1)) = num(i,19);
                                gM6_Sequence(num(i,1)) = num(i,20);
                            end
                        end
                    end
                    if ~isnan(num(dot_number+1,1))
                        zSlice = z_Sequence(dot_number+1);
                        set(slider1,'Value',t_Sequence(dot_number+1));
                        set(hinputZset,'String',num2str(zSlice));
                        set(slider3,'Value',zSlice);
                        if strcmp(bg.SelectedObject.String,'MIP')
                            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        elseif strcmp(bg.SelectedObject.String,'Slice')
                            singleFrame = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+zSlice, 'Info', info);
                            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        end
                        drawnow
                        slider1_Callback(slider1)
                        TFI = num(dot_number+1,2);
                        W = num(dot_number+1,3);
                        SforZ = zeros(info(1).Height, info(1).Width, num_images);
                        for j = 1:num_images
                            SforZ(:,:,j) = imread(fullfile(pathstr, [Sequence ext]),(t_Sequence(dot_number+1)-1)*num_images+j, 'Info', info);
                        end
                        B = SforZ(y_Sequence(dot_number+1)-rf_Sequence(dot_number+1):y_Sequence(dot_number+1)+rf_Sequence(dot_number+1), x_Sequence(dot_number+1)-rf_Sequence(dot_number+1):x_Sequence(dot_number+1)+rf_Sequence(dot_number+1), :);
                        d = double(B(1:rf_Sequence(dot_number+1)+rf_Sequence(dot_number+1)+1, 1:rf_Sequence(dot_number+1)+rf_Sequence(dot_number+1)+1,z_Sequence(dot_number+1)));
                        figure(hpgauss)
                        close(hpgauss)
                        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,545,221,185]);
                        hpgaussbuttons = findall(hpgauss);
                        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
                        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
                        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
                        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
                        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
                        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
                        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
                        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
                        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
                        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
                        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
                        set(hpgaussbutton1,'Visible','Off')
                        set(hpgaussbutton2,'Visible','Off')
                        set(hpgaussbutton4,'Visible','Off')
                        set(hpgaussbutton5,'Visible','Off')
                        set(hpgaussbutton7,'Visible','Off')
                        set(hpgaussbutton8,'Visible','Off')
                        set(hpgaussbutton9,'Visible','Off')
                        set(hpgaussbutton10,'Visible','Off')
                        set(hpgaussbutton11,'Visible','Off')
                        set(hpgaussbutton12,'Visible','Off')
                        set(hpgaussbutton13,'Visible','Off')
                        plotgaussfit_in_GUI([gM1_Sequence(dot_number+1) gM2_Sequence(dot_number+1) gM3_Sequence(dot_number+1) gM4_Sequence(dot_number+1) gM5_Sequence(dot_number+1) gM6_Sequence(dot_number+1)],d,pSize,'n');
                        I_MAX = max(i_maxSequence);
                        I_MIN = min(i_minSequence);
                        axis ([-rf_Sequence(dot_number+1)*pSize rf_Sequence(dot_number+1)*pSize -rf_Sequence(dot_number+1)*pSize rf_Sequence(dot_number+1)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        figure(hpzoom);
                        singleFrameZoom = SforZ(y_Sequence(dot_number+1)-r_Sequence(dot_number+1):y_Sequence(dot_number+1)+r_Sequence(dot_number+1), x_Sequence(dot_number+1)-r_Sequence(dot_number+1):x_Sequence(dot_number+1)+r_Sequence(dot_number+1),z_Sequence(dot_number+1));
                        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        dot_number = dot_number + 1;
                        set(editDot,'String',num2str(dot_number));
                        set(plotinfo.sDot,'String',['Spot ' num2str(round(dot_number))]);
                        set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI))]);
                        set(plotinfo.sI,'String',['W = ' num2str(W,3)]);
                        set(plotinfo.sZ,'String',['Z = ' num2str(round(z_Sequence(dot_number)))]);
                        figure(hfig)
                        rectangle('Position',[x_Sequence(dot_number)-(rf_Sequence(dot_number)+8)/2,y_Sequence(dot_number)-(rf_Sequence(dot_number)+8)/2,rf_Sequence(dot_number)+8,rf_Sequence(dot_number)+8],'Curvature',[1,1],'Edgecolor','w');
                        drawnow
                    end
                end
            end
        end
    end

    function pushPREVSpot_Callback(hObject, eventdata, handles)
        fullFilePathInput = fullfile(pathstr,[Sequence '_MULTIPLE_results' '.xls']);
        if exist(fullFilePathInput,'file') ~= 2
            warndlg('No results file!')
        else
            [num,~,~] = xlsread(fullFilePathInput,'Sheet1');
            n_dots = size(num,1);
            if ~(size(num,2) == 20 || size(num,2) == 13)
                warndlg('Results file does not have the right format')
            elseif dot_number == 1
                warndlg('You are already on the first spot!')
            elseif dot_number-1 > 0
                if ~isnan(num(dot_number-1,1))
                    i_minSequence = NaN(1,n_dots);
                    i_maxSequence = NaN(1,n_dots);
                    x_Sequence = NaN(1,n_dots);
                    z_Sequence = NaN(1,n_dots);
                    y_Sequence = NaN(1,n_dots);
                    t_Sequence = NaN(1,n_dots);
                    rf_Sequence = NaN(1,n_dots);
                    r_Sequence = NaN(1,n_dots);
                    gM1_Sequence = NaN(1,n_dots);
                    gM2_Sequence = NaN(1,n_dots);
                    gM3_Sequence = NaN(1,n_dots);
                    gM4_Sequence = NaN(1,n_dots);
                    gM5_Sequence = NaN(1,n_dots);
                    gM6_Sequence = NaN(1,n_dots);
                    for i = 1:size(num,1)
                        if ~isnan(num(i,1))
                            i_minSequence(num(i,1)) = num(i,4);
                            i_maxSequence(num(i,1)) = num(i,5);
                            x_Sequence(num(i,1)) = num(i,6);
                            y_Sequence(num(i,1)) = num(i,7);
                            z_Sequence(num(i,1)) = num(i,8);
                            t_Sequence(num(i,1)) = num(i,9);
                            rf_Sequence(num(i,1)) = num(i,12);
                            r_Sequence(num(i,1)) = num(i,13);
                            if size(num,2) == 20
                                gM1_Sequence(num(i,1)) = num(i,15);
                                gM2_Sequence(num(i,1)) = num(i,16);
                                gM3_Sequence(num(i,1)) = num(i,17);
                                gM4_Sequence(num(i,1)) = num(i,18);
                                gM5_Sequence(num(i,1)) = num(i,19);
                                gM6_Sequence(num(i,1)) = num(i,20);
                            end
                        end
                    end
                    if ~isnan(num(dot_number-1,1))
                        zSlice = z_Sequence(dot_number-1);
                        set(slider1,'Value',t_Sequence(dot_number-1));
                        set(hinputZset,'String',num2str(zSlice));
                        set(slider3,'Value',zSlice);
                        if strcmp(bg.SelectedObject.String,'MIP')
                            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        elseif strcmp(bg.SelectedObject.String,'Slice')
                            singleFrame = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+zSlice, 'Info', info);
                            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        end
                        himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        drawnow
                        slider1_Callback(slider1)
                        TFI = num(dot_number-1,2);
                        W = num(dot_number-1,3);
                        SforZ = zeros(info(1).Height, info(1).Width, num_images);
                        for j = 1:num_images
                            SforZ(:,:,j) = imread(fullfile(pathstr, [Sequence ext]),(t_Sequence(dot_number-1)-1)*num_images+j, 'Info', info);
                        end
                        B = SforZ(y_Sequence(dot_number-1)-rf_Sequence(dot_number-1):y_Sequence(dot_number-1)+rf_Sequence(dot_number-1), x_Sequence(dot_number-1)-rf_Sequence(dot_number-1):x_Sequence(dot_number-1)+rf_Sequence(dot_number-1), :);
                        d = double(B(1:rf_Sequence(dot_number-1)+rf_Sequence(dot_number-1)+1, 1:rf_Sequence(dot_number-1)+rf_Sequence(dot_number-1)+1,z_Sequence(dot_number-1)));
                        figure(hpgauss)
                        close(hpgauss)
                        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,545,221,185]);
                        hpgaussbuttons = findall(hpgauss);
                        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
                        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
                        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
                        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
                        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
                        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
                        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
                        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
                        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
                        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
                        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
                        set(hpgaussbutton1,'Visible','Off')
                        set(hpgaussbutton2,'Visible','Off')
                        set(hpgaussbutton4,'Visible','Off')
                        set(hpgaussbutton5,'Visible','Off')
                        set(hpgaussbutton7,'Visible','Off')
                        set(hpgaussbutton8,'Visible','Off')
                        set(hpgaussbutton9,'Visible','Off')
                        set(hpgaussbutton10,'Visible','Off')
                        set(hpgaussbutton11,'Visible','Off')
                        set(hpgaussbutton12,'Visible','Off')
                        set(hpgaussbutton13,'Visible','Off')
                        plotgaussfit_in_GUI([gM1_Sequence(dot_number-1) gM2_Sequence(dot_number-1) gM3_Sequence(dot_number-1) gM4_Sequence(dot_number-1) gM5_Sequence(dot_number-1) gM6_Sequence(dot_number-1)],d,pSize,'n');
                        I_MAX = max(i_maxSequence);
                        I_MIN = min(i_minSequence);
                        axis ([-rf_Sequence(dot_number-1)*pSize rf_Sequence(dot_number-1)*pSize -rf_Sequence(dot_number-1)*pSize rf_Sequence(dot_number-1)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        figure(hpzoom);
                        singleFrameZoom = SforZ(y_Sequence(dot_number-1)-r_Sequence(dot_number-1):y_Sequence(dot_number-1)+r_Sequence(dot_number-1), x_Sequence(dot_number-1)-r_Sequence(dot_number-1):x_Sequence(dot_number-1)+r_Sequence(dot_number-1),z_Sequence(dot_number-1));
                        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        dot_number = dot_number - 1;
                        set(editDot,'String',num2str(dot_number));
                        set(plotinfo.sDot,'String',['Spot ' num2str(round(dot_number))]);
                        set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI))]);
                        set(plotinfo.sI,'String',['W = ' num2str(W,3)]);
                        set(plotinfo.sZ,'String',['Z = ' num2str(round(z_Sequence(dot_number)))]);
                        figure(hfig)
                        rectangle('Position',[x_Sequence(dot_number)-(rf_Sequence(dot_number)+8)/2,y_Sequence(dot_number)-(rf_Sequence(dot_number)+8)/2,rf_Sequence(dot_number)+8,rf_Sequence(dot_number)+8],'Curvature',[1,1],'Edgecolor','w');
                        drawnow
                    end
                end
            end
        end
    end

    function slider2_Callback(slider2,eventdata,handles)
        %adjust image contrast
        newMax = get(slider2,'Value');
        slice = get(slider1,'Value');
        a = (minImg:maxImg);
        Value2 = round(newMax);
        [~,I] = min(abs(Value2-a));
        Value2 = a(I);
        set(slider2,'Value',Value2);
        if ~isnan(zSequence(slice))
            update_hpzoom
        end
        figure(hfig)
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            singleFrame = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+zSlice, 'Info', info);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function slider3_Callback(slider2,eventdata,handles)
        %adjust image contrast
        newZ = floor(get(slider3,'Value'));
        set(slider3,'Value',newZ);
        set(hinputZset,'String',num2str(newZ));
        slice = get(slider1,'Value');
        if xList(slice)~=0
            update_hpzoom
        end
        figure(hfig)
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            singleFrame = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+newZ, 'Info', info);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pixelInfo(hObj,~,~)
        % get coordinates of clicked pixel
        axesHandle  = get(hObj,'Parent');
        cp = get(axesHandle,'CurrentPoint');
        x = cp(1,1);
        y = cp(1,2);
        xi = round(x);
        yi = round(y);
        S_proj(:,:,slice) = S_proj_clean_for_fit(:,:,slice);
        if dot_number == 1
            S_proj(:,:,slice) = S_proj_clean(:,:,slice);
        end
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        stdmeanratio = str2num(get(hinputS,'String'));
        newZ = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            [x, y, z, detected] = track_xyz(xi,yi,r,stdmeanratio);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            [x, y, z, detected] = track_xynewZ(xi,yi,r,stdmeanratio,newZ);
        end
        set(slider3,'Value',z);
        xList(slice) = x;
        yList(slice) = y;
        zSequence(slice) = z;
        rSequence(slice) = r;
        rfSequence(slice) = rf;
        if strcmp(bg.SelectedObject.String,'MIP')
            set(hinputZset,'String',num2str(z));
        end
        set(plotinfo.sx,'String',['X = ' num2str(round(x))]);
        set(plotinfo.sy,'String',['Y = ' num2str(round(y))]);
        assignin('base','x',round(x));
        assignin('base','y',round(y));
        assignin('base','t',round(slice));
        if (y-r > 0) && (y+r < info(1).Height) && (x-r > 0) && (x+r < info(1).Height)
            S_proj(y-r-1:y+r+1, x-r-1, slice) = 2^16;
            S_proj(y-r-1:y+r+1, x+r+1, slice) = 2^16;
            S_proj(y-r-1, x-r-1:x+r+1, slice) = 2^16;
            S_proj(y+r+1, x-r-1:x+r+1, slice) = 2^16;
        else
            S_proj(yi-r-1:yi+r+1, xi-r-1, slice) = 2^16;
            S_proj(yi-r-1:yi+r+1, xi+r+1, slice) = 2^16;
            S_proj(yi-r-1, xi-r-1:xi+r+1, slice) = 2^16;
            S_proj(yi+r+1, xi-r-1:xi+r+1, slice) = 2^16;
        end
        update_hpzoom
        figure(hfig);
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,round(slice)),'DisplayRange',[minImg round(newMax)],'InitialMagnification',100,'parent',ha);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            singleFrame = imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+zSlice, 'Info', info);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        if detected == 1
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','g');
            drawnow
        else
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','r');
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushDot_Callback(pushDot,eventdata,handles)
        %Gaussian Fitting
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        stdmeanratio = str2num(get(hinputS,'String'));
        fwhm = str2num(get(hinputFWHM,'String'));
        filterSpot = get(checkFilter,'Value');
        x = evalin('base','x');
        y = evalin('base','y');
        newZ = get(slider3,'Value');
        t = evalin('base','t');
        if strcmp(bg.SelectedObject.String,'MIP')
            [~, ~, ~, detected] = track_xyz(x,y,r,stdmeanratio);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            [~, ~, ~, detected] = track_xynewZ(x,y,r,stdmeanratio,newZ);
        end
        noGraph = get(checkGraph,'Value');
        ignoreZ = get(checkZ,'Value');
        if x == 0 && y == 0
            warndlg('No XY coordinates for fitting!')
        else
            update_hpzoom
            if (filterSpot == 1) && (detected == 0)
                TFI = 0;
                W = 0;
                rSequence(slice) = r;
                rfSequence(slice) = rf;
                iminSequence(slice) = NaN;
                imaxSequence(slice) = NaN;
                gM1Sequence(slice) = NaN;
                gM2Sequence(slice) = NaN;
                gM3Sequence(slice) = NaN;
                gM4Sequence(slice) = NaN;
                gM5Sequence(slice) = NaN;
                gM6Sequence(slice) = NaN;
            else
                zset = str2num(get(hinputZset,'String'));
                [TFI, W, I_MIN, I_MAX, gM1, gM2, gM3, gM4, gM5, gM6, d, rf] = dot_3D_z_v12(pathstr,[Sequence ext],slice,num_images,pSize,r,rf,fwhm,zset,ignoreZ,noGraph,xList(slice),yList(slice),zSequence(slice),iminSequence,imaxSequence);
                rSequence(slice) = r;
                rfSequence(slice) = rf;
                iminSequence(slice) = I_MIN;
                imaxSequence(slice) = I_MAX;
                gM1Sequence(slice) = gM1;
                gM2Sequence(slice) = gM2;
                gM3Sequence(slice) = gM3;
                gM4Sequence(slice) = gM4;
                gM5Sequence(slice) = gM5;
                gM6Sequence(slice) = gM6;
            end
            set(hinputZset,'String',num2str(zSequence(slice)));  
            set(plotinfo.sDot,'String',['Spot ' num2str(round(dot_number))]);
            set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI))]);
            set(plotinfo.sI,'String',['W = ' num2str(W,3)]);
            set(plotinfo.sZ,'String',['Z = ' num2str(round(zset))]);
            fullFilePathOutput = fullfile(pathstr,[Sequence '_MULTIPLE_results' '.xls']);
            xlswrite(fullFilePathOutput,{'Spot Number', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 't', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
            if ignoreZ == 1
                ignoreString = {'Yes'};
            elseif ignoreZ == 0
                ignoreString = {'No'};
            end
            xlswrite(fullFilePathOutput,[dot_number TFI W iminSequence(slice) imaxSequence(slice) x y zSequence(slice) t detected fwhm rfSequence(slice) rSequence(slice) ignoreString gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],'Sheet1',['A' num2str(dot_number+1)]);
            dot_number = dot_number + 1;
            set(editDot,'String',num2str(dot_number));
            S_proj_clean_for_fit(:,:,slice) = S_proj(:,:,slice);
            if ~isnan(gM1)
                update_hpgauss
            else
                clean_hpgauss
            end
            figure(hfig);
        end
    end

    function pushAutoDetect_Callback(pushDot,eventdata,handles)
        %automatically detects spots on nuclei
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        newZ = get(slider3,'Value');
        stdmeanratio = str2num(get(hinputS,'String'));
        slice = round(get(slider1,'Value'));
        if strcmp(bg.SelectedObject.String,'MIP')
            [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
            drawnow
        elseif strcmp(bg.SelectedObject.String,'Slice')
            SforZ = double(imread(fullfile(pathstr, [Sequence ext]),(slice-1)*num_images+newZ, 'Info', info));
            [pks] = dot_detect_MIP(SforZ,rf);
            himage = imshow(SforZ,'DisplayRange',[minImg newMax],'InitialMagnification',100);
            drawnow
        end
        if ~isempty(pks)
            for j = 1:length(pks(:,1))
                if strcmp(bg.SelectedObject.String,'MIP')
                    [~, ~, ~, detected] = track_xyz(round(pks(j,1)),round(pks(j,2)),r,stdmeanratio);
                elseif strcmp(bg.SelectedObject.String,'Slice')
                    [~, ~, ~, detected] = track_xynewZ(round(pks(j,1)),round(pks(j,2)),r,stdmeanratio,newZ);
                end
                if detected == 1
                    rectangle('Position',[pks(j,1)-(rf+8)/2,pks(j,2)-(rf+8)/2,rf+8,rf+8],'Curvature',[1,1],'Edgecolor','g');
                end
            end
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushAutoFIT_Callback(pushDot,eventdata,handles)
        %automatically detects spots on nuclei
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        stdmeanratio = str2num(get(hinputS,'String'));
        bg.SelectedObject = bgMIP;
        pushAutoDetect_Callback
        [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
        slice = round(get(slider1,'Value'));
        assignin('base','t',round(slice));       
        if ~isempty(pks)
            for j = 1:length(pks(:,1))
                rSequence(slice) = r;
                assignin('base','x',round(pks(j,1)));
                xList(slice) = round(pks(j,1));
                assignin('base','y',round(pks(j,2)));
                yList(slice) = round(pks(j,2));
                [~, ~, z, detected] = track_xyz(xList(slice),yList(slice),r,stdmeanratio);
                zSequence(slice) = z;
                set(hinputZset,'String',num2str(zSequence(slice)));  
                if detected == 1
                    rectangle('Position',[pks(j,1)-(rf+8)/2,pks(j,2)-(rf+8)/2,rf+8,rf+8],'Curvature',[1,1],'Edgecolor','w');
                    pushDot_Callback
                end
                drawnow
            end
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function AutoFitAll_Callback(hObject, eventdata, handles)
        for i = 1:maxSlice
            set(slider1,'Value',i);
            slider1_Callback(slider1)
            pushAutoFIT_Callback
            figure(hfig)
        end
         warndlg('All Done!')
         set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushEXPORTFIGURES_Callback(hObject, eventdata, handles)
        if dot_number == 0
            warndlg('No Gaussian Fits to export!')
        else
            fullFilePathInput = fullfile(pathstr,[Sequence '_MULTIPLE_results' '.xls']);
            [num,txt,raw] = xlsread(fullFilePathInput,'Sheet1');
            n_dots = size(num,1);
            i_minSequence = NaN(1,n_dots);
            i_maxSequence = NaN(1,n_dots);
            x_Sequence = NaN(1,n_dots);
            y_Sequence = NaN(1,n_dots);
            z_Sequence = NaN(1,n_dots);
            t_Sequence = NaN(1,n_dots);
            rf_Sequence = NaN(1,n_dots);
            gM1_Sequence = NaN(1,n_dots);
            gM2_Sequence = NaN(1,n_dots);
            gM3_Sequence = NaN(1,n_dots);
            gM4_Sequence = NaN(1,n_dots);
            gM5_Sequence = NaN(1,n_dots);
            gM6_Sequence = NaN(1,n_dots);
            if size(num,2) == 20
                for i = 1:size(num,1)
                    if ~isnan(num(i,1))
                        i_minSequence(num(i,1)) = num(i,4);
                        i_maxSequence(num(i,1)) = num(i,5);
                        x_Sequence(num(i,1)) = num(i,6);
                        y_Sequence(num(i,1)) = num(i,7);
                        z_Sequence(num(i,1)) = num(i,8);
                        t_Sequence(num(i,1)) = num(i,9);
                        rf_Sequence(num(i,1)) = num(i,12);
                        gM1_Sequence(num(i,1)) = num(i,15);
                        gM2_Sequence(num(i,1)) = num(i,16);
                        gM3_Sequence(num(i,1)) = num(i,17);
                        gM4_Sequence(num(i,1)) = num(i,18);
                        gM5_Sequence(num(i,1)) = num(i,19);
                        gM6_Sequence(num(i,1)) = num(i,20);
                    end
                end
                for i = 1:size(num,1)
                    if ~isnan(num(i,1))
                        SforZ = zeros(info(1).Height, info(1).Width, num_images);
                        for j = 1:num_images
                            SforZ(:,:,j) = imread(fullfile(pathstr, [Sequence ext]),(t_Sequence(i)-1)*num_images+j, 'Info', info);
                        end
                        B = SforZ(y_Sequence(i)-rf_Sequence(i):y_Sequence(i)+rf_Sequence(i), x_Sequence(i)-rf_Sequence(i):x_Sequence(i)+rf_Sequence(i), :);
                        d = double(B(1:rf_Sequence(i)+rf_Sequence(i)+1, 1:rf_Sequence(i)+rf_Sequence(i)+1, z_Sequence(i)));
                        figure(hpgauss)
                        close(hpgauss)
                        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,545,221,185]);
                        plotgaussfit_in_GUI([gM1_Sequence(i) gM2_Sequence(i) gM3_Sequence(i) gM4_Sequence(i) gM5_Sequence(i) gM6_Sequence(i)],d,pSize,'n');
                        I_MAX = max(i_maxSequence);
                        I_MIN = min(i_minSequence);
                        axis ([-rf_Sequence(i)*pSize rf_Sequence(i)*pSize -rf_Sequence(i)*pSize rf_Sequence(i)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        fullFilePathOutput = fullfile(pathstr,[Sequence '_GAUSSIAN_FIT_spot_' num2str(i) '.tif']);
                        figure(hpgauss);
                        export_fig(fullFilePathOutput,'-m2.5','-r300');
                        fullFilePathOutput = fullfile(pathstr,[Sequence '_ZOOM_Z_spot_' num2str(i) '.tif']);
                        figure(hpzoom);
                        singleFrameZoom = SforZ(y_Sequence(i)-rf_Sequence(i):y_Sequence(i)+rf_Sequence(i), x_Sequence(i)-rf_Sequence(i):x_Sequence(i)+rf_Sequence(i), z_Sequence(i));
                        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        export_fig(fullFilePathOutput,'-m2.5','-r300');
                    end
                end
            end
            clean_hpgauss
            clean_hpzoom
            figure(hfig)
        end
    end

    function inputR_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
    end

    function inputStdmeanratio_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
    end

    function inputRf_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
        rfSequence(slice) = input/2;
    end

    function inputFWHM_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0.5')
        end
        grid_size = ceil(input/pSize)*2;
        rfSequence(slice) = grid_size/2;
        set(hinputRf,'String',num2str(rfSequence(slice)*2));
    end

    function inputZset_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','1')
        end
        if input > 0 && input <= num_images
            zSequence(slice) = input;
            set(slider3,'Value',input);
            slider3_Callback
        elseif input > num_images
            zSequence(slice) = num_images;
            set(slider3,'Value',num_images);
            slider3_Callback
        end
        figure(hfig);
    end

    function editDot_Callback(editDot,eventdata,handles)
        dot_number = str2num(get(editDot,'String'));
        set(editDot,'String',num2str(dot_number));
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushEND_Callback(hObject, eventdata, handles)
        close(hfig);
        close(hpzoom);
        close(hpgauss);
    end

end