function interfaceImage2D_timelapse_v6(pathstr,Sequence,ext,info,dotNumber,n,pSize)

S_proj = zeros(info(1).Height, info(1).Width, n);
ho = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
for k = 1:n
    waitbar(k/n,ho,sprintf('Loading image from timepoint %d of %d',k,n))
    S_proj(:,:,k) = imread(fullfile(pathstr, [Sequence ext]),k, 'Info', info);
end
xList = zeros(1,n);
yList = zeros(1,n);
tfiSequence = NaN(1,n);
wSequence = NaN(1,n);
iminSequence = NaN(1,n);
imaxSequence = NaN(1,n);
gM1Sequence = NaN(1,n);
gM2Sequence = NaN(1,n);
gM3Sequence = NaN(1,n);
gM4Sequence = NaN(1,n);
gM5Sequence = NaN(1,n);
gM6Sequence = NaN(1,n);
zSequence = NaN(1,n);
rSequence = zeros(1,n);
rfSequence = zeros(1,n);
filterSequence = NaN(1,n);
close(ho)

sizeImg = size(S_proj);
minImg = min(min(min(S_proj)));
maxImg = max(max(max(S_proj)));
minSlice = 1;
if numel(sizeImg) == 3
    maxSlice = sizeImg(3);
else
    maxSlice = 1;
end
startSlice = 1;

if sizeImg(1) ~= sizeImg(2)
    S_proj_new = ones(max(sizeImg(1),sizeImg(2)), max(sizeImg(1),sizeImg(2)), maxSlice)*minImg;
    S_proj_new(1:sizeImg(1),1:sizeImg(2),:) = S_proj;
    S_proj = S_proj_new;
end

S_proj_clean = S_proj;

% Create a figure for TFI Plot
hpp = figure('Name','TFI Plot over time','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,100,400,125]);

% Create a figure for W Plot
hpw = figure('Name','W Plot over time','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,265,400,100]);
        
% Create a figure for zoomed image
hpzoom = figure('Name','Z','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,545,161,185]);
        
% Create a figure for Gaussian Fit
hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure',...
            'Menubar','none','Position',[1116,545,221,185]); 
hpgaussbuttons = findall(hpgauss);
hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(hpgaussbutton1,'Visible','Off')
set(hpgaussbutton2,'Visible','Off')
set(hpgaussbutton4,'Visible','Off')
set(hpgaussbutton5,'Visible','Off')
set(hpgaussbutton7,'Visible','Off')
set(hpgaussbutton8,'Visible','Off')
set(hpgaussbutton9,'Visible','Off')
set(hpgaussbutton10,'Visible','Off')
set(hpgaussbutton11,'Visible','Off')
set(hpgaussbutton12,'Visible','Off')
set(hpgaussbutton13,'Visible','Off')
        
% Create a figure without toolbar and menubar
hfig = figure('Toolbar','figure',...
    'Menubar','none',...
    'Name','Timelapse Viewer - Single Spot 2D (single channel)',...
    'Position',[20,100,900,630],...
    'NumberTitle','off',...
    'IntegerHandle','off');
hfigbuttons = findall(hfig);
button1 = findall(hfigbuttons,'ToolTipString','New Figure');
button2 = findall(hfigbuttons,'ToolTipString','Open File');
button3 = findall(hfigbuttons,'ToolTipString','Save Figure');
button4 = findall(hfigbuttons,'ToolTipString','Print Figure');
button5 = findall(hfigbuttons,'ToolTipString','Edit Plot');
button6 = findall(hfigbuttons,'ToolTipString','Rotate 3D');
button7 = findall(hfigbuttons,'ToolTipString','Data Cursor');
button8 = findall(hfigbuttons,'ToolTipString','Brush/Select Data');
button9 = findall(hfigbuttons,'ToolTipString','Link Plot');
button10 = findall(hfigbuttons,'ToolTipString','Insert Colorbar');
button11 = findall(hfigbuttons,'ToolTipString','Insert Legend');
button12 = findall(hfigbuttons,'ToolTipString','Hide Plot Tools');
button13 = findall(hfigbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(button1,'Visible','Off')
set(button2,'Visible','Off')
set(button3,'Visible','Off')
set(button4,'Visible','Off')
set(button5,'Visible','Off')
set(button6,'Visible','Off')
set(button7,'Visible','Off')
set(button8,'Visible','Off')
set(button9,'Visible','Off')
set(button10,'Visible','Off')
set(button11,'Visible','Off')
set(button12,'Visible','Off')
set(button13,'Visible','Off')

hpanel1 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Spot Tracking',...
    'Clipping','on',...
    'Position',[10 12 30 6.69230769230769]);

htextR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 2.69230769230769 17.2 1.84615384615385],...
'String','Search Radius',...
'Style','text',...
'Tag','text4');

hinputR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 3.07692307692308 5.4 1.53846153846154],...
'String','6',...
'Style','edit',...
'Tag','inputR',...
'Callback',@inputR_Callback);

htextS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.3 0.466153846153846 17.4 1.85615384615385],...
'String','Sensitivity ',...
'Style','text',...
'Tag','text5');

hinputS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 1.015384615384615 5.4 1.43846153846154],...
'String','10',...
'Style','edit',...
'Tag','inputStdmeanratio',...
'Callback',@inputStdmeanratio_Callback);

hpanel2 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Gaussian Fitting',...
    'Clipping','on',...
    'Position',[146 38 30 8]);

htextFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 3.19230769230769 17.2 1.84615384615385],...
'String','PSF FWHM',...
'Style','text',...
'Tag','textRf');

hinputFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 3.68692307692308 7.4 1.53846153846154],...
'String','0.500',...
'Style','edit',...
'Tag','inputRf',...
'Callback',@inputFWHM_Callback);

htextRf = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 0.69230769230769 17.2 1.84615384615385],...
'String','Grid Size',...
'Style','text',...
'Tag','textRf');

hinputRf = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 1.07692307692308 5.4 1.53846153846154],...
'String','6',...
'Style','edit',...
'Tag','inputRf',...
'Callback',@inputRf_Callback);

if maxSlice > 1
    sliceRange = maxSlice - minSlice;
else
    sliceRange = 1;
end

slider1 = uicontrol(hfig,'Style','slider',...
    'Min',minSlice,'Max',maxSlice,...
    'Position',[20,30,185,20],...
    'SliderStep',[1/sliceRange 5/sliceRange],...
    'Callback',@slider1_Callback);

set(slider1,'Value',startSlice);

slider2 = uicontrol(hfig,'Style','slider',...
    'Min',minImg,'Max',maxImg,...
    'Position',[20,60,20,185],...
    'SliderStep',[10/(maxImg-minImg) 50/(maxImg-minImg)],...
    'Callback',@slider2_Callback);

set(slider2,'Value',maxImg);

slice = round(get(slider1,'Value'));

newMax = round(get(slider2,'Value'));

plotinfo.s1 = uicontrol(hfig,'Style','text',...
    'String','Timepoint',...
    'Position',[130,50,48,20]);

plotinfo.s2 = uicontrol(hfig,'Style','text',...
    'String',num2str(slice),...
    'Position',[180,50,25,20]);

plotinfo.s3 = uicontrol(hfig,'Style','text',...
    'String','MAX',...
    'Position',[15,245,30,20]);

checkTrack = uicontrol('Style', 'checkbox',...
    'Position',[110 260 86 30],...
    'FontSize',10,...
    'String','Track Spot',...
    'Value',1);

checkFilter = uicontrol('Style', 'checkbox',...
    'Position',[55 260 50 30],...
    'FontSize',10,...
    'String','Filter',...
    'Value',1);

checkGraph = uicontrol('Style', 'checkbox',...
    'Position',[740 340 150 20],...
    'FontSize',10,...
    'String','Hide Gaussian Fit');

plotinfo.sTFI = uicontrol(hfig,'Style','text',...
    'Position',[750,205,120,20],...
    'FontWeight','bold',...
    'FontSize',11,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sI = uicontrol(hfig,'Style','text',...
    'Position',[750,185,120,20],...
    'FontWeight','bold',...
    'FontSize',11,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sxytitle = uicontrol(hfig,'Style','text',...
    'Position',[40,105,160,40],...
    'String','Click on image to get XY coordinates',...
    'FontWeight','bold',...
    'FontSize',9);

plotinfo.sx = uicontrol(hfig,'Style','text',...
    'Position',[50,85,80,20],...
    'FontSize',10);

plotinfo.sy = uicontrol(hfig,'Style','text',...
    'Position',[120,85,80,20],...
    'FontSize',10);

plotinfo.lasttfi = uicontrol(hfig,'Style','text',...
    'Position',[40,470,160,40],...
    'HorizontalAlignment','left',...
    'FontWeight','bold',...
    'FontSize',10);

plotinfo.slastTFI = uicontrol(hfig,'Style','text',...
    'Position',[40,470,120,20],...
    'FontSize',11,...
    'HorizontalAlignment','left');

plotinfo.slastI = uicontrol(hfig,'Style','text',...
    'Position',[40,450,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',11);

plotinfo.nexttfi = uicontrol(hfig,'Style','text',...
    'Position',[40,375,160,40],...
    'HorizontalAlignment','left',...
    'FontWeight','bold',...
    'FontSize',10);

plotinfo.snextTFI = uicontrol(hfig,'Style','text',...
    'Position',[40,375,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',11);

plotinfo.snextI = uicontrol(hfig,'Style','text',...
    'Position',[40,355,120,20],...
    'HorizontalAlignment','left',...
    'FontSize',11);

pushSaveXY = uicontrol('Style', 'pushbutton',...
    'Position',[5 565 100 30],...
    'FontWeight','bold',...
    'FontSize',9,...
    'String','Save XY Data',...
    'Callback',@pushSaveXY_Callback);

pushLoad = uicontrol('Style', 'pushbutton',...
    'Position',[105 565 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Load Data',...
    'Callback',@pushLoad_Callback);

pushClear = uicontrol('Style', 'pushbutton',...
    'Position',[5 530 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Clear All',...
    'Callback',@pushClear_Callback);

pushKeepXY = uicontrol('Style', 'pushbutton',...
    'Position',[105 530 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Clear TFI',...
    'Callback',@pushClearTFI_Callback);

pushAutoTrack = uicontrol('Style', 'pushbutton',...
    'Position',[110 290 84 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Track',...
    'Callback',@pushAutoTrack_Callback);

pushAutoDetect = uicontrol('Style', 'pushbutton',...
    'Position',[20 290 90 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Detect',...
    'Callback',@pushAutoDetect_Callback);

pushDot = uicontrol('Style', 'pushbutton',...
    'Position',[760 240 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Gaussian Fit',...
    'Callback',@pushDot_Callback);

pushZero = uicontrol('Style', 'pushbutton',...
    'Position',[738 115 70 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','TFI = 0',...
    'Callback',@pushZero_Callback);

pushNaN = uicontrol('Style', 'pushbutton',...
    'Position',[813 115 70 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Discard',...
    'Callback',@pushNaN_Callback);

pushAUTO = uicontrol('Style', 'pushbutton',...
    'Position',[760 80 100 30],...
    'FontWeight','bold',...
    'FontSize',12,...
    'ForegroundColor',[0 0.498 0],...
    'String','AUTO FIT',...
    'Callback',@pushAUTO_Callback);

pushEXPORTFIGURES = uicontrol('Style', 'pushbutton',...
    'Position',[750 45 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Export Figures',...
    'Callback',@pushEXPORTFIGURES_Callback);

pushEND = uicontrol('Style', 'pushbutton',...
    'Position',[750 10 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0.043 0.518 0.78],...
    'String','END Timelapse',...
    'Callback',@pushEND_Callback);

ha = axes('units','pixels','position',[210 59 512 512]);
himage = imshow(S_proj(:,:,round(slice)),...
        'DisplayRange',[minImg round(newMax)],...
        'InitialMagnification',100,'parent',ha);
set(hfig,'WindowButtonMotionFcn',@changepointer)
set(himage,'ButtonDownFcn',@pixelInfo)

    function changepointer(hObj,handles)
        %change pointer to crosshair when hovering himage
        axlim = get(ha,'Position');
        fglim = get(hfig,'Position');
        x1 = axlim(1) + fglim(1);
        x2 = (axlim(1)+axlim(3)) + fglim(1);
        y1 = axlim(2) + fglim(2);
        y2 = (axlim(2)+axlim(4)) + fglim(2);
        pntr = get(0,'PointerLocation');
        if pntr(1)>x1 && pntr(1)<x2 && pntr(2)>y1 && pntr(2)<y2
            set(hfig,'Pointer','crosshair')
        else
            set(hfig,'Pointer','arrow')
        end
    end

    function [x, y, detected] = track_xy(xi,yi,r,stdmeanratio)
        %track (x,y) coordinates from (xi,yi) depending on stdmeanratio 
        B = S_proj(yi-r:yi+r, xi-r:xi+r, slice);
        rf = str2num(get(hinputRf,'String'))/2;
        [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
        if ~isempty(pks)
            D = pdist2([xi,yi],pks);
            i_min = find(D == min(D));
            if min(D) <= 2*r && (max(max(std(double(B)))) > mean(mean(mean(double(B))))/stdmeanratio)
                detected = 1;
                x = pks(i_min,1);
                y = pks(i_min,2);
            else
                detected = 0;
                x = xi;
                y = yi;
            end
        else
            detected = 0;
            x = xi;
            y = yi;
        end
    end       

    function update_hpp
        figure(hpp)
        plot(tfiSequence,'-bo','LineWidth',1.5,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',4.5);
        hold on;
        plot(slice,tfiSequence(slice),'o','MarkerSize',6.5,'LineWidth',1.5,'MarkerEdgeColor','r');
        hold off;
        xlabel('Timepoint','FontSize',10);
        ylabel('TFI');
        axis([1 length(tfiSequence) 0 max(tfiSequence)+200]);
        hpp.Renderer = 'painters';
    end

    function update_hpw
        figure(hpw)
        plot(wSequence,'-ko','LineWidth',1.5,'MarkerEdgeColor','k','MarkerFaceColor','k','MarkerSize',3.5);
        hold on;
        plot(slice,wSequence(slice),'o','MarkerSize',5.5,'LineWidth',1.5,'MarkerEdgeColor','r');
        hold off;
        ylabel('W');
        axis([1 length(wSequence) 0 max(wSequence)+0.05]);
        hpw.Renderer = 'painters';
    end

    function update_hpzoom
        figure(hpzoom)
        singleFrameZoom = S_proj_clean(yList(slice)-rSequence(slice):yList(slice)+rSequence(slice), xList(slice)-rSequence(slice):xList(slice)+rSequence(slice), slice);
        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
    end

    function update_hpgauss
        figure(hpgauss)
        close(hpgauss)
        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);        
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
        B = S_proj_clean(yList(slice)-rfSequence(slice):yList(slice)+rfSequence(slice), xList(slice)-rfSequence(slice):xList(slice)+rfSequence(slice), slice);
        d = double(B(rfSequence(slice)-rfSequence(slice)+1:rfSequence(slice)+rfSequence(slice)+1, rfSequence(slice)-rfSequence(slice)+1:rfSequence(slice)+rfSequence(slice)+1));
        plotgaussfit_in_GUI([gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],d,pSize,'n');
        axis ([-rfSequence(slice)*pSize rfSequence(slice)*pSize -rfSequence(slice)*pSize rfSequence(slice)*pSize 0 max(imaxSequence)]);
        caxis ([min(iminSequence) max(imaxSequence)]);
    end

    function update_xy_text
        if (xList(slice) > 0 && yList(slice) > 0)
            set(plotinfo.sx,'String',['X = ' num2str(xList(slice))]);
            set(plotinfo.sy,'String',['Y = ' num2str(yList(slice))]);
        else
            set(plotinfo.sx,'String','');
            set(plotinfo.sy,'String','');
        end
    end

    function update_previous_text
        if ~isnan(tfiSequence(slice-1))
            set(plotinfo.lasttfi,'String','Previous Timepoint');
            set(plotinfo.slastTFI,'String',['TFI = ' num2str(round(tfiSequence(slice-1)))]);
            set(plotinfo.slastI,'String',['W = ' num2str(wSequence(slice-1),3)]);
        else
            set(plotinfo.lasttfi,'String','');
            set(plotinfo.slastTFI,'String','');
            set(plotinfo.slastI,'String','');
        end
    end

    function update_next_text
        if ~isnan(tfiSequence(slice+1))
            set(plotinfo.nexttfi,'String','Next Timepoint');
            set(plotinfo.snextTFI,'String',['TFI = ' num2str(round(tfiSequence(slice+1)))]);
            set(plotinfo.snextI,'String',['W = ' num2str(wSequence(slice+1),3)]);
        else
            set(plotinfo.nexttfi,'String','');
            set(plotinfo.snextTFI,'String','');
            set(plotinfo.snextI,'String','');
        end
    end

    function clean_hpp
        close(hpp)
        hpp = figure('Name','TFI Plot over time','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,100,400,125]);
    end

    function clean_hpw
        close(hpw)
        hpw = figure('Name','W Plot over time','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,265,400,100]);
    end

    function clean_hpzoom
        close(hpzoom)
        hpzoom = figure('Name','Z','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,545,161,185]);
    end

    function clean_hpgauss
        close(hpgauss)
        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
    end

    function slider1_Callback(slider1,eventdata,handles)
        % update the displayed image when the slider is adjusted
        slice = round(get(slider1,'Value'));
        a = (minSlice:maxSlice);
        Value1 = slice;
        [~,I] = min(abs(Value1-a));
        Value1 = a(I);
        set(slider1,'Value',Value1);
        slice = round(get(slider1,'Value'));
        set(plotinfo.s2,'String',Value1);
        if isnan(tfiSequence(slice))
            set(plotinfo.sTFI,'String','');
            set(plotinfo.sI,'String','');
        else
            set(plotinfo.sTFI,'String',['TFI = ' num2str(round(tfiSequence(slice)))]);
            set(plotinfo.sI,'String',['W = ' num2str(wSequence(slice),3)]);
        end
        if slice > 1 && slice < n
            update_previous_text
            update_next_text
        elseif slice == 1
            set(plotinfo.lasttfi,'String','');
            set(plotinfo.slastTFI,'String','');
            set(plotinfo.slastI,'String','');
            update_next_text
        elseif slice == n
            update_previous_text
            set(plotinfo.nexttfi,'String','');
            set(plotinfo.snextTFI,'String','');
            set(plotinfo.snextI,'String','');
        end
        if slice > 1 && get(checkTrack,'Value')
            if xList(slice) == 0 && yList(slice) == 0 && xList(slice-1) > 0 && yList(slice-1) > 0
                S_proj(:,:,slice) = S_proj_clean(:,:,slice);
                xi = xList(slice-1);
                yi = yList(slice-1);
                if rSequence(slice) == 0 && rSequence(slice-1) > 0
                    r = rSequence(slice-1);
                else
                    r = str2num(get(hinputR,'String'));
                end
                if rfSequence(slice) == 0
                    rf = rfSequence(slice-1);
                else
                    rf = rfSequence(slice);
                end
                stdmeanratio = str2num(get(hinputS,'String'));
                [x, y, detected] = track_xy(xi,yi,r,stdmeanratio);
                if (y-r > 0) && (y+r < info(1).Height) && (x-r > 0) && (x+r < info(1).Height)
                    filterSequence(slice) = detected;
                    xList(slice) = x;
                    yList(slice) = y;
                    rSequence(slice) = r;
                    rfSequence(slice) = rf;
                    set(hinputR,'String',num2str(rSequence(slice)));
                    set(hinputRf,'String',num2str(rfSequence(slice)*2));
                    set(plotinfo.sx,'String',['X = ' num2str(x)]);
                    set(plotinfo.sy,'String',['Y = ' num2str(y)]);
                    S_proj(y-r-1:y+r+1, x-r-1, slice) = 2^16;
                    S_proj(y-r-1:y+r+1, x+r+1, slice) = 2^16;
                    S_proj(y-r-1, x-r-1:x+r+1, slice) = 2^16;
                    S_proj(y+r+1, x-r-1:x+r+1, slice) = 2^16;
                else
                    xList(slice) = 0;
                    yList(slice) = 0;
                end
                figure(hfig);
            else
                update_xy_text
            end
        else
            update_xy_text
        end
        if ~isnan(round(max(wSequence)))
            update_hpw
        else
            clean_hpw
        end
        if ~isnan(round(max(tfiSequence)))
            update_hpp
        else
            clean_hpp
        end
        if ~isnan(gM1Sequence(slice))
            update_hpgauss
        else
            clean_hpgauss
        end
        figure(hfig);
        if xList(slice) ~= 0
            update_hpzoom
        else
            clean_hpzoom
        end
        figure(hfig);
        if rSequence(slice) > 0
            set(hinputR,'String',num2str(rSequence(slice)));
        end
        if rfSequence(slice) > 0
            set(hinputRf,'String',num2str(rfSequence(slice)*2));
        end
        himage = imshow(S_proj(:,:,Value1),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        if filterSequence(slice) == 1
            rectangle('Position',[xList(slice)-rSequence(slice),yList(slice)-rSequence(slice),2*rSequence(slice),2*rSequence(slice)],'Curvature',[1,1],'Edgecolor','g');
            drawnow
        else
            rectangle('Position',[xList(slice)-rSequence(slice),yList(slice)-rSequence(slice),2*rSequence(slice),2*rSequence(slice)],'Curvature',[1,1],'Edgecolor','r');
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function slider2_Callback(slider2,eventdata,handles)
        %adjust image contrast
        newMax = round(get(slider2,'Value'));
        slice = get(slider1,'Value');
        a = (minImg:maxImg);
        Value2 = round(newMax);
        [~,I] = min(abs(Value2-a));
        Value2 = a(I);
        set(slider2,'Value',Value2);
        if xList(slice) ~= 0
            update_hpzoom
        end
        figure(hfig)
        himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pixelInfo(hObj,~,~)
        % get coordinates of clicked pixel
        axesHandle  = get(hObj,'Parent');
        cp = get(axesHandle,'CurrentPoint');
        x = cp(1,1);
        y = cp(1,2);
        xi = round(x);
        yi = round(y);
        S_proj(:,:,slice) = S_proj_clean(:,:,slice);
        if rSequence(slice) == 0
            r = str2num(get(hinputR,'String'));
        else
            r = rSequence(slice);
        end
        if rfSequence(slice) == 0 || isnan(rfSequence(slice))
            rf = str2num(get(hinputRf,'String'))/2;
            rfSequence(slice) = rf;
        else
            rf = rfSequence(slice);
        end
        stdmeanratio = str2num(get(hinputS,'String'));
        [x, y, detected] = track_xy(xi,yi,r,stdmeanratio);
        filterSequence(slice) = detected;
        xList(slice) = x;
        yList(slice) = y;
        rSequence(slice) = r;
        rfSequence(slice) = rf;
        set(hinputR,'String',num2str(rSequence(slice)));
        set(hinputRf,'String',num2str(rfSequence(slice)*2));
        set(plotinfo.sx,'String',['X = ' num2str(x)]);
        set(plotinfo.sy,'String',['Y = ' num2str(y)]);
        if (y-r > 0) && (y+r < info(1).Height) && (x-r > 0) && (x+r < info(1).Height)
            S_proj(y-r-1:y+r+1, x-r-1, slice) = 2^16; 
            S_proj(y-r-1:y+r+1, x+r+1, slice) = 2^16;
            S_proj(y-r-1, x-r-1:x+r+1, slice) = 2^16; 
            S_proj(y+r+1, x-r-1:x+r+1, slice) = 2^16;
        else
            S_proj(yi-r-1:yi+r+1, xi-r-1, slice) = 2^16; 
            S_proj(yi-r-1:yi+r+1, xi+r+1, slice) = 2^16;
            S_proj(yi-r-1, xi-r-1:xi+r+1, slice) = 2^16; 
            S_proj(yi+r+1, xi-r-1:xi+r+1, slice) = 2^16;
        end
        if ~isnan(xList(slice))
            update_hpzoom
        end
        figure(hfig);
        himage = imshow(S_proj(:,:,round(slice)),...
            'DisplayRange',[minImg round(newMax)],...
            'InitialMagnification',100,'parent',ha);
        if detected == 1
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','g');
            drawnow
        else
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','r');
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushDot_Callback(pushDot,eventdata,handles)
        %Gaussian Fitting
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        fwhm = str2num(get(hinputFWHM,'String'));
        filterSpot = get(checkFilter,'Value');
        if xList(slice) == 0 && yList(slice) == 0
            warndlg('No XY coordinates for fitting!')
        else
            if (filterSpot == 1) && (filterSequence(slice) == 0)
                pushZero_Callback
            else
                noGraph = get(checkGraph,'Value');
                [TFI, W, I_MIN, I_MAX, gM1, gM2, gM3, gM4, gM5, gM6, d, rf] = dot_2D_t_v5(pathstr,[Sequence ext],1,slice,pSize,r,rf,fwhm,noGraph,xList(slice),yList(slice),iminSequence,imaxSequence);
                rSequence(slice) = r;
                rfSequence(slice) = rf;
                iminSequence(slice) = I_MIN;
                imaxSequence(slice) = I_MAX;
                gM1Sequence(slice) = gM1;
                gM2Sequence(slice) = gM2;
                gM3Sequence(slice) = gM3;
                gM4Sequence(slice) = gM4;
                gM5Sequence(slice) = gM5;
                gM6Sequence(slice) = gM6;
                set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI))]);
                set(plotinfo.sI,'String',['W = ' num2str(W,3)]);
                tfiSequence(slice) = TFI;
                wSequence(slice) = W;
                fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_results' '.xls']);
                xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
                ignoreString = {'Yes'};
                xlswrite(fullFilePathOutput,[slice tfiSequence(slice) wSequence(slice) iminSequence(slice) imaxSequence(slice) xList(slice) yList(slice) NaN filterSequence(slice) fwhm rfSequence(slice) rSequence(slice) ignoreString gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],'Sheet1',['A' num2str(slice+1)]);
                if ~isnan(round(max(tfiSequence)))
                    update_hpp
                    update_hpw
                end
                if ~isnan(gM1Sequence(slice))
                    update_hpgauss
                end
                if xList(slice) ~= 0
                    update_hpzoom
                end
                figure(hfig);
            end
        end
    end

    function pushZero_Callback(pushDot,eventdata,handles)
        %set TFI to 0
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        fwhm = str2num(get(hinputFWHM,'String'));
        set(plotinfo.sTFI,'String','TFI = 0');
        set(plotinfo.sI,'String','W = 0');
        rSequence(slice) = r;
        rfSequence(slice) = rf;
        tfiSequence(slice) = 0;
        wSequence(slice) = 0;
        iminSequence(slice) = NaN;
        imaxSequence(slice) = NaN;
        gM1Sequence(slice) = NaN;
        gM2Sequence(slice) = NaN;
        gM3Sequence(slice) = NaN;
        gM4Sequence(slice) = NaN;
        gM5Sequence(slice) = NaN;
        gM6Sequence(slice) = NaN;
        fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_results' '.xls']);
        xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
        ignoreString = {'Yes'};
        xlswrite(fullFilePathOutput,[slice tfiSequence(slice) wSequence(slice) iminSequence(slice) imaxSequence(slice) xList(slice) yList(slice) zSequence(slice) filterSequence(slice) fwhm rfSequence(slice) rSequence(slice) ignoreString gM1Sequence(slice) gM2Sequence(slice) gM3Sequence(slice) gM4Sequence(slice) gM5Sequence(slice) gM6Sequence(slice)],'Sheet1',['A' num2str(slice+1)]);
        if ~isnan(round(max(tfiSequence)))
            update_hpp
            update_hpw
            clean_hpgauss
        end
        figure(hfig);
    end

    function pushNaN_Callback(pushDot,eventdata,handles)
        %set TFI to NaN
        set(plotinfo.sTFI,'String','TFI = NaN');
        set(plotinfo.sI,'String','W = NaN');
        xList(slice) = 0;
        yList(slice) = 0;
        tfiSequence(slice) = NaN;
        wSequence(slice) = NaN;
        iminSequence(slice) = NaN;
        imaxSequence(slice) = NaN;
        gM1Sequence(slice) = NaN;
        gM2Sequence(slice) = NaN;
        gM3Sequence(slice) = NaN;
        gM4Sequence(slice) = NaN;
        gM5Sequence(slice) = NaN;
        gM6Sequence(slice) = NaN;
        fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_results' '.xls']);
        xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
        xlswrite(fullFilePathOutput,[NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN],'Sheet1',['A' num2str(slice+1)]);
        clean_hpgauss
        if isnan(round(max(tfiSequence)))
            clean_hpp
            clean_hpw
        else
            update_hpp
            update_hpw
        end
        figure(hfig);
    end

    function pushAutoTrack_Callback(pushDot,eventdata,handles)
        %automatically tracks dot over time
        if max(xList) == 0 && max(yList) == 0
            warndlg('No XY coordinates for fitting!')
        else
            set(checkTrack,'Value',1)
            for i = slice:n
                slice = i;
                set(slider1,'Value',slice);
                slider1_Callback(slider1)
                drawnow
            end
        end
    end

    function pushAutoDetect_Callback(pushDot,eventdata,handles)
        %automatically detects spots on nuclei
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        stdmeanratio = str2num(get(hinputS,'String'));
        [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
        slice = round(get(slider1,'Value'));
        himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        drawnow
        if ~isempty(pks)
            for j = 1:length(pks(:,1))
                [~, ~, detected] = track_xy(round(pks(j,1)),round(pks(j,2)),r,stdmeanratio);
                if detected == 1
                    rectangle('Position',[pks(j,1)-(rf+8)/2,pks(j,2)-(rf+8)/2,rf+8,rf+8],'Curvature',[1,1],'Edgecolor','g');
                end
            end
            drawnow
        end
		set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushAUTO_Callback(pushDot,eventdata,handles)
        %automatically performs Gaussian fitting for dots
        if max(xList) == 0 && max(yList) == 0
            warndlg('No XY coordinates for fitting!')
        else
            p_x = find(xList > 0);
            p_missing = find(isnan(tfiSequence));
            p = intersect(p_x,p_missing);
            numberSlices = length(p);
            for i = 1:numberSlices
                slice = p(i);
                set(slider1,'Value',slice);
                slider1_Callback(slider1)
                pushDot_Callback
                drawnow
            end
            warndlg('All Done!')
        end
    end

    function pushSaveXY_Callback(pushDot,eventdata,handles)
        %save XY coordinates to Excel file
        fwhm = str2num(get(hinputFWHM,'String'));
        if max(xList) == 0
            warndlg('No XY coordinates to save!')
        else
            timepoints = find(xList ~= 0);
            timepointsForFile = NaN(n,1);
            xForFile = NaN(n,1);
            yForFile = NaN(n,1);
            zForFile = NaN(n,1);
            filterForFile = NaN(n,1);
            fwhmForFile = NaN(n,1);
            rfForFile = NaN(n,1);
            rForFile = NaN(n,1);
            for i = 1:length(timepoints)
                timepointsForFile(timepoints(i)) = timepoints(i);
                xForFile(timepoints(i)) = xList(timepoints(i));
                yForFile(timepoints(i)) = yList(timepoints(i));
                zForFile(timepoints(i)) = zSequence(timepoints(i));
                filterForFile(timepoints(i)) = filterSequence(timepoints(i));
                fwhmForFile(timepoints(i)) = fwhm;
                rfForFile(timepoints(i)) = rfSequence(timepoints(i));
                rForFile(timepoints(i)) = rSequence(timepoints(i));
            end
            fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_results' '.xls']);
            xlswrite(fullFilePathOutput,{'Timepoint', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
            xlswrite(fullFilePathOutput,timepointsForFile,'Sheet1','A2');
            xlswrite(fullFilePathOutput,[xForFile yForFile zForFile filterForFile fwhmForFile rfForFile rForFile],'Sheet1','F2');
        end
    end

    function pushLoad_Callback(pushDot,eventdata,handles)
        %load data from Excel file
        S_proj = S_proj_clean;
        fullFilePathInput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_results' '.xls']);
        if exist(fullFilePathInput,'file') ~= 2
            warndlg('No results file!')
        else
            [num,txt,raw] = xlsread(fullFilePathInput,'Sheet1');
            if size(num,2) == 12
                for i = 1:size(num,1)
                    if ~isnan(num(i,1))
                        tfiSequence(num(i,1)) = num(i,2);
                        wSequence(num(i,1)) = num(i,3);
                        iminSequence(num(i,1)) = num(i,4);
                        imaxSequence(num(i,1)) = num(i,5);
                        xList(num(i,1)) = num(i,6);
                        yList(num(i,1)) = num(i,7);
                        filterSequence(num(i,1)) = num(i,9);
                        rfSequence(num(i,1)) = num(i,11);
                        if isnan(num(i,12))
                            rSequence(num(i,1)) = str2num(get(hinputR,'String'));
                        else
                            rSequence(num(i,1)) = num(i,12);
                        end
                        if (yList(num(i,1))-rSequence(num(i,1)) > 0) && (yList(num(i,1))+rSequence(num(i,1)) < info(1).Height) && (xList(num(i,1))-rSequence(num(i,1)) > 0) && (xList(num(i,1))+rSequence(num(i,1)) < info(1).Height)
                            S_proj(yList(num(i,1))-rSequence(num(i,1))-1:yList(num(i,1))+rSequence(num(i,1))+1, xList(num(i,1))-rSequence(num(i,1))-1, num(i,1)) = 2^16; 
                            S_proj(yList(num(i,1))-rSequence(num(i,1))-1:yList(num(i,1))+rSequence(num(i,1))+1, xList(num(i,1))+rSequence(num(i,1))+1, num(i,1)) = 2^16;
                            S_proj(yList(num(i,1))-rSequence(num(i,1))-1, xList(num(i,1))-rSequence(num(i,1))-1:xList(num(i,1))+rSequence(num(i,1))+1, num(i,1)) = 2^16; 
                            S_proj(yList(num(i,1))+rSequence(num(i,1))+1, xList(num(i,1))-rSequence(num(i,1))-1:xList(num(i,1))+rSequence(num(i,1))+1, num(i,1)) = 2^16;
                        end
                    end
                end
            elseif size(num,2) == 19
                for i = 1:size(num,1)
                    if ~isnan(num(i,1))
                        tfiSequence(num(i,1)) = num(i,2);
                        wSequence(num(i,1)) = num(i,3);
                        iminSequence(num(i,1)) = num(i,4);
                        imaxSequence(num(i,1)) = num(i,5);
                        xList(num(i,1)) = num(i,6);
                        yList(num(i,1)) = num(i,7);
                        filterSequence(num(i,1)) = num(i,9);
                        rfSequence(num(i,1)) = num(i,11);
                        if isnan(num(i,12))
                            rSequence(num(i,1)) = str2num(get(hinputR,'String'));
                        else
                            rSequence(num(i,1)) = num(i,12);
                        end
                        gM1Sequence(num(i,1)) = num(i,14);
                        gM2Sequence(num(i,1)) = num(i,15);
                        gM3Sequence(num(i,1)) = num(i,16);
                        gM4Sequence(num(i,1)) = num(i,17);
                        gM5Sequence(num(i,1)) = num(i,18);
                        gM6Sequence(num(i,1)) = num(i,19);
                        if (yList(num(i,1))-rSequence(num(i,1)) > 0) && (yList(num(i,1))+rSequence(num(i,1)) < info(1).Height) && (xList(num(i,1))-rSequence(num(i,1)) > 0) && (xList(num(i,1))+rSequence(num(i,1)) < info(1).Height)
                            S_proj(yList(num(i,1))-rSequence(num(i,1))-1:yList(num(i,1))+rSequence(num(i,1))+1, xList(num(i,1))-rSequence(num(i,1))-1, num(i,1)) = 2^16; 
                            S_proj(yList(num(i,1))-rSequence(num(i,1))-1:yList(num(i,1))+rSequence(num(i,1))+1, xList(num(i,1))+rSequence(num(i,1))+1, num(i,1)) = 2^16;
                            S_proj(yList(num(i,1))-rSequence(num(i,1))-1, xList(num(i,1))-rSequence(num(i,1))-1:xList(num(i,1))+rSequence(num(i,1))+1, num(i,1)) = 2^16; 
                            S_proj(yList(num(i,1))+rSequence(num(i,1))+1, xList(num(i,1))-rSequence(num(i,1))-1:xList(num(i,1))+rSequence(num(i,1))+1, num(i,1)) = 2^16;
                        end
                    end
                end
            end
            if isnan(round(max(tfiSequence)))
                clean_hpp
            else
                update_hpp
            end
            if isnan(round(max(wSequence)))
                clean_hpw
            else
                update_hpw
            end
            if xList(slice) ~= 0
                update_hpzoom
            else
                clean_hpzoom
            end
            if ~isnan(gM1Sequence(slice))
                update_hpgauss
            else
                clean_hpgauss
            end
            figure(hfig)
            set(slider1,'Value',slice);
            slider1_Callback(slider1)
            drawnow
        end
    end

    function pushClear_Callback(pushDot,eventdata,handles)
        %clear all data (and optionally results file)
        S_proj = S_proj_clean;
        fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_results' '.xls']);
        if exist(fullFilePathOutput,'file') == 2
            choice = questdlg('Do you also want to delete the results file?',...
                'WARNING','Yes','No','No');
            if strcmp(choice, 'Yes')
                delete(fullFilePathOutput);
            end
        end
        xList = zeros(1,n);
        yList = zeros(1,n);
        tfiSequence = NaN(1,n);
        wSequence = NaN(1,n);
        iminSequence = NaN(1,n);
        imaxSequence = NaN(1,n);
        gM1Sequence = NaN(1,n);
        gM2Sequence = NaN(1,n);
        gM3Sequence = NaN(1,n);
        gM4Sequence = NaN(1,n);
        gM5Sequence = NaN(1,n);
        gM6Sequence = NaN(1,n);
        zSequence = NaN(1,n);
        rSequence = zeros(1,n);
        rfSequence = zeros(1,n);
        filterSequence = NaN(1,n);
        clean_hpp
        clean_hpw
        clean_hpzoom
        clean_hpgauss
        figure(hfig)
        set(plotinfo.lasttfi,'String','');
        set(plotinfo.slastTFI,'String','');
        set(plotinfo.slastI,'String','');
        set(plotinfo.nexttfi,'String','');
        set(plotinfo.snextTFI,'String','');
        set(plotinfo.snextI,'String','');
        set(plotinfo.sx,'String','');
        set(plotinfo.sy,'String','');
        himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushClearTFI_Callback(pushDot,eventdata,handles)
        %clear all TFI values
        S_proj = S_proj_clean;
        timepoints = find(xList ~= 0 & ~isnan(xList));
        tfiSequence = NaN(1,n);
        rfSequence = NaN(1,n);
        wSequence = NaN(1,n);
        zSequence = NaN(1,n);
        iminSequence = NaN(1,n);
        imaxSequence = NaN(1,n);
        gM1Sequence = NaN(1,n);
        gM2Sequence = NaN(1,n);
        gM3Sequence = NaN(1,n);
        gM4Sequence = NaN(1,n);
        gM5Sequence = NaN(1,n);
        gM6Sequence = NaN(1,n);
        clean_hpp
        clean_hpw
        clean_hpzoom
        clean_hpgauss
        for i = 1:length(timepoints)
            slice = timepoints(i);
            set(slider1,'Value',slice);
            r = rSequence(slice);
            rfSequence(timepoints(i)) = str2num(get(hinputRf,'String'))/2;
            if r < rfSequence(timepoints(i))
                rfSequence(timepoints(i)) = r;
            end
            stdmeanratio = str2num(get(hinputS,'String'));
            [~, ~, detected] = track_xy(xList(slice),yList(slice),r,stdmeanratio);
            filterSequence(slice) = detected;
            if (yList(timepoints(i))-r > 0) && (yList(timepoints(i))+r < info(1).Height) && (xList(timepoints(i))-r > 0) && (xList(timepoints(i))+r < info(1).Height)
                S_proj(yList(timepoints(i))-r-1:yList(timepoints(i))+r+1, xList(timepoints(i))-r-1, timepoints(i)) = 2^16; 
                S_proj(yList(timepoints(i))-r-1:yList(timepoints(i))+r+1, xList(timepoints(i))+r+1, timepoints(i)) = 2^16;
                S_proj(yList(timepoints(i))-r-1, xList(timepoints(i))-r-1:xList(timepoints(i))+r+1, timepoints(i)) = 2^16; 
                S_proj(yList(timepoints(i))+r+1, xList(timepoints(i))-r-1:xList(timepoints(i))+r+1, timepoints(i)) = 2^16;
            end
            if xList(timepoints(i)) ~= 0
                update_hpzoom
            end
            drawnow
        end
        figure(hfig)
        set(slider1,'Value',slice);
        slider1_Callback(slider1)
    end

    function pushEXPORTFIGURES_Callback(hObject, eventdata, handles)
        if isnan(tfiSequence)
            warndlg('No Gaussian Fits to export!')
        else
            p = find(~isnan(tfiSequence));
            numberSlices = length(p);
            for i = 1:numberSlices
                slice = p(i);
                set(slider1,'Value',slice);
                slider1_Callback(slider1)
                fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_GAUSSIAN_FIT_timepoint_' num2str(slice) '.tif']);
                figure(hpgauss);
                export_fig(fullFilePathOutput,'-m2.5','-r300');
                fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_ZOOM_Z_timepoint_' num2str(slice) '.tif']);
                figure(hpzoom);
                export_fig(fullFilePathOutput,'-m2.5','-r300');
                fullFilePathOutput = fullfile(pathstr,[Sequence '_spot_' num2str(dotNumber) '_MIP_timepoint_' num2str(slice) '.tif']);
                figure(hfig);
                export_fig(fullFilePathOutput,'-native');
            end
        end
    end

    function inputR_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
        rSequence(slice) = input;
    end

    function inputStdmeanratio_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
    end

    function inputRf_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
        rfSequence(slice) = input/2;
    end

    function inputFWHM_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0.5')
        end
        grid_size = ceil(input/pSize)*2;
        rfSequence(slice) = grid_size/2;
        set(hinputRf,'String',num2str(rfSequence(slice)*2));
    end

    function pushEND_Callback(hObject, eventdata, handles)
        fileString = [Sequence '_spot_' num2str(dotNumber) ' - TFI.jpg'];
        PathTFIoutput = fullfile(pathstr,fileString);
        if ~isnan(round(max(tfiSequence))) && maxSlice > 1
            figure(hpp)
            title([Sequence ' - spot ' num2str(dotNumber)],'Interpreter','none');
            saveas(hpp,PathTFIoutput);
        end
        close(hfig);
        close(hpp);
        close(hpw);
        close(hpzoom);
        close(hpgauss);
    end

end