function [timeSequence, nTFISequence, nDELTASequence, timeOfSynthesisSequence, tfiSelected] = extract_cycles_v6(T, tfiSequence, wSequence, lifetimePoints, nZEROS, TFILower, TFIUpper, Wmin, Wmax)
% INPUT:
% tfiSequence - TFI Sequence values (read from xls file)
% lifetimePoints - number of time points for cycle search (min ZEROS)
%
% OUTPUT:
% nSequence - Sequence of N(introns) for each cycle
% timeOfSynthesisSequence - Sequence of time of synthesis (base to max) for
% each cycle

n = length(tfiSequence);
count = 0;
timeSequence = NaN(100,lifetimePoints+nZEROS*2);
nTFISequence = NaN(100,lifetimePoints+nZEROS*2);
nDELTASequence = NaN(100,1);
timeOfSynthesisSequence = NaN(100,1);
tfiSelected = NaN(n,1);
if nZEROS == 0
    warndlg('If number of ZEROS = 0 no cycles will be detected!')
else
    if isempty(TFIUpper)
        TFIUpper = max(tfiSequence);
    end
    if isempty(Wmax)
        Wmax = max(wSequence);
    end
    for i=nZEROS:n-lifetimePoints-nZEROS
        if max(tfiSequence(i-nZEROS+1:i)) <= TFILower && max(tfiSequence(i+lifetimePoints+1:i+lifetimePoints+nZEROS)) <= TFILower && min(tfiSequence(i+1:i+lifetimePoints)) > TFILower && max(tfiSequence(i+1:i+lifetimePoints)) <= TFIUpper && min(wSequence(i+1:i+lifetimePoints)) >= Wmin && max(wSequence(i+1:i+lifetimePoints)) <= Wmax && max(isnan(tfiSequence(i+1:i+lifetimePoints))) == 0
            highValues = tfiSequence(i+1:i+lifetimePoints);
            count = count + 1;
            for j = 1:lifetimePoints+nZEROS*2
                nTFISequence(count,j) = tfiSequence(i-nZEROS+j);
                timeSequence(count,j) = (i-nZEROS+j) * T - T;
                tfiSelected(i-nZEROS+j) = tfiSequence(i-nZEROS+j);
            end
            nDELTASequence(count) = max(highValues);
            timeOfSynthesisSequence(count) = find(highValues == max(highValues)) * T;
        end 
    end
end
badrows = any(isnan(nTFISequence),2);
nTFISequence(badrows,:)=[];
timeSequence(badrows,:)=[];
nDELTASequence(badrows)=[];
timeOfSynthesisSequence(badrows)=[];