function [A, B, x, y, z] = dot_readstack_3D_v5(fname, timepoint, num_images, xi, yi, zi, r)
% x y z are now calculated for the plane where the sum of the 4 highest
% pixels is bigger (instead of the plane with the highest value pixel)

info = imfinfo(fname);
A = zeros(info(1).Height, info(1).Width, num_images);
sum3 = zeros(num_images,1);
for k = 1:num_images
    A(:,:,k) = imread(fname, (timepoint-1)*num_images+k, 'Info', info);
end
if (xi==0 && yi==0)
    for j = 1:num_images
        pixelValues = double(sort(reshape(A(:,:,j),1,[]),'descend'));
        sum3(j) = pixelValues(1) + pixelValues(2) + pixelValues(3) + pixelValues(4);
    end
    z = find(sum3(:) == max(sum3),1);
    p = find(A(:,:,z)==max(max(A(:,:,z))),1);
    [y, x] = ind2sub(size(A(:,:,z)), p(1));
else
    x = xi;
    y = yi;
    z = zi;
end
if (y-r > 0) && (y+r < info(1).Height) && (x-r > 0) && (x+r < info(1).Height)
    B = A(y-r:y+r, x-r:x+r, :);
else
    r = min(y-1,x-1,info(1).Height-y+1,info(1).Height-x+1);
    B = A(y-r:y+r, x-r:x+r, :);
end