function [pk] = dot_detect_MIP(img,pk_size)
%normalization
offset = min(img(:));
img = img - offset;
mult = max(img(:));
img = img./mult;
%thresholding
level = graythresh(img);
BW = im2bw(img,level);
se = strel('disk',10);
erodedBW = imerode(BW,se);
dilatedBW = imdilate(erodedBW,se);
cellsmask = dilatedBW;
b = bpass(img,1,3);
b(~cellsmask) = 0;
bMean = mean(b(b~=0));
[pks] = dot_detect(b, pk_size, bMean);
if ~isempty(pks)
    pks_img = zeros(size(img,1),size(img,2));
    for i = 1:size(pks,1)
        pks_img(pks(i,2),pks(i,1)) = 1;
    end
    pks_mask = pks_img .* cellsmask;
    pks_mask = pks_mask * 255;
    b = bpass(pks_mask, 0, 3);
    pk = pkfnd(b, 1, 1);
    if isempty(pk)
        pk = [];
    else
        for n = 1:length(pk(:,1))
            pk(n,1) = pk(n,1);
            pk(n,2) = pk(n,2);
        end
    end
else
    pk = [];
end