function [TFI, Ig, wg, Cg] = gauss3d_v6(d, fld, md, t, psize, rf, a1, a2, a3, a4)
% fit 2d Gaussian to maximum intensity z plane
set(0,'defaultlinelinewidth',2);
if (a1 == 0 && a2 == 0 && a3 == 0 )
    gM = gaussfit(d(:,:,t),'2d',psize,'n');
    %plotgaussfit(gM,d(:,:,t),psize,'n');
    %axis ([-rf*psize rf*psize -rf*psize rf*psize 0 md]);
    %caxis ([fld md]);
    I0 = abs(gM(1));
    w0 = abs(sqrt(gM(2)*gM(3)));
    C0 = abs(gM(4));
else
    I0 = a1;
    w0 = abs(sqrt(a2*a3));
    C0 = a4;
end
g = gaussfitbound_v2(d(:,:,t),'2d',psize,'n',I0,w0,C0);
%xg = g(5);
%yg = g(6);
wg = sqrt(g(2)*g(3));
Cg = g(4);
if wg < w0*1.5
        Ig = g(1);
        TFI = Ig * pi * g(2) * g(3);
end
