function interfaceImage3D_multipleDots_2channels_v1(pathstr,name1,name2,ext,n,num_images,pSize)

numberSequences = 2;
fullFilePathSequences = {fullfile(pathstr,[name1 ext]),fullfile(pathstr,[name2 ext])};
numImagesInSequenceTimepoint = {num2str(num_images), num2str(num_images)};
numberImagesInSequences = {num2str(n), num2str(n)};
sequenceList = {name1, name2};
xDimensionList = zeros(numberSequences);
yDimensionList = zeros(numberSequences);
n = 0;
for k = 1:numberSequences
    infoSequences = imfinfo(fullFilePathSequences{k});
    xDimensionList(k) = infoSequences.Width;
    yDimensionList(k) = infoSequences.Height;
    n = n + str2num(numberImagesInSequences{k});
end
maxDimension = max(max(max(xDimensionList),max(yDimensionList)));
hseq = waitbar(0,'Initializing waitbar...','Position',[400,180,280,50]);
himages = waitbar(0,'Initializing waitbar...','Position',[400,100,280,50]);
TimepointInfoTable = cell(n,5);
S_proj = zeros(maxDimension, maxDimension, n);
S_proj_min = 2^12;
iForS_proj = 1;
for l = 1:numberSequences
    waitbar(l/numberSequences,hseq,sprintf('Loading sequence %d of %d',l,numberSequences))
    [pathstrSeq, ~, extSeq] = fileparts(fullFilePathSequences{l});
    infoSequence = imfinfo(fullFilePathSequences{l});
    yDim = infoSequence.Height;
    xDim = infoSequence.Width;
    for g = 1:str2num(numberImagesInSequences{l})
        waitbar(g/str2num(numberImagesInSequences{l}),himages,sprintf('Loading z-stack from timepoint %d of %d',g,str2num(numberImagesInSequences{l})))
        S = zeros(yDim, xDim, str2num(numImagesInSequenceTimepoint{l}));
        for q = 1:str2num(numImagesInSequenceTimepoint{l})
            S(:,:,q) = imread(fullfile(pathstrSeq, [sequenceList{l} extSeq]),(g-1)*str2num(numImagesInSequenceTimepoint{l})+q, 'Info', infoSequence);
        end
        S_proj_temp = max(S, [], 3);
        S_proj_min = min(S_proj_min,min(min(S_proj_temp)));
        S_proj(1:yDim,1:xDim,iForS_proj) = S_proj_temp;
        TimepointInfoTable(iForS_proj,1) = fullFilePathSequences(l);
        TimepointInfoTable(iForS_proj,2) = sequenceList(l);
        TimepointInfoTable(iForS_proj,3) = {num2str(g)};
        TimepointInfoTable(iForS_proj,4) = {NaN};
        TimepointInfoTable(iForS_proj,5) = numImagesInSequenceTimepoint(l);
        iForS_proj = iForS_proj + 1;
    end
end

slice2range = zeros(n,2);
TimepointsRange = zeros(numberSequences,2);
TimepointsRange(1,1) = 1;
TimepointsRange(1,2) = str2num(numberImagesInSequences{1});
slice2range(1:str2num(numberImagesInSequences{1}),1) = TimepointsRange(1,1);
slice2range(1:str2num(numberImagesInSequences{1}),2) = TimepointsRange(1,2);
if numberSequences > 1
    for g = 2:numberSequences
        TimepointsRange(g,1) = TimepointsRange(g-1,2)+1;
        TimepointsRange(g,2) = TimepointsRange(g-1,2)+str2num(numberImagesInSequences{g});
        slice2range(TimepointsRange(g,1):TimepointsRange(g,2),1) = TimepointsRange(g,1);
        slice2range(TimepointsRange(g,1):TimepointsRange(g,2),2) = TimepointsRange(g,2);
    end
end
xList = zeros(1,n);
yList = zeros(1,n);
iminSequence = NaN(1,n);
imaxSequence = NaN(1,n);
gM1Sequence = NaN(1,n);
gM2Sequence = NaN(1,n);
gM3Sequence = NaN(1,n);
gM4Sequence = NaN(1,n);
gM5Sequence = NaN(1,n);
gM6Sequence = NaN(1,n);
zSequence = NaN(1,n);
rSequence = zeros(1,n);
rfSequence = zeros(1,n);
close(hseq)
close(himages)

sizeImg = size(S_proj);
minImg = double(S_proj_min);
maxImg = max(max(max(S_proj)));
minSlice = 1;
maxSlice = sizeImg(3);
startSlice = 1;

S_proj_clean = S_proj;
S_proj_clean_for_fit = S_proj;

% Create a figure for zoomed image on brightest plane
hpzoom = figure('Name','Z1','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,545,161,185]);        

% Create a figure for Gaussian Fit
hpgauss = figure('Name','FIT1','numberTitle','off','Toolbar','figure',...
            'Menubar','none','Position',[1116,545,221,185]);        
hpgaussbuttons = findall(hpgauss);
hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(hpgaussbutton1,'Visible','Off')
set(hpgaussbutton2,'Visible','Off')
set(hpgaussbutton4,'Visible','Off')
set(hpgaussbutton5,'Visible','Off')
set(hpgaussbutton7,'Visible','Off')
set(hpgaussbutton8,'Visible','Off')
set(hpgaussbutton9,'Visible','Off')
set(hpgaussbutton10,'Visible','Off')
set(hpgaussbutton11,'Visible','Off')
set(hpgaussbutton12,'Visible','Off')
set(hpgaussbutton13,'Visible','Off')

hpzoom2 = figure('Name','Z2','numberTitle','off','Toolbar','none',...
            'Menubar','none','Position',[937,245,161,185]);        

% Create a figure for Gaussian Fit
hpgauss2 = figure('Name','FIT2','numberTitle','off','Toolbar','figure',...
            'Menubar','none','Position',[1116,245,221,185]);  
hpgaussbuttons2 = findall(hpgauss2);
hpgaussbutton2_1 = findall(hpgaussbuttons2,'ToolTipString','New Figure');
hpgaussbutton2_2 = findall(hpgaussbuttons2,'ToolTipString','Open File');
hpgaussbutton2_4 = findall(hpgaussbuttons2,'ToolTipString','Print Figure');
hpgaussbutton2_5 = findall(hpgaussbuttons2,'ToolTipString','Edit Plot');
hpgaussbutton2_7 = findall(hpgaussbuttons2,'ToolTipString','Data Cursor');
hpgaussbutton2_8 = findall(hpgaussbuttons2,'ToolTipString','Brush/Select Data');
hpgaussbutton2_9 = findall(hpgaussbuttons2,'ToolTipString','Link Plot');
hpgaussbutton2_10 = findall(hpgaussbuttons2,'ToolTipString','Insert Colorbar');
hpgaussbutton2_11 = findall(hpgaussbuttons2,'ToolTipString','Insert Legend');
hpgaussbutton2_12 = findall(hpgaussbuttons2,'ToolTipString','Hide Plot Tools');
hpgaussbutton2_13 = findall(hpgaussbuttons2,'ToolTipString','Show Plot Tools and Dock Figure');
set(hpgaussbutton2_1,'Visible','Off')
set(hpgaussbutton2_2,'Visible','Off')
set(hpgaussbutton2_4,'Visible','Off')
set(hpgaussbutton2_5,'Visible','Off')
set(hpgaussbutton2_7,'Visible','Off')
set(hpgaussbutton2_8,'Visible','Off')
set(hpgaussbutton2_9,'Visible','Off')
set(hpgaussbutton2_10,'Visible','Off')
set(hpgaussbutton2_11,'Visible','Off')
set(hpgaussbutton2_12,'Visible','Off')
set(hpgaussbutton2_13,'Visible','Off')
        
% Create a figure without toolbar and menubar
hfig = figure('Toolbar','figure',...
    'Menubar','none',...
    'Name','Max Projection Timelapse Viewer - Multiple Spots 3D (2 channels)',...
    'Position',[20,100,900,630],...
    'NumberTitle','off',...
    'IntegerHandle','off');
hfigbuttons = findall(hfig);
button1 = findall(hfigbuttons,'ToolTipString','New Figure');
button2 = findall(hfigbuttons,'ToolTipString','Open File');
button3 = findall(hfigbuttons,'ToolTipString','Save Figure');
button4 = findall(hfigbuttons,'ToolTipString','Print Figure');
button5 = findall(hfigbuttons,'ToolTipString','Edit Plot');
button6 = findall(hfigbuttons,'ToolTipString','Rotate 3D');
button7 = findall(hfigbuttons,'ToolTipString','Data Cursor');
button8 = findall(hfigbuttons,'ToolTipString','Brush/Select Data');
button9 = findall(hfigbuttons,'ToolTipString','Link Plot');
button10 = findall(hfigbuttons,'ToolTipString','Insert Colorbar');
button11 = findall(hfigbuttons,'ToolTipString','Insert Legend');
button12 = findall(hfigbuttons,'ToolTipString','Hide Plot Tools');
button13 = findall(hfigbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
set(button1,'Visible','Off')
set(button2,'Visible','Off')
set(button3,'Visible','Off')
set(button4,'Visible','Off')
set(button5,'Visible','Off')
set(button6,'Visible','Off')
set(button7,'Visible','Off')
set(button8,'Visible','Off')
set(button9,'Visible','Off')
set(button10,'Visible','Off')
set(button11,'Visible','Off')
set(button12,'Visible','Off')
set(button13,'Visible','Off')

hpanel1 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Recenter Spot',...
    'Clipping','on',...
    'Position',[10 12 30 6.69230769230769]);

htextR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 2.69230769230769 17.2 1.84615384615385],...
'String','Search Radius',...
'Style','text',...
'Tag','text4');

hinputR = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 3.07692307692308 5.4 1.53846153846154],...
'String','6',...
'Style','edit',...
'Tag','inputR',...
'Callback',@inputR_Callback);

htextS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.3 0.466153846153846 17.4 1.85615384615385],...
'String','Sensitivity ',...
'Style','text',...
'Tag','text5');

hinputS = uicontrol(...
'Parent',hpanel1,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[22 1.015384615384615 5.4 1.43846153846154],...
'String','10',...
'Style','edit',...
'Tag','inputStdmeanratio',...
'Callback',@inputStdmeanratio_Callback);

hpanel2 = uipanel('Parent',hfig,...
    'Units','characters',...
    'FontUnits','pixels',...
    'FontSize',12,...
    'FontWeight','bold',...
    'Title','Gaussian Fitting',...
    'Clipping','on',...
    'Position',[146 36 30 10]);

htextFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 5.19230769230769 17.2 1.84615384615385],...
'String','PSF FWHM',...
'Style','text',...
'Tag','textRf');

hinputFWHM = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 5.68692307692308 7.4 1.53846153846154],...
'String','0.500',...
'Style','edit',...
'Tag','inputRf',...
'Callback',@inputFWHM_Callback);

htextRf = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 2.89230769230769 17.2 1.84615384615385],...
'String','Grid Size',...
'Style','text',...
'Tag','textRf');

hinputRf = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 3.37692307692308 5.4 1.53846153846154],...
'String','6',...
'Style','edit',...
'Tag','inputRf',...
'Callback',@inputRf_Callback);

htextZset = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'FontSize',12,...
'HorizontalAlignment','right',...
'Position',[1.6 0.5 17.2 1.85615384615385],...
'String','Z slice',...
'Style','text',...
'Tag','textZset');

hinputZset = uicontrol(...
'Parent',hpanel2,...
'Units','characters',...
'FontUnits','pixels',...
'BackgroundColor',[1 1 1],...
'FontSize',10.6666666666667,...
'Position',[20 1.07 5.4 1.53846153846154],...
'String','1',...
'Style','edit',...
'Tag','inputZset',...
'Callback',@inputZset_Callback);

bg = uibuttongroup(hfig,'Units','characters',...
    'Position',[154 33 22 2],...
    'SelectionChangedFcn',@slider3_Callback);          
              
bgMIP = uicontrol(bg,'Style',...
                  'radiobutton',...
                  'String','MIP',...
                  'Position',[5 5 40 15]);
              
bgSlice = uicontrol(bg,'Style','radiobutton',...
                  'String','Slice',...
                  'Position',[55 5 50 15]);

if maxSlice > 1
    sliceRange = maxSlice - minSlice;
else
    sliceRange = 1;
end

slider1 = uicontrol(hfig,'Style','slider',...
    'Min',minSlice,'Max',maxSlice,...
    'Position',[20,30,185,20],...
    'SliderStep',[1/sliceRange 5/sliceRange],...
    'Callback',@slider1_Callback);

set(slider1,'Value',startSlice);

slider2 = uicontrol(hfig,'Style','slider',...
    'Min',minImg,'Max',maxImg,...
    'Position',[20,60,20,185],...
    'SliderStep',[10/(maxImg-minImg) 50/(maxImg-minImg)],...
    'Callback',@slider2_Callback);

set(slider2,'Value',maxImg);

slider3 = uicontrol(hfig,'Style','slider',...
    'Min',1,'Max',num_images,...
    'Position',[738,370,20,80],...
    'SliderStep',[1/(num_images-1) 1/(num_images-1)],...
    'Callback',@slider3_Callback);

set(slider3,'Value',1);

slice = round(get(slider1,'Value'));

newMax = round(get(slider2,'Value'));

plotinfo.s1 = uicontrol(hfig,'Style','text',...
    'String','Frame',...
    'Position',[135,50,48,20]);

plotinfo.s2 = uicontrol(hfig,'Style','text',...
    'String',num2str(slice),...
    'Position',[175,50,30,20]);

plotinfo.s3 = uicontrol(hfig,'Style','text',...
    'String','MAX',...
    'Position',[15,245,30,20]);

plotinfo.s4 = uicontrol(hfig,'Style','text',...
    'String','Spot',...
    'Position',[744 239 30 20]);

plotinfo.s5 = uicontrol(hfig,'Style','text',...
    'String',TimepointInfoTable(slice,2),...
    'FontSize',10,'FontWeight','bold',...
    'HorizontalAlignment','center',...
    'Position',[220,28,500,20]);

plotinfo.s6 = uicontrol(hfig,'Style','text',...
    'String','Timepoint',...
    'Position',[210,28,48,20]);

plotinfo.s7 = uicontrol(hfig,'Style','text',...
    'String',TimepointInfoTable(slice,3),...
    'HorizontalAlignment','center',...
    'Position',[260,28,20,20]);

plotinfo.s8 = uicontrol(hfig,'Style','text',...
    'String','Z',...
    'HorizontalAlignment','center',...
    'Position',[738,452,20,16]);

checkFilter = uicontrol('Style', 'checkbox',...
    'Position',[55 260 50 30],...
    'FontSize',10,...
    'String','Filter',...
    'Value',1);

checkGraph = uicontrol('Style', 'checkbox',...
    'Position',[740 340 150 20],...
    'FontSize',10,...
    'String','Hide Gaussian Fit');

checkZ = uicontrol('Style', 'checkbox',...
    'Position',[740 310 150 20],...
    'FontSize',10,...
    'String','Ignore Z Limits');

plotinfo.sDot = uicontrol(hfig,'Style','text',...
    'Position',[750,205,120,20],...
    'FontWeight','bold',...
    'FontSize',12,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sTFI = uicontrol(hfig,'Style','text',...
    'Position',[750,175,120,20],...
    'FontWeight','bold',...
    'FontSize',10,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sI = uicontrol(hfig,'Style','text',...
    'Position',[750,155,120,20],...
    'FontWeight','bold',...
    'FontSize',10,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sZ = uicontrol(hfig,'Style','text',...
    'Position',[750,125,120,20],...
    'FontWeight','bold',...
    'FontSize',10,...
    'BackgroundColor',[0.9,0.9,0.9]);

plotinfo.sxytitle = uicontrol(hfig,'Style','text',...
    'Position',[40,105,160,40],...
    'String','Click on image to get XY coordinates',...
    'FontWeight','bold',...
    'FontSize',9);

plotinfo.sx = uicontrol(hfig,'Style','text',...
    'Position',[50,85,80,20],...
    'FontSize',10);

plotinfo.sy = uicontrol(hfig,'Style','text',...
    'Position',[120,85,80,20],...
    'FontSize',10);

editDot = uicontrol('Style', 'edit',...
    'Position',[745 245 30 20],...
    'Callback',@editDot_Callback);

set(editDot,'String',num2str(1));

dot_number = round(str2num(get(editDot,'String')));

pushAutoDetect = uicontrol('Style', 'pushbutton',...
    'Position',[20 290 90 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Detect',...
    'Callback',@pushAutoDetect_Callback);

pushAutoFIT = uicontrol('Style', 'pushbutton',...
    'Position',[110 290 84 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0 0.498 0],...
    'String','Auto Fit',...
    'Callback',@pushAutoFIT_Callback);

pushDot = uicontrol('Style', 'pushbutton',...
    'Position',[780 240 100 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Gaussian Fit',...
    'Callback',@pushDot_Callback);

pushEXPORTFIGURES = uicontrol('Style', 'pushbutton',...
    'Position',[750 45 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Export Figures',...
    'Callback',@pushEXPORTFIGURES_Callback);

pushAutoFitAll = uicontrol('Style', 'pushbutton',...
    'Position',[750 80 120 30],...
    'FontWeight','bold',...
    'FontSize',11,...
    'ForegroundColor',[0 0.498 0],...
    'String','AUTO FIT ALL',...
    'Callback',@AutoFitAll_Callback);

pushNextSequence = uicontrol('Style', 'pushbutton',...
    'Position',[175 5 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','>>',...
    'Callback',@pushNEXT_Callback);

pushPreviousSequence = uicontrol('Style', 'pushbutton',...
    'Position',[20 5 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','<<',...
    'Callback',@pushPREV_Callback);

pushNextSpot = uicontrol('Style','pushbutton',...
    'Position',[760 273 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','>',...
    'Callback',@pushNEXTSpot_Callback);

pushPreviousSpot = uicontrol('Style','pushbutton',...
    'Position',[730 273 30 20],...
    'FontWeight','bold',...
    'FontSize',8,...
    'String','<',...
    'Callback',@pushPREVSpot_Callback);

pushEND = uicontrol('Style', 'pushbutton',...
    'Position',[750 10 120 30],...
    'FontWeight','bold',...
    'FontSize',10,...
    'ForegroundColor',[0.043 0.518 0.78],...
    'String','END Timelapse',...
    'Callback',@pushEND_Callback);

ha = axes('units','pixels','position',[210 59 512 512]);
himage = imshow(S_proj(:,:,round(slice)),...
        'DisplayRange',[minImg round(newMax)],...
        'InitialMagnification',100,'parent',ha);
set(hfig,'WindowButtonMotionFcn',@changepointer)
set(himage,'ButtonDownFcn',@pixelInfo)

    function changepointer(hObj,handles)
        %change pointer to crosshair when hovering himage
        axlim = get(ha,'Position');
        fglim = get(hfig,'Position');
        x1 = axlim(1) + fglim(1);
        x2 = (axlim(1)+axlim(3)) + fglim(1);
        y1 = axlim(2) + fglim(2);
        y2 = (axlim(2)+axlim(4)) + fglim(2);
        pntr = get(0,'PointerLocation');
        if pntr(1)>x1 && pntr(1)<x2 && pntr(2)>y1 && pntr(2)<y2
            set(hfig,'Pointer','crosshair')
        else
            set(hfig,'Pointer','arrow')
        end
    end

    function [x, y, z, detected] = track_xyz(xi,yi,r,stdmeanratio, slice)
        %track (x,y,z) coordinates from (xi,yi) depending on stdmeanratio 
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        B = SforZ(yi-r:yi+r, xi-r:xi+r, :); 
        rf = str2num(get(hinputRf,'String'))/2;
        [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
        sumValues = zeros(num_images,1);
        for m = 1:num_images
            pixelValues = double(sort(reshape(B(:,:,m),1,[]),'descend'));
            sumValues(m) = pixelValues(1) + pixelValues(2) + pixelValues(3) + pixelValues(4);
        end
        z = find(sumValues(:) == max(sumValues),1);
        if ~isempty(pks)
            D = pdist2([xi,yi],pks);
            i_min = find(D == min(D));
            if min(D) <= 2*r && (max(max(std(double(B)))) > mean(mean(mean(double(B))))/stdmeanratio)
                detected = 1;
                x = pks(i_min,1);
                y = pks(i_min,2);
            else
                detected = 0;
                x = xi;
                y = yi;
            end
        else
            detected = 0;
            x = xi;
            y = yi;
        end
    end 

    function [x, y, newZ, detected] = track_xynewZ(xi,yi,r,stdmeanratio, slice, newZ)
        %track (x,y,z) coordinates from (xi,yi) depending on stdmeanratio 
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = double(imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+newZ, 'Info', infoString));
        B = SforZ(yi-r:yi+r, xi-r:xi+r); 
        rf = str2num(get(hinputRf,'String'))/2;
        [pks] = dot_detect_MIP(SforZ,rf);
        if ~isempty(pks)
            D = pdist2([xi,yi],pks);
            i_min = find(D == min(D));
            if min(D) <= 2*r && (max(max(std(double(B)))) > mean(mean(mean(double(B))))/stdmeanratio)
                detected = 1;
                x = pks(i_min,1);
                y = pks(i_min,2);
            else
                detected = 0;
                x = xi;
                y = yi;
            end
        else
            detected = 0;
            x = xi;
            y = yi;
        end
    end

    function update_hpzoom
        figure(hpzoom)
        if slice2range(slice,1) == 1
            slice_for_hpzoom = slice;
        else
            slice_for_hpzoom = slice - slice2range(slice,1) + 1;
        end
        num_images = str2num(TimepointInfoTable{slice_for_hpzoom,5});
        fullPathstring = TimepointInfoTable{slice_for_hpzoom,1};
        SequenceString = TimepointInfoTable{slice_for_hpzoom,2};
        Timepoint = str2num(TimepointInfoTable{slice_for_hpzoom,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        singleFrameZoom = SforZ(yList(slice_for_hpzoom)-rSequence(slice_for_hpzoom):yList(slice_for_hpzoom)+rSequence(slice_for_hpzoom), xList(slice_for_hpzoom)-rSequence(slice_for_hpzoom):xList(slice_for_hpzoom)+rSequence(slice_for_hpzoom), zSequence(slice_for_hpzoom));
        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
    end

function update_hpzoom2
        figure(hpzoom2)
         if slice2range(slice,1) == 1
            slice_for_hpzoom = slice + slice2range(slice,2);
        else
            slice_for_hpzoom = slice;
        end
        num_images = str2num(TimepointInfoTable{slice_for_hpzoom,5});
        fullPathstring = TimepointInfoTable{slice_for_hpzoom,1};
        SequenceString = TimepointInfoTable{slice_for_hpzoom,2};
        Timepoint = str2num(TimepointInfoTable{slice_for_hpzoom,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        singleFrameZoom = SforZ(yList(slice_for_hpzoom)-rSequence(slice_for_hpzoom):yList(slice_for_hpzoom)+rSequence(slice_for_hpzoom), xList(slice_for_hpzoom)-rSequence(slice_for_hpzoom):xList(slice_for_hpzoom)+rSequence(slice_for_hpzoom), zSequence(slice_for_hpzoom));
        imshow(singleFrameZoom,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
    end

    function update_hpgauss
        figure(hpgauss)
        if slice2range(slice,1) == 1
            slice_for_hpgauss = slice;
        else
            slice_for_hpgauss = slice - slice2range(slice,1) + 1;
        end
        num_images = str2num(TimepointInfoTable{slice_for_hpgauss,5});
        fullPathstring = TimepointInfoTable{slice_for_hpgauss,1};
        SequenceString = TimepointInfoTable{slice_for_hpgauss,2};
        Timepoint = str2num(TimepointInfoTable{slice_for_hpgauss,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        close(hpgauss)
        hpgauss = figure('Name','FIT1','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);        
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
        B = SforZ(yList(slice_for_hpgauss)-rfSequence(slice_for_hpgauss):yList(slice_for_hpgauss)+rfSequence(slice_for_hpgauss), xList(slice_for_hpgauss)-rfSequence(slice_for_hpgauss):xList(slice_for_hpgauss)+rfSequence(slice_for_hpgauss), :); 
        d = double(B(rfSequence(slice_for_hpgauss)-rfSequence(slice_for_hpgauss)+1:rfSequence(slice_for_hpgauss)+rfSequence(slice_for_hpgauss)+1, rfSequence(slice_for_hpgauss)-rfSequence(slice_for_hpgauss)+1:rfSequence(slice_for_hpgauss)+rfSequence(slice_for_hpgauss)+1, zSequence(slice_for_hpgauss)));
        plotgaussfit_in_GUI([gM1Sequence(slice_for_hpgauss) gM2Sequence(slice_for_hpgauss) gM3Sequence(slice_for_hpgauss) gM4Sequence(slice_for_hpgauss) gM5Sequence(slice_for_hpgauss) gM6Sequence(slice_for_hpgauss)],d,pSize,'n');
        axis ([-rfSequence(slice_for_hpgauss)*pSize rfSequence(slice_for_hpgauss)*pSize -rfSequence(slice_for_hpgauss)*pSize rfSequence(slice_for_hpgauss)*pSize 0 max(imaxSequence)]);
        caxis ([min(iminSequence) max(imaxSequence)]);
    end

    function update_hpgauss2
        figure(hpgauss2)
        if slice2range(slice,1) ~= 1
            slice_for_hpgauss = slice;
        else
            slice_for_hpgauss = slice2range(slice,2) + slice;
        end
        num_images = str2num(TimepointInfoTable{slice_for_hpgauss,5});
        fullPathstring = TimepointInfoTable{slice_for_hpgauss,1};
        SequenceString = TimepointInfoTable{slice_for_hpgauss,2};
        Timepoint = str2num(TimepointInfoTable{slice_for_hpgauss,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);
        SforZ = zeros(infoString(1).Height, infoString(1).Width, num_images);
        for j = 1:num_images
            SforZ(:,:,j) = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+j, 'Info', infoString);
        end
        close(hpgauss2)
        hpgauss2 = figure('Name','FIT2','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,245,221,185]);
        hpgaussbuttons2 = findall(hpgauss2);
        hpgaussbutton2_1 = findall(hpgaussbuttons2,'ToolTipString','New Figure');
        hpgaussbutton2_2 = findall(hpgaussbuttons2,'ToolTipString','Open File');
        hpgaussbutton2_4 = findall(hpgaussbuttons2,'ToolTipString','Print Figure');
        hpgaussbutton2_5 = findall(hpgaussbuttons2,'ToolTipString','Edit Plot');
        hpgaussbutton2_7 = findall(hpgaussbuttons2,'ToolTipString','Data Cursor');
        hpgaussbutton2_8 = findall(hpgaussbuttons2,'ToolTipString','Brush/Select Data');
        hpgaussbutton2_9 = findall(hpgaussbuttons2,'ToolTipString','Link Plot');
        hpgaussbutton2_10 = findall(hpgaussbuttons2,'ToolTipString','Insert Colorbar');
        hpgaussbutton2_11 = findall(hpgaussbuttons2,'ToolTipString','Insert Legend');
        hpgaussbutton2_12 = findall(hpgaussbuttons2,'ToolTipString','Hide Plot Tools');
        hpgaussbutton2_13 = findall(hpgaussbuttons2,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton2_1,'Visible','Off')
        set(hpgaussbutton2_2,'Visible','Off')
        set(hpgaussbutton2_4,'Visible','Off')
        set(hpgaussbutton2_5,'Visible','Off')
        set(hpgaussbutton2_7,'Visible','Off')
        set(hpgaussbutton2_8,'Visible','Off')
        set(hpgaussbutton2_9,'Visible','Off')
        set(hpgaussbutton2_10,'Visible','Off')
        set(hpgaussbutton2_11,'Visible','Off')
        set(hpgaussbutton2_12,'Visible','Off')
        set(hpgaussbutton2_13,'Visible','Off')
        B = SforZ(yList(slice_for_hpgauss)-rfSequence(slice_for_hpgauss):yList(slice_for_hpgauss)+rfSequence(slice_for_hpgauss), xList(slice_for_hpgauss)-rfSequence(slice_for_hpgauss):xList(slice_for_hpgauss)+rfSequence(slice_for_hpgauss), :); 
        d = double(B(rfSequence(slice_for_hpgauss)-rfSequence(slice_for_hpgauss)+1:rfSequence(slice_for_hpgauss)+rfSequence(slice_for_hpgauss)+1, rfSequence(slice_for_hpgauss)-rfSequence(slice_for_hpgauss)+1:rfSequence(slice_for_hpgauss)+rfSequence(slice_for_hpgauss)+1, zSequence(slice_for_hpgauss)));
        plotgaussfit_in_GUI([gM1Sequence(slice_for_hpgauss) gM2Sequence(slice_for_hpgauss) gM3Sequence(slice_for_hpgauss) gM4Sequence(slice_for_hpgauss) gM5Sequence(slice_for_hpgauss) gM6Sequence(slice_for_hpgauss)],d,pSize,'n');
        axis ([-rfSequence(slice_for_hpgauss)*pSize rfSequence(slice_for_hpgauss)*pSize -rfSequence(slice_for_hpgauss)*pSize rfSequence(slice_for_hpgauss)*pSize 0 max(imaxSequence)]);
        caxis ([min(iminSequence) max(imaxSequence)]);
    end

    function clean_hpzoom
        close(hpzoom)
        hpzoom = figure('Name','Z1','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,545,161,185]);
    end

    function clean_hpzoom2
        close(hpzoom2)
        hpzoom2 = figure('Name','Z2','numberTitle','off','Toolbar','none','Menubar','none','Position',[937,245,161,185]); 
    end

    function clean_hpgauss
        close(hpgauss)
        hpgauss = figure('Name','FIT','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,545,221,185]);
        hpgaussbuttons = findall(hpgauss);
        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton1,'Visible','Off')
        set(hpgaussbutton2,'Visible','Off')
        set(hpgaussbutton4,'Visible','Off')
        set(hpgaussbutton5,'Visible','Off')
        set(hpgaussbutton7,'Visible','Off')
        set(hpgaussbutton8,'Visible','Off')
        set(hpgaussbutton9,'Visible','Off')
        set(hpgaussbutton10,'Visible','Off')
        set(hpgaussbutton11,'Visible','Off')
        set(hpgaussbutton12,'Visible','Off')
        set(hpgaussbutton13,'Visible','Off')
    end

    function clean_hpgauss2
        close(hpgauss2)
        hpgauss2 = figure('Name','FIT2','numberTitle','off','Toolbar','figure','Menubar','none','Position',[1116,245,221,185]);
        hpgaussbuttons2 = findall(hpgauss2);
        hpgaussbutton2_1 = findall(hpgaussbuttons2,'ToolTipString','New Figure');
        hpgaussbutton2_2 = findall(hpgaussbuttons2,'ToolTipString','Open File');
        hpgaussbutton2_4 = findall(hpgaussbuttons2,'ToolTipString','Print Figure');
        hpgaussbutton2_5 = findall(hpgaussbuttons2,'ToolTipString','Edit Plot');
        hpgaussbutton2_7 = findall(hpgaussbuttons2,'ToolTipString','Data Cursor');
        hpgaussbutton2_8 = findall(hpgaussbuttons2,'ToolTipString','Brush/Select Data');
        hpgaussbutton2_9 = findall(hpgaussbuttons2,'ToolTipString','Link Plot');
        hpgaussbutton2_10 = findall(hpgaussbuttons2,'ToolTipString','Insert Colorbar');
        hpgaussbutton2_11 = findall(hpgaussbuttons2,'ToolTipString','Insert Legend');
        hpgaussbutton2_12 = findall(hpgaussbuttons2,'ToolTipString','Hide Plot Tools');
        hpgaussbutton2_13 = findall(hpgaussbuttons2,'ToolTipString','Show Plot Tools and Dock Figure');
        set(hpgaussbutton2_1,'Visible','Off')
        set(hpgaussbutton2_2,'Visible','Off')
        set(hpgaussbutton2_4,'Visible','Off')
        set(hpgaussbutton2_5,'Visible','Off')
        set(hpgaussbutton2_7,'Visible','Off')
        set(hpgaussbutton2_8,'Visible','Off')
        set(hpgaussbutton2_9,'Visible','Off')
        set(hpgaussbutton2_10,'Visible','Off')
        set(hpgaussbutton2_11,'Visible','Off')
        set(hpgaussbutton2_12,'Visible','Off')
        set(hpgaussbutton2_13,'Visible','Off')
    end

    function slider1_Callback(slider1,eventdata,handles)
        % update the displayed image when the slider is adjusted
        slice = round(get(slider1,'Value'));
        a = (minSlice:maxSlice);
        Value1 = slice;
        [~,I] = min(abs(Value1-a));
        Value1 = a(I);
        set(slider1,'Value',Value1);
        slice = round(get(slider1,'Value'));
        set(plotinfo.s2,'String',Value1);
        set(plotinfo.s5,'String',TimepointInfoTable(slice,2));
        set(plotinfo.s7,'String',TimepointInfoTable(slice,3));
        if xList(slice) == 0 
            set(plotinfo.sx,'String','');
            set(plotinfo.sy,'String','');
            clean_hpzoom
            clean_hpzoom2
        else
            set(plotinfo.sx,'String',['X = ' num2str(round(xList(slice)))]);
            set(plotinfo.sy,'String',['Y = ' num2str(round(yList(slice)))]);
            update_hpzoom
            update_hpzoom2
        end
        clean_hpgauss
        clean_hpgauss2
        figure(hfig)
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            fullPathstring = TimepointInfoTable{slice,1};
            SequenceString = TimepointInfoTable{slice,2};
            Timepoint = str2num(TimepointInfoTable{slice,3});
            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
            infoString = imfinfo(fullPathstring);
            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+zSlice, 'Info', infoString);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushNEXT_Callback(pushDot,eventdata,handles)
        slice = round(get(slider1,'Value'));
        if slice2range(slice,2) ~= n
            slice = slice2range(slice,2) + slice;
        end
        set(slider1,'Value',slice);
        slider1_Callback(slider1)
    end

    function pushPREV_Callback(pushDot,eventdata,handles)
        slice = round(get(slider1,'Value'));
        if slice2range(slice,1) ~= 1
            slice = slice - slice2range(slice,1) + 1;
        end
        set(slider1,'Value',slice);
        slider1_Callback(slider1)
    end

	function pushNEXTSpot_Callback(hObject, eventdata, handles)
        if slice2range(slice,1) == 1
            slice1 = slice;
            slice2 = slice2range(slice,2) + slice;
        else
            slice1 = slice - slice2range(slice,1) + 1;
            slice2 = slice;
        end
        fullPathString1 = TimepointInfoTable{slice1,1};
        SequenceString1 = TimepointInfoTable{slice1,2};
        num_images1 = str2num(TimepointInfoTable{slice1,5});
        [pathString1, ~, extString1] = fileparts(fullPathString1);
        infoString1 = imfinfo(fullPathString1);
        fullFilePathInput1 = fullfile(pathString1,[SequenceString1 '_MULTIPLE_results' '.xls']);  
        fullPathString2 = TimepointInfoTable{slice2,1};
        SequenceString2 = TimepointInfoTable{slice2,2};
        num_images2 = str2num(TimepointInfoTable{slice2,5});
        [pathString2, ~, extString2] = fileparts(fullPathString2);
        infoString2 = imfinfo(fullPathString2);                        
        fullFilePathInput2 = fullfile(pathString2,[SequenceString2 '_MULTIPLE_results' '.xls']);
        if exist(fullFilePathInput1,'file') ~= 2 || exist(fullFilePathInput2,'file') ~= 2
            warndlg('No results file!')
        else
            [num1,~,~] = xlsread(fullFilePathInput1,'Sheet1');
            n_dots1 = size(num1,1);
            [num2,~,~] = xlsread(fullFilePathInput2,'Sheet1');
            n_dots2 = size(num2,1);
            if ~(size(num1,2) == 20 || size(num1,2) == 13) || ~(size(num2,2) == 20 || size(num2,2) == 13)
                warndlg('Results file does not have the right format')
            elseif dot_number+1 > n_dots1 || dot_number+1 >n_dots2
                warndlg('No more spots on results file!')
            elseif dot_number+1 <= n_dots1 && dot_number+1 <= n_dots2
                if ~isnan(num1(dot_number+1,1)) && ~isnan(num2(dot_number+1,1))
                    i_minSequence1 = NaN(1,n_dots1);
                    i_maxSequence1 = NaN(1,n_dots1);
                    x_Sequence1 = NaN(1,n_dots1);
                    y_Sequence1 = NaN(1,n_dots1);
                    z_Sequence1 = NaN(1,n_dots1);
                    t_Sequence1 = NaN(1,n_dots1);
                    rf_Sequence1 = NaN(1,n_dots1);
                    r_Sequence1 = NaN(1,n_dots1);
                    gM1_Sequence1 = NaN(1,n_dots1);
                    gM2_Sequence1 = NaN(1,n_dots1);
                    gM3_Sequence1 = NaN(1,n_dots1);
                    gM4_Sequence1 = NaN(1,n_dots1);
                    gM5_Sequence1 = NaN(1,n_dots1);
                    gM6_Sequence1 = NaN(1,n_dots1);
                    i_minSequence2 = NaN(1,n_dots2);
                    i_maxSequence2 = NaN(1,n_dots2);
                    x_Sequence2 = NaN(1,n_dots2);
                    y_Sequence2 = NaN(1,n_dots2);
                    z_Sequence2 = NaN(1,n_dots2);
                    t_Sequence2 = NaN(1,n_dots2);
                    rf_Sequence2 = NaN(1,n_dots2);
                    r_Sequence2 = NaN(1,n_dots2);
                    gM1_Sequence2 = NaN(1,n_dots2);
                    gM2_Sequence2 = NaN(1,n_dots2);
                    gM3_Sequence2 = NaN(1,n_dots2);
                    gM4_Sequence2 = NaN(1,n_dots2);
                    gM5_Sequence2 = NaN(1,n_dots2);
                    gM6_Sequence2 = NaN(1,n_dots2);
                    for i = 1:size(num1,1)
                        if ~isnan(num1(i,1))
                            i_minSequence1(num1(i,1)) = num1(i,4);
                            i_maxSequence1(num1(i,1)) = num1(i,5);
                            x_Sequence1(num1(i,1)) = num1(i,6);
                            y_Sequence1(num1(i,1)) = num1(i,7);
                            z_Sequence1(num1(i,1)) = num1(i,8);
                            t_Sequence1(num1(i,1)) = num1(i,9);
                            rf_Sequence1(num1(i,1)) = num1(i,12);
                            r_Sequence1(num1(i,1)) = num1(i,13);
                            if size(num1,2) == 20
                                gM1_Sequence1(num1(i,1)) = num1(i,15);
                                gM2_Sequence1(num1(i,1)) = num1(i,16);
                                gM3_Sequence1(num1(i,1)) = num1(i,17);
                                gM4_Sequence1(num1(i,1)) = num1(i,18);
                                gM5_Sequence1(num1(i,1)) = num1(i,19);
                                gM6_Sequence1(num1(i,1)) = num1(i,20);
                            end
                        end
                    end
                    for i = 1:size(num2,1)
                        if ~isnan(num2(i,1))
                            i_minSequence2(num2(i,1)) = num2(i,4);
                            i_maxSequence2(num2(i,1)) = num2(i,5);
                            x_Sequence2(num2(i,1)) = num2(i,6);
                            y_Sequence2(num2(i,1)) = num2(i,7);
                            z_Sequence2(num2(i,1)) = num2(i,8);
                            t_Sequence2(num2(i,1)) = num2(i,9);
                            rf_Sequence2(num2(i,1)) = num2(i,12);
                            r_Sequence2(num2(i,1)) = num2(i,13);
                            if size(num2,2) == 20
                                gM1_Sequence2(num2(i,1)) = num2(i,15);
                                gM2_Sequence2(num2(i,1)) = num2(i,16);
                                gM3_Sequence2(num2(i,1)) = num2(i,17);
                                gM4_Sequence2(num2(i,1)) = num2(i,18);
                                gM5_Sequence2(num2(i,1)) = num2(i,19);
                                gM6_Sequence2(num2(i,1)) = num2(i,20);
                            end
                        end
                    end
                    if ~isnan(num1(dot_number+1,1)) && ~isnan(num2(dot_number+1,1))
                        if slice2range(slice,1) == 1
                            set(slider1,'Value',t_Sequence1(dot_number+1));
                            zSlice = z_Sequence1(dot_number+1);
                        else
                            set(slider1,'Value',slice2range(slice,1) + t_Sequence2(dot_number+1) - 1);
                            zSlice = z_Sequence2(dot_number+1);
                        end
                        set(hinputZset,'String',num2str(zSlice));
                        set(slider3,'Value',zSlice);
                        if strcmp(bg.SelectedObject.String,'MIP')
                            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        elseif strcmp(bg.SelectedObject.String,'Slice')
                            num_images = str2num(TimepointInfoTable{slice,5});
                            fullPathstring = TimepointInfoTable{slice,1};
                            SequenceString = TimepointInfoTable{slice,2};
                            Timepoint = str2num(TimepointInfoTable{slice,3});
                            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
                            infoString = imfinfo(fullPathstring);
                            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+zSlice, 'Info', infoString);
                            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        end
                        drawnow
                        slider1_Callback(slider1)
                        TFI1 = num1(dot_number+1,2);
                        W1 = num1(dot_number+1,3);
                        TFI2 = num2(dot_number+1,2);
                        W2 = num2(dot_number+1,3);
                        SforZ1 = zeros(infoString1(1).Height, infoString1(1).Width, num_images1);
                        for j = 1:num_images1
                            SforZ1(:,:,j) = imread(fullfile(pathString1, [SequenceString1 extString1]),(t_Sequence1(dot_number+1)-1)*num_images1+j, 'Info', infoString1);
                        end
                        B1 = SforZ1(y_Sequence1(dot_number+1)-rf_Sequence1(dot_number+1):y_Sequence1(dot_number+1)+rf_Sequence1(dot_number+1), x_Sequence1(dot_number+1)-rf_Sequence1(dot_number+1):x_Sequence1(dot_number+1)+rf_Sequence1(dot_number+1), :);
                        d1 = double(B1(1:rf_Sequence1(dot_number+1)+rf_Sequence1(dot_number+1)+1, 1:rf_Sequence1(dot_number+1)+rf_Sequence1(dot_number+1)+1, z_Sequence1(dot_number+1)));
                        figure(hpgauss)
                        close(hpgauss)
                        hpgauss = figure('Name','FIT1','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,545,221,185]);
                        hpgaussbuttons = findall(hpgauss);
                        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
                        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
                        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
                        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
                        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
                        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
                        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
                        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
                        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
                        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
                        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
                        set(hpgaussbutton1,'Visible','Off')
                        set(hpgaussbutton2,'Visible','Off')
                        set(hpgaussbutton4,'Visible','Off')
                        set(hpgaussbutton5,'Visible','Off')
                        set(hpgaussbutton7,'Visible','Off')
                        set(hpgaussbutton8,'Visible','Off')
                        set(hpgaussbutton9,'Visible','Off')
                        set(hpgaussbutton10,'Visible','Off')
                        set(hpgaussbutton11,'Visible','Off')
                        set(hpgaussbutton12,'Visible','Off')
                        set(hpgaussbutton13,'Visible','Off')
                        plotgaussfit_in_GUI([gM1_Sequence1(dot_number+1) gM2_Sequence1(dot_number+1) gM3_Sequence1(dot_number+1) gM4_Sequence1(dot_number+1) gM5_Sequence1(dot_number+1) gM6_Sequence1(dot_number+1)],d1,pSize,'n');
                        I_MAX = max([i_maxSequence1, i_maxSequence2]);
                        I_MIN = min([i_minSequence1, i_minSequence2]);
                        axis ([-rf_Sequence1(dot_number+1)*pSize rf_Sequence1(dot_number+1)*pSize -rf_Sequence1(dot_number+1)*pSize rf_Sequence1(dot_number+1)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        figure(hpzoom);
                        singleFrameZoom1 = SforZ1(y_Sequence1(dot_number+1)-r_Sequence1(dot_number+1):y_Sequence1(dot_number+1)+r_Sequence1(dot_number+1), x_Sequence1(dot_number+1)-r_Sequence1(dot_number+1):x_Sequence1(dot_number+1)+r_Sequence1(dot_number+1), z_Sequence1(dot_number+1));
                        imshow(singleFrameZoom1,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        SforZ2 = zeros(infoString2(1).Height, infoString2(1).Width, num_images2);
                        for j = 1:num_images2
                            SforZ2(:,:,j) = imread(fullfile(pathString2, [SequenceString2 extString2]),(t_Sequence2(dot_number+1)-1)*num_images2+j, 'Info', infoString2);
                        end
                        B2 = SforZ2(y_Sequence2(dot_number+1)-rf_Sequence2(dot_number+1):y_Sequence2(dot_number+1)+rf_Sequence2(dot_number+1), x_Sequence2(dot_number+1)-rf_Sequence2(dot_number+1):x_Sequence2(dot_number+1)+rf_Sequence2(dot_number+1), :);
                        d2 = double(B2(1:rf_Sequence2(dot_number+1)+rf_Sequence2(dot_number+1)+1, 1:rf_Sequence2(dot_number+1)+rf_Sequence2(dot_number+1)+1, z_Sequence2(dot_number+1)));
                        figure(hpgauss2)
                        close(hpgauss2)
                        hpgauss2 = figure('Name','FIT2','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,245,221,185]);
                        hpgaussbuttons2 = findall(hpgauss2);
                        hpgaussbutton2_1 = findall(hpgaussbuttons2,'ToolTipString','New Figure');
                        hpgaussbutton2_2 = findall(hpgaussbuttons2,'ToolTipString','Open File');
                        hpgaussbutton2_4 = findall(hpgaussbuttons2,'ToolTipString','Print Figure');
                        hpgaussbutton2_5 = findall(hpgaussbuttons2,'ToolTipString','Edit Plot');
                        hpgaussbutton2_7 = findall(hpgaussbuttons2,'ToolTipString','Data Cursor');
                        hpgaussbutton2_8 = findall(hpgaussbuttons2,'ToolTipString','Brush/Select Data');
                        hpgaussbutton2_9 = findall(hpgaussbuttons2,'ToolTipString','Link Plot');
                        hpgaussbutton2_10 = findall(hpgaussbuttons2,'ToolTipString','Insert Colorbar');
                        hpgaussbutton2_11 = findall(hpgaussbuttons2,'ToolTipString','Insert Legend');
                        hpgaussbutton2_12 = findall(hpgaussbuttons2,'ToolTipString','Hide Plot Tools');
                        hpgaussbutton2_13 = findall(hpgaussbuttons2,'ToolTipString','Show Plot Tools and Dock Figure');
                        set(hpgaussbutton2_1,'Visible','Off')
                        set(hpgaussbutton2_2,'Visible','Off')
                        set(hpgaussbutton2_4,'Visible','Off')
                        set(hpgaussbutton2_5,'Visible','Off')
                        set(hpgaussbutton2_7,'Visible','Off')
                        set(hpgaussbutton2_8,'Visible','Off')
                        set(hpgaussbutton2_9,'Visible','Off')
                        set(hpgaussbutton2_10,'Visible','Off')
                        set(hpgaussbutton2_11,'Visible','Off')
                        set(hpgaussbutton2_12,'Visible','Off')
                        set(hpgaussbutton2_13,'Visible','Off')
                        plotgaussfit_in_GUI([gM1_Sequence2(dot_number+1) gM2_Sequence2(dot_number+1) gM3_Sequence2(dot_number+1) gM4_Sequence2(dot_number+1) gM5_Sequence2(dot_number+1) gM6_Sequence2(dot_number+1)],d2,pSize,'n');
                        I_MAX = max([i_maxSequence1, i_maxSequence2]);
                        I_MIN = min([i_minSequence1, i_minSequence2]);
                        axis ([-rf_Sequence2(dot_number+1)*pSize rf_Sequence2(dot_number+1)*pSize -rf_Sequence2(dot_number+1)*pSize rf_Sequence2(dot_number+1)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        figure(hpzoom2);
                        singleFrameZoom2 = SforZ2(y_Sequence2(dot_number+1)-r_Sequence2(dot_number+1):y_Sequence2(dot_number+1)+r_Sequence2(dot_number+1), x_Sequence2(dot_number+1)-r_Sequence2(dot_number+1):x_Sequence2(dot_number+1)+r_Sequence2(dot_number+1), z_Sequence2(dot_number+1));
                        imshow(singleFrameZoom2,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        dot_number = dot_number + 1;
                        set(editDot,'String',num2str(dot_number));
                        set(plotinfo.sDot,'String',['Spot ' num2str(round(dot_number))]);
                        set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI1)) ' | ' num2str(round(TFI2))]);
                        set(plotinfo.sI,'String',['W = ' num2str(W1,3) ' | ' num2str(W2,3)]);
                        set(plotinfo.sZ,'String',['Z = ' num2str(round(z_Sequence1(dot_number))) ' | ' num2str(round(z_Sequence2(dot_number)))]);
                        figure(hfig)
                        if slice2range(slice,1) == 1
                            rectangle('Position',[x_Sequence1(dot_number)-(rf_Sequence1(dot_number)+8)/2,y_Sequence1(dot_number)-(rf_Sequence1(dot_number)+8)/2,rf_Sequence1(dot_number)+8,rf_Sequence1(dot_number)+8],'Curvature',[1,1],'Edgecolor','w');
                        else
                            rectangle('Position',[x_Sequence2(dot_number)-(rf_Sequence2(dot_number)+8)/2,y_Sequence2(dot_number)-(rf_Sequence2(dot_number)+8)/2,rf_Sequence2(dot_number)+8,rf_Sequence2(dot_number)+8],'Curvature',[1,1],'Edgecolor','w');
                        end
                        drawnow
                    end
                end
            end
        end
    end

    function pushPREVSpot_Callback(hObject, eventdata, handles)
        if slice2range(slice,1) == 1
            slice1 = slice;
            slice2 = slice2range(slice,2) + slice;
        else
            slice1 = slice - slice2range(slice,1) + 1;
            slice2 = slice;
        end
        fullPathString1 = TimepointInfoTable{slice1,1};
        SequenceString1 = TimepointInfoTable{slice1,2};
        num_images1 = str2num(TimepointInfoTable{slice1,5});
        [pathString1, ~, extString1] = fileparts(fullPathString1);
        infoString1 = imfinfo(fullPathString1);
        fullFilePathInput1 = fullfile(pathString1,[SequenceString1 '_MULTIPLE_results' '.xls']);  
        fullPathString2 = TimepointInfoTable{slice2,1};
        SequenceString2 = TimepointInfoTable{slice2,2};
        num_images2 = str2num(TimepointInfoTable{slice2,5});
        [pathString2, ~, extString2] = fileparts(fullPathString2);
        infoString2 = imfinfo(fullPathString2);                        
        fullFilePathInput2 = fullfile(pathString2,[SequenceString2 '_MULTIPLE_results' '.xls']);
        if exist(fullFilePathInput1,'file') ~= 2 || exist(fullFilePathInput2,'file') ~= 2
            warndlg('No results file!')
        else
            [num1,~,~] = xlsread(fullFilePathInput1,'Sheet1');
            n_dots1 = size(num1,1);
            [num2,~,~] = xlsread(fullFilePathInput2,'Sheet1');
            n_dots2 = size(num2,1);
            if ~(size(num1,2) == 20 || size(num1,2) == 13) || ~(size(num2,2) == 20 || size(num2,2) == 13)
                warndlg('Results file does not have the right format')
            elseif dot_number == 1
                warndlg('You are already on the first spot!')
            elseif dot_number-1 > 0
                if ~isnan(num1(dot_number-1,1)) && ~isnan(num2(dot_number-1,1))
                    i_minSequence1 = NaN(1,n_dots1);
                    i_maxSequence1 = NaN(1,n_dots1);
                    x_Sequence1 = NaN(1,n_dots1);
                    y_Sequence1 = NaN(1,n_dots1);
                    z_Sequence1 = NaN(1,n_dots1);
                    t_Sequence1 = NaN(1,n_dots1);
                    rf_Sequence1 = NaN(1,n_dots1);
                    r_Sequence1 = NaN(1,n_dots1);
                    gM1_Sequence1 = NaN(1,n_dots1);
                    gM2_Sequence1 = NaN(1,n_dots1);
                    gM3_Sequence1 = NaN(1,n_dots1);
                    gM4_Sequence1 = NaN(1,n_dots1);
                    gM5_Sequence1 = NaN(1,n_dots1);
                    gM6_Sequence1 = NaN(1,n_dots1);
                    i_minSequence2 = NaN(1,n_dots2);
                    i_maxSequence2 = NaN(1,n_dots2);
                    x_Sequence2 = NaN(1,n_dots2);
                    y_Sequence2 = NaN(1,n_dots2);
                    z_Sequence2 = NaN(1,n_dots2);
                    t_Sequence2 = NaN(1,n_dots2);
                    rf_Sequence2 = NaN(1,n_dots2);
                    r_Sequence2 = NaN(1,n_dots2);
                    gM1_Sequence2 = NaN(1,n_dots2);
                    gM2_Sequence2 = NaN(1,n_dots2);
                    gM3_Sequence2 = NaN(1,n_dots2);
                    gM4_Sequence2 = NaN(1,n_dots2);
                    gM5_Sequence2 = NaN(1,n_dots2);
                    gM6_Sequence2 = NaN(1,n_dots2);
                    for i = 1:size(num1,1)
                        if ~isnan(num1(i,1))
                            i_minSequence1(num1(i,1)) = num1(i,4);
                            i_maxSequence1(num1(i,1)) = num1(i,5);
                            x_Sequence1(num1(i,1)) = num1(i,6);
                            y_Sequence1(num1(i,1)) = num1(i,7);
                            z_Sequence1(num1(i,1)) = num1(i,8);
                            t_Sequence1(num1(i,1)) = num1(i,9);
                            rf_Sequence1(num1(i,1)) = num1(i,12);
                            r_Sequence1(num1(i,1)) = num1(i,13);
                            if size(num1,2) == 20
                                gM1_Sequence1(num1(i,1)) = num1(i,15);
                                gM2_Sequence1(num1(i,1)) = num1(i,16);
                                gM3_Sequence1(num1(i,1)) = num1(i,17);
                                gM4_Sequence1(num1(i,1)) = num1(i,18);
                                gM5_Sequence1(num1(i,1)) = num1(i,19);
                                gM6_Sequence1(num1(i,1)) = num1(i,20);
                            end
                        end
                    end
                    for i = 1:size(num2,1)
                        if ~isnan(num2(i,1))
                            i_minSequence2(num2(i,1)) = num2(i,4);
                            i_maxSequence2(num2(i,1)) = num2(i,5);
                            x_Sequence2(num2(i,1)) = num2(i,6);
                            y_Sequence2(num2(i,1)) = num2(i,7);
                            z_Sequence2(num2(i,1)) = num2(i,8);
                            t_Sequence2(num2(i,1)) = num2(i,9);
                            rf_Sequence2(num2(i,1)) = num2(i,12);
                            r_Sequence2(num2(i,1)) = num2(i,13);
                            if size(num2,2) == 20
                                gM1_Sequence2(num2(i,1)) = num2(i,15);
                                gM2_Sequence2(num2(i,1)) = num2(i,16);
                                gM3_Sequence2(num2(i,1)) = num2(i,17);
                                gM4_Sequence2(num2(i,1)) = num2(i,18);
                                gM5_Sequence2(num2(i,1)) = num2(i,19);
                                gM6_Sequence2(num2(i,1)) = num2(i,20);
                            end
                        end
                    end
                    if ~isnan(num1(dot_number-1,1)) && ~isnan(num2(dot_number-1,1))
                        if slice2range(slice,1) == 1
                            set(slider1,'Value',t_Sequence1(dot_number-1));
                            zSlice = z_Sequence1(dot_number-1);
                        else
                            set(slider1,'Value',slice2range(slice,1) + t_Sequence2(dot_number-1) - 1);
                            zSlice = z_Sequence2(dot_number-1);
                        end
                        set(hinputZset,'String',num2str(zSlice));
                        set(slider3,'Value',zSlice);
                        if strcmp(bg.SelectedObject.String,'MIP')
                            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        elseif strcmp(bg.SelectedObject.String,'Slice')
                            num_images = str2num(TimepointInfoTable{slice,5});
                            fullPathstring = TimepointInfoTable{slice,1};
                            SequenceString = TimepointInfoTable{slice,2};
                            Timepoint = str2num(TimepointInfoTable{slice,3});
                            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
                            infoString = imfinfo(fullPathstring);
                            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+zSlice, 'Info', infoString);
                            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
                        end
                        drawnow
                        slider1_Callback(slider1)
                        TFI1 = num1(dot_number-1,2);
                        W1 = num1(dot_number-1,3);
                        TFI2 = num2(dot_number-1,2);
                        W2 = num2(dot_number-1,3);
                        SforZ1 = zeros(infoString1(1).Height, infoString1(1).Width, num_images1);
                        for j = 1:num_images1
                            SforZ1(:,:,j) = imread(fullfile(pathString1, [SequenceString1 extString1]),(t_Sequence1(dot_number-1)-1)*num_images1+j, 'Info', infoString1);
                        end
                        B1 = SforZ1(y_Sequence1(dot_number-1)-rf_Sequence1(dot_number-1):y_Sequence1(dot_number-1)+rf_Sequence1(dot_number-1), x_Sequence1(dot_number-1)-rf_Sequence1(dot_number-1):x_Sequence1(dot_number-1)+rf_Sequence1(dot_number-1), :);
                        d1 = double(B1(1:rf_Sequence1(dot_number-1)+rf_Sequence1(dot_number-1)+1, 1:rf_Sequence1(dot_number-1)+rf_Sequence1(dot_number-1)+1, z_Sequence1(dot_number-1)));
                        figure(hpgauss)
                        close(hpgauss)
                        hpgauss = figure('Name','FIT1','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,545,221,185]);
                        hpgaussbuttons = findall(hpgauss);
                        hpgaussbutton1 = findall(hpgaussbuttons,'ToolTipString','New Figure');
                        hpgaussbutton2 = findall(hpgaussbuttons,'ToolTipString','Open File');
                        hpgaussbutton4 = findall(hpgaussbuttons,'ToolTipString','Print Figure');
                        hpgaussbutton5 = findall(hpgaussbuttons,'ToolTipString','Edit Plot');
                        hpgaussbutton7 = findall(hpgaussbuttons,'ToolTipString','Data Cursor');
                        hpgaussbutton8 = findall(hpgaussbuttons,'ToolTipString','Brush/Select Data');
                        hpgaussbutton9 = findall(hpgaussbuttons,'ToolTipString','Link Plot');
                        hpgaussbutton10 = findall(hpgaussbuttons,'ToolTipString','Insert Colorbar');
                        hpgaussbutton11 = findall(hpgaussbuttons,'ToolTipString','Insert Legend');
                        hpgaussbutton12 = findall(hpgaussbuttons,'ToolTipString','Hide Plot Tools');
                        hpgaussbutton13 = findall(hpgaussbuttons,'ToolTipString','Show Plot Tools and Dock Figure');
                        set(hpgaussbutton1,'Visible','Off')
                        set(hpgaussbutton2,'Visible','Off')
                        set(hpgaussbutton4,'Visible','Off')
                        set(hpgaussbutton5,'Visible','Off')
                        set(hpgaussbutton7,'Visible','Off')
                        set(hpgaussbutton8,'Visible','Off')
                        set(hpgaussbutton9,'Visible','Off')
                        set(hpgaussbutton10,'Visible','Off')
                        set(hpgaussbutton11,'Visible','Off')
                        set(hpgaussbutton12,'Visible','Off')
                        set(hpgaussbutton13,'Visible','Off')
                        plotgaussfit_in_GUI([gM1_Sequence1(dot_number-1) gM2_Sequence1(dot_number-1) gM3_Sequence1(dot_number-1) gM4_Sequence1(dot_number-1) gM5_Sequence1(dot_number-1) gM6_Sequence1(dot_number-1)],d1,pSize,'n');
                        I_MAX = max([i_maxSequence1, i_maxSequence2]);
                        I_MIN = min([i_minSequence1, i_minSequence2]);
                        axis ([-rf_Sequence1(dot_number-1)*pSize rf_Sequence1(dot_number-1)*pSize -rf_Sequence1(dot_number-1)*pSize rf_Sequence1(dot_number-1)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        figure(hpzoom);
                        singleFrameZoom1 = SforZ1(y_Sequence1(dot_number-1)-r_Sequence1(dot_number-1):y_Sequence1(dot_number-1)+r_Sequence1(dot_number-1), x_Sequence1(dot_number-1)-r_Sequence1(dot_number-1):x_Sequence1(dot_number-1)+r_Sequence1(dot_number-1), z_Sequence1(dot_number-1));
                        imshow(singleFrameZoom1,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        SforZ2 = zeros(infoString2(1).Height, infoString2(1).Width, num_images2);
                        for j = 1:num_images2
                            SforZ2(:,:,j) = imread(fullfile(pathString2, [SequenceString2 extString2]),(t_Sequence2(dot_number-1)-1)*num_images2+j, 'Info', infoString2);
                        end
                        B2 = SforZ2(y_Sequence2(dot_number-1)-rf_Sequence2(dot_number-1):y_Sequence2(dot_number-1)+rf_Sequence2(dot_number-1), x_Sequence2(dot_number-1)-rf_Sequence2(dot_number-1):x_Sequence2(dot_number-1)+rf_Sequence2(dot_number-1), :);
                        d2 = double(B2(1:rf_Sequence2(dot_number-1)+rf_Sequence2(dot_number-1)+1, 1:rf_Sequence2(dot_number-1)+rf_Sequence2(dot_number-1)+1, z_Sequence2(dot_number-1)));
                        figure(hpgauss2)
                        close(hpgauss2)
                        hpgauss2 = figure('Name','FIT2','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,245,221,185]);
                        hpgaussbuttons2 = findall(hpgauss2);
                        hpgaussbutton2_1 = findall(hpgaussbuttons2,'ToolTipString','New Figure');
                        hpgaussbutton2_2 = findall(hpgaussbuttons2,'ToolTipString','Open File');
                        hpgaussbutton2_4 = findall(hpgaussbuttons2,'ToolTipString','Print Figure');
                        hpgaussbutton2_5 = findall(hpgaussbuttons2,'ToolTipString','Edit Plot');
                        hpgaussbutton2_7 = findall(hpgaussbuttons2,'ToolTipString','Data Cursor');
                        hpgaussbutton2_8 = findall(hpgaussbuttons2,'ToolTipString','Brush/Select Data');
                        hpgaussbutton2_9 = findall(hpgaussbuttons2,'ToolTipString','Link Plot');
                        hpgaussbutton2_10 = findall(hpgaussbuttons2,'ToolTipString','Insert Colorbar');
                        hpgaussbutton2_11 = findall(hpgaussbuttons2,'ToolTipString','Insert Legend');
                        hpgaussbutton2_12 = findall(hpgaussbuttons2,'ToolTipString','Hide Plot Tools');
                        hpgaussbutton2_13 = findall(hpgaussbuttons2,'ToolTipString','Show Plot Tools and Dock Figure');
                        set(hpgaussbutton2_1,'Visible','Off')
                        set(hpgaussbutton2_2,'Visible','Off')
                        set(hpgaussbutton2_4,'Visible','Off')
                        set(hpgaussbutton2_5,'Visible','Off')
                        set(hpgaussbutton2_7,'Visible','Off')
                        set(hpgaussbutton2_8,'Visible','Off')
                        set(hpgaussbutton2_9,'Visible','Off')
                        set(hpgaussbutton2_10,'Visible','Off')
                        set(hpgaussbutton2_11,'Visible','Off')
                        set(hpgaussbutton2_12,'Visible','Off')
                        set(hpgaussbutton2_13,'Visible','Off')
                        plotgaussfit_in_GUI([gM1_Sequence2(dot_number-1) gM2_Sequence2(dot_number-1) gM3_Sequence2(dot_number-1) gM4_Sequence2(dot_number-1) gM5_Sequence2(dot_number-1) gM6_Sequence2(dot_number-1)],d2,pSize,'n');
                        I_MAX = max([i_maxSequence1, i_maxSequence2]);
                        I_MIN = min([i_minSequence1, i_minSequence2]);
                        axis ([-rf_Sequence2(dot_number-1)*pSize rf_Sequence2(dot_number-1)*pSize -rf_Sequence2(dot_number-1)*pSize rf_Sequence2(dot_number-1)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        figure(hpzoom2);
                        singleFrameZoom2 = SforZ2(y_Sequence2(dot_number-1)-r_Sequence2(dot_number-1):y_Sequence2(dot_number-1)+r_Sequence2(dot_number-1), x_Sequence2(dot_number-1)-r_Sequence2(dot_number-1):x_Sequence2(dot_number-1)+r_Sequence2(dot_number-1), z_Sequence2(dot_number-1));
                        imshow(singleFrameZoom2,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        dot_number = dot_number - 1;
                        set(editDot,'String',num2str(dot_number));
                        set(plotinfo.sDot,'String',['Spot ' num2str(round(dot_number))]);
                        set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI1)) ' | ' num2str(round(TFI2))]);
                        set(plotinfo.sI,'String',['W = ' num2str(W1,3) ' | ' num2str(W2,3)]);
                        set(plotinfo.sZ,'String',['Z = ' num2str(round(z_Sequence1(dot_number))) ' | ' num2str(round(z_Sequence2(dot_number)))]);
                        figure(hfig)
                        if slice2range(slice,1) == 1
                            rectangle('Position',[x_Sequence1(dot_number)-(rf_Sequence1(dot_number)+8)/2,y_Sequence1(dot_number)-(rf_Sequence1(dot_number)+8)/2,rf_Sequence1(dot_number)+8,rf_Sequence1(dot_number)+8],'Curvature',[1,1],'Edgecolor','w');
                        else
                            rectangle('Position',[x_Sequence2(dot_number)-(rf_Sequence2(dot_number)+8)/2,y_Sequence2(dot_number)-(rf_Sequence2(dot_number)+8)/2,rf_Sequence2(dot_number)+8,rf_Sequence2(dot_number)+8],'Curvature',[1,1],'Edgecolor','w');
                        end
                        drawnow
                    end
                end
            end
        end
    end

    function slider2_Callback(slider2,eventdata,handles)
        %adjust image contrast
        newMax = get(slider2,'Value');
        slice = get(slider1,'Value');
        a = (minImg:maxImg);
        Value2 = round(newMax);
        [~,I] = min(abs(Value2-a));
        Value2 = a(I);
        set(slider2,'Value',Value2);
        if ~isnan(zSequence(slice))
            update_hpzoom
        end
        figure(hfig)
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            num_images = str2num(TimepointInfoTable{slice,5});
            fullPathstring = TimepointInfoTable{slice,1};
            SequenceString = TimepointInfoTable{slice,2};
            Timepoint = str2num(TimepointInfoTable{slice,3});
            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
            infoString = imfinfo(fullPathstring);
            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+zSlice, 'Info', infoString);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function slider3_Callback(slider2,eventdata,handles)
        %adjust image contrast
        newZ = floor(get(slider3,'Value'));
        set(slider3,'Value',newZ);
        set(hinputZset,'String',num2str(newZ));
        slice = get(slider1,'Value');
        if xList(slice)~=0
            update_hpzoom
        end
        figure(hfig)
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            num_images = str2num(TimepointInfoTable{slice,5});
            fullPathstring = TimepointInfoTable{slice,1};
            SequenceString = TimepointInfoTable{slice,2};
            Timepoint = str2num(TimepointInfoTable{slice,3});
            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
            infoString = imfinfo(fullPathstring);
            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+newZ, 'Info', infoString);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100);
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pixelInfo(hObj,~,~)
        % get coordinates of clicked pixel
        axesHandle  = get(hObj,'Parent');
        cp = get(axesHandle,'CurrentPoint');
        x = cp(1,1);
        y = cp(1,2);
        xi = round(x);
        yi = round(y);
        newZ = get(slider3,'Value');
        if slice2range(slice) == 1
            S_proj(:,:,slice) = S_proj_clean_for_fit(:,:,slice);
            S_proj(:,:,slice2range(slice,2)+slice) = S_proj_clean_for_fit(:,:,slice2range(slice,2)+slice);
        else
            S_proj(:,:,slice) = S_proj_clean_for_fit(:,:,slice);
            S_proj(:,:,slice - slice2range(slice,1) + 1) = S_proj_clean_for_fit(:,:,slice - slice2range(slice,1) + 1);
        end
        fullPathstring = TimepointInfoTable{slice,1};
        infoString = imfinfo(fullPathstring);
        if dot_number == 1
            S_proj(:,:,slice) = S_proj_clean(:,:,slice);
        end
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        stdmeanratio = str2num(get(hinputS,'String'));
        if strcmp(bg.SelectedObject.String,'MIP')
            [x, y, z, detected] = track_xyz(xi,yi,r,stdmeanratio,slice);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            [x, y, z, detected] = track_xynewZ(xi,yi,r,stdmeanratio,slice,newZ);
        end
        set(slider3,'Value',z);
        if slice2range(slice,1) == 1
            xList(slice) = x;
            yList(slice) = y;
            zSequence(slice) = z;
            rSequence(slice) = r;
            rfSequence(slice) = rf;
            xList(slice + slice2range(slice,2)) = x;
            yList(slice + slice2range(slice,2)) = y;
            zSequence(slice + slice2range(slice,2)) = z;
            rSequence(slice + slice2range(slice,2)) = r;
            rfSequence(slice + slice2range(slice,2)) = rf;
        else
            xList(slice) = x;
            yList(slice) = y;
            zSequence(slice) = z;
            rSequence(slice) = r;
            rfSequence(slice) = rf;
            xList(slice - slice2range(slice,1) + 1) = x;
            yList(slice - slice2range(slice,1) + 1) = y;
            zSequence(slice - slice2range(slice,1) + 1) = z;
            rSequence(slice - slice2range(slice,1) + 1) = r;
            rfSequence(slice - slice2range(slice,1) + 1) = rf;
        end
        if strcmp(bg.SelectedObject.String,'MIP')
            set(hinputZset,'String',num2str(z));
        end
        set(plotinfo.sx,'String',['X = ' num2str(round(x))]);
        set(plotinfo.sy,'String',['Y = ' num2str(round(y))]);
        assignin('base','x',round(x));
        assignin('base','y',round(y));
        assignin('base','t',round(slice));
        if slice2range(slice,1) == 1
            if (y-r > 0) && (y+r < infoString(1).Height) && (x-r > 0) && (x+r < infoString(1).Height)
                S_proj(y-r-1:y+r+1, x-r-1, slice) = 2^16;
                S_proj(y-r-1:y+r+1, x+r+1, slice) = 2^16;
                S_proj(y-r-1, x-r-1:x+r+1, slice) = 2^16;
                S_proj(y+r+1, x-r-1:x+r+1, slice) = 2^16;
                S_proj(y-r-1:y+r+1, x-r-1, slice2range(slice,2)+slice) = 2^16;
                S_proj(y-r-1:y+r+1, x+r+1, slice2range(slice,2)+slice) = 2^16;
                S_proj(y-r-1, x-r-1:x+r+1, slice2range(slice,2)+slice) = 2^16;
                S_proj(y+r+1, x-r-1:x+r+1, slice2range(slice,2)+slice) = 2^16;
            else
                S_proj(yi-r-1:yi+r+1, xi-r-1, slice) = 2^16;
                S_proj(yi-r-1:yi+r+1, xi+r+1, slice) = 2^16;
                S_proj(yi-r-1, xi-r-1:xi+r+1, slice) = 2^16;
                S_proj(yi+r+1, xi-r-1:xi+r+1, slice) = 2^16;
                S_proj(yi-r-1:yi+r+1, xi-r-1, slice2range(slice,2)+slice) = 2^16;
                S_proj(yi-r-1:yi+r+1, xi+r+1, slice2range(slice,2)+slice) = 2^16;
                S_proj(yi-r-1, xi-r-1:xi+r+1, slice2range(slice,2)+slice) = 2^16;
                S_proj(yi+r+1, xi-r-1:xi+r+1, slice2range(slice,2)+slice) = 2^16;
            end
        else
            if (y-r > 0) && (y+r < infoString(1).Height) && (x-r > 0) && (x+r < infoString(1).Height)
                S_proj(y-r-1:y+r+1, x-r-1, slice) = 2^16;
                S_proj(y-r-1:y+r+1, x+r+1, slice) = 2^16;
                S_proj(y-r-1, x-r-1:x+r+1, slice) = 2^16;
                S_proj(y+r+1, x-r-1:x+r+1, slice) = 2^16;
                S_proj(y-r-1:y+r+1, x-r-1, slice - slice2range(slice,1) + 1) = 2^16;
                S_proj(y-r-1:y+r+1, x+r+1, slice - slice2range(slice,1) + 1) = 2^16;
                S_proj(y-r-1, x-r-1:x+r+1, slice - slice2range(slice,1) + 1) = 2^16;
                S_proj(y+r+1, x-r-1:x+r+1, slice - slice2range(slice,1) + 1) = 2^16;
            else
                S_proj(yi-r-1:yi+r+1, xi-r-1, slice) = 2^16;
                S_proj(yi-r-1:yi+r+1, xi+r+1, slice) = 2^16;
                S_proj(yi-r-1, xi-r-1:xi+r+1, slice) = 2^16;
                S_proj(yi+r+1, xi-r-1:xi+r+1, slice) = 2^16;
                S_proj(yi-r-1:yi+r+1, xi-r-1, slice - slice2range(slice,1) + 1) = 2^16;
                S_proj(yi-r-1:yi+r+1, xi+r+1, slice - slice2range(slice,1) + 1) = 2^16;
                S_proj(yi-r-1, xi-r-1:xi+r+1, slice - slice2range(slice,1) + 1) = 2^16;
                S_proj(yi+r+1, xi-r-1:xi+r+1, slice - slice2range(slice,1) + 1) = 2^16;
            end
        end
        update_hpzoom
        update_hpzoom2
        figure(hfig);
        zSlice = get(slider3,'Value');
        if strcmp(bg.SelectedObject.String,'MIP')
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100,'parent',ha);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            num_images = str2num(TimepointInfoTable{slice,5});
            fullPathstring = TimepointInfoTable{slice,1};
            SequenceString = TimepointInfoTable{slice,2};
            Timepoint = str2num(TimepointInfoTable{slice,3});
            [pathString, ~, extStringSeq] = fileparts(fullPathstring);
            infoString = imfinfo(fullPathstring);
            singleFrame = imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+zSlice, 'Info', infoString);
            himage = imshow(singleFrame,'DisplayRange',[minImg newMax],'InitialMagnification',100,'parent',ha);
        end
        if detected == 1
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','g');
            drawnow
        else
            rectangle('Position',[x-r,y-r,2*r,2*r],'Curvature',[1,1],'Edgecolor','r');
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushDot_Callback(pushDot,eventdata,handles)
        %Gaussian Fitting
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        stdmeanratio = str2num(get(hinputS,'String'));
        fwhm = str2num(get(hinputFWHM,'String'));
        filterSpot = get(checkFilter,'Value');
        x = evalin('base','x');
        y = evalin('base','y');
        newZ = get(slider3,'Value');
        if slice2range(slice,1) == 1
            slice1 = slice;
            slice2 = slice2range(slice,2) + slice;
        else
            slice1 = slice - slice2range(slice,1) + 1;
            slice2 = slice;
        end
        if strcmp(bg.SelectedObject.String,'MIP')
            [~, ~, z1, detected1] = track_xyz(x,y,r,stdmeanratio,slice1);
            [~, ~, z2, detected2] = track_xyz(x,y,r,stdmeanratio,slice2);
        elseif strcmp(bg.SelectedObject.String,'Slice')
            [~, ~, z1, detected1] = track_xynewZ(x,y,r,stdmeanratio,slice1,newZ);
            [~, ~, z2, detected2] = track_xynewZ(x,y,r,stdmeanratio,slice2,newZ);
        end
        noGraph = get(checkGraph,'Value');
        ignoreZ = get(checkZ,'Value');
        if ignoreZ == 1
            ignoreString = {'Yes'};
        elseif ignoreZ == 0
            ignoreString = {'No'};
        end
        if x == 0 && y == 0
            warndlg('No XY coordinates for fitting!')
        else
            update_hpzoom
            num_images1 = str2num(TimepointInfoTable{slice1,5});
            fullPathString1 = TimepointInfoTable{slice1,1};
            SequenceString1 = TimepointInfoTable{slice1,2};
            Timepoint1 = str2num(TimepointInfoTable{slice1,3});
            [pathString1, ~, extString1] = fileparts(fullPathString1);
            set(hinputZset,'String',num2str(z1));  
            if (filterSpot == 1) && (detected1 == 0)
                TFI1 = 0;
                W1 = 0;
                rSequence(slice1) = r;
                rfSequence(slice1) = rf;
                iminSequence(slice1) = NaN;
                imaxSequence(slice1) = NaN;
                gM1Sequence(slice1) = NaN;
                gM2Sequence(slice1) = NaN;
                gM3Sequence(slice1) = NaN;
                gM4Sequence(slice1) = NaN;
                gM5Sequence(slice1) = NaN;
                gM6Sequence(slice1) = NaN;
            else
                [TFI1, W1, I_MIN1, I_MAX1, gM11, gM21, gM31, gM41, gM51, gM61, d, rf1] = dot_3D_z_v12(pathString1,[SequenceString1 extString1],Timepoint1,num_images1,pSize,r,rf,fwhm,z1,ignoreZ,noGraph,xList(slice),yList(slice),z1,iminSequence,imaxSequence);
                rSequence(slice1) = r;
                rfSequence(slice1) = rf1;
                iminSequence(slice1) = I_MIN1;
                imaxSequence(slice1) = I_MAX1;
                gM1Sequence(slice1) = gM11;
                gM2Sequence(slice1) = gM21;
                gM3Sequence(slice1) = gM31;
                gM4Sequence(slice1) = gM41;
                gM5Sequence(slice1) = gM51;
                gM6Sequence(slice1) = gM61;
            end
            set(plotinfo.sDot,'String',['Spot ' num2str(round(dot_number))]);
            set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI1)) ' | ']);
            set(plotinfo.sI,'String',['W = ' num2str(W1,3) ' | ']);
            set(plotinfo.sZ,'String',['Z = ' num2str(round(z1)) ' | ']);
            fullFilePathOutput1 = fullfile(pathString1,[SequenceString1 '_MULTIPLE_results' '.xls']);
            xlswrite(fullFilePathOutput1,{'Spot Number', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 't', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
            xlswrite(fullFilePathOutput1,[dot_number TFI1 W1 iminSequence(slice1) imaxSequence(slice1) x y z1 Timepoint1 detected1 fwhm rfSequence(slice1) rSequence(slice1) ignoreString gM1Sequence(slice1) gM2Sequence(slice1) gM3Sequence(slice1) gM4Sequence(slice1) gM5Sequence(slice1) gM6Sequence(slice1)],'Sheet1',['A' num2str(dot_number+1)]);
            S_proj_clean_for_fit(:,:,slice1) = S_proj(:,:,slice1);
            if ~isnan(gM1Sequence(slice1))
                update_hpgauss
            else
                clean_hpgauss
            end
            update_hpzoom2
            num_images2 = str2num(TimepointInfoTable{slice2,5});
            fullPathString2 = TimepointInfoTable{slice2,1};
            SequenceString2 = TimepointInfoTable{slice2,2};
            Timepoint2 = str2num(TimepointInfoTable{slice2,3});
            [pathString2, ~, extString2] = fileparts(fullPathString2);
            set(hinputZset,'String',num2str(z2));  
            if (filterSpot == 1) && (detected2 == 0)
                TFI2 = 0;
                W2 = 0;
                rSequence(slice2) = r;
                rfSequence(slice2) = rf;
                iminSequence(slice2) = NaN;
                imaxSequence(slice2) = NaN;
                gM1Sequence(slice2) = NaN;
                gM2Sequence(slice2) = NaN;
                gM3Sequence(slice2) = NaN;
                gM4Sequence(slice2) = NaN;
                gM5Sequence(slice2) = NaN;
                gM6Sequence(slice2) = NaN;
            else
                [TFI2, W2, I_MIN2, I_MAX2, gM12, gM22, gM32, gM42, gM52, gM62, d, rf2] = dot_3D_z_v12(pathString2,[SequenceString2 extString2],Timepoint2,num_images2,pSize,r,rf,fwhm,z2,ignoreZ,noGraph,xList(slice),yList(slice),z2,iminSequence,imaxSequence);
                rSequence(slice2) = r;
                rfSequence(slice2) = rf2;
                iminSequence(slice2) = I_MIN2;
                imaxSequence(slice2) = I_MAX2;
                gM1Sequence(slice2) = gM12;
                gM2Sequence(slice2) = gM22;
                gM3Sequence(slice2) = gM32;
                gM4Sequence(slice2) = gM42;
                gM5Sequence(slice2) = gM52;
                gM6Sequence(slice2) = gM62;
            end
            set(plotinfo.sTFI,'String',['TFI = ' num2str(round(TFI1)) ' | ' num2str(round(TFI2))]);
            set(plotinfo.sI,'String',['W = ' num2str(W1,3) ' | ' num2str(W2,3)]);
            set(plotinfo.sZ,'String',['Z = ' num2str(round(z1)) ' | ' num2str(round(z2))]);
            fullFilePathOutput2 = fullfile(pathString2,[SequenceString2 '_MULTIPLE_results' '.xls']);
            xlswrite(fullFilePathOutput2,{'Spot Number', 'TFI', 'W', 'I_MIN', 'I_MAX', 'X', 'Y', 'Z', 't', 'Detected', 'FWHM', 'Grid Size', 'Search Radius', 'Ignore Z', 'gM_1', 'gM_2', 'gM_3', 'gM_4', 'gM_5', 'gM_6'},'Sheet1','A1');
            xlswrite(fullFilePathOutput2,[dot_number TFI2 W2 iminSequence(slice2) imaxSequence(slice2) x y z2 Timepoint2 detected2 fwhm rfSequence(slice2) rSequence(slice2) ignoreString gM1Sequence(slice2) gM2Sequence(slice2) gM3Sequence(slice2) gM4Sequence(slice2) gM5Sequence(slice2) gM6Sequence(slice2)],'Sheet1',['A' num2str(dot_number+1)]);
            S_proj_clean_for_fit(:,:,slice1) = S_proj(:,:,slice1);
            if ~isnan(gM1Sequence(slice2))
                update_hpgauss2
            else
                clean_hpgauss2
            end
            dot_number = dot_number + 1;
            set(editDot,'String',num2str(dot_number));
        end
        figure(hfig);
    end

    function pushAutoDetect_Callback(pushDot,eventdata,handles)
        %automatically detects spots on nuclei
        num_images = str2num(TimepointInfoTable{slice,5});
        fullPathstring = TimepointInfoTable{slice,1};
        SequenceString = TimepointInfoTable{slice,2};
        Timepoint = str2num(TimepointInfoTable{slice,3});
        [pathString, ~, extStringSeq] = fileparts(fullPathstring);
        infoString = imfinfo(fullPathstring);        
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        newZ = get(slider3,'Value');
        stdmeanratio = str2num(get(hinputS,'String'));
        slice = round(get(slider1,'Value'));
        if strcmp(bg.SelectedObject.String,'MIP')
            [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
            himage = imshow(S_proj(:,:,slice),'DisplayRange',[minImg newMax],'InitialMagnification',100);
            drawnow
        elseif strcmp(bg.SelectedObject.String,'Slice')
            SforZ = double(imread(fullfile(pathString, [SequenceString extStringSeq]),(Timepoint-1)*num_images+newZ, 'Info', infoString));
            [pks] = dot_detect_MIP(SforZ,rf);
            himage = imshow(SforZ,'DisplayRange',[minImg newMax],'InitialMagnification',100);
            drawnow
        end
        if ~isempty(pks)
            for j = 1:length(pks(:,1))
                if strcmp(bg.SelectedObject.String,'MIP')
                    [~, ~, ~, detected] = track_xyz(round(pks(j,1)),round(pks(j,2)),r,stdmeanratio,slice);
                elseif strcmp(bg.SelectedObject.String,'Slice')
                    [~, ~, ~, detected] = track_xynewZ(round(pks(j,1)),round(pks(j,2)),r,stdmeanratio,slice,newZ);
                end
                if detected == 1
                    rectangle('Position',[pks(j,1)-(rf+8)/2,pks(j,2)-(rf+8)/2,rf+8,rf+8],'Curvature',[1,1],'Edgecolor','g');
                end
            end
            drawnow
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushAutoFIT_Callback(pushDot,eventdata,handles)
        %automatically detects spots on nuclei
        r = str2num(get(hinputR,'String'));
        rf = str2num(get(hinputRf,'String'))/2;
        stdmeanratio = str2num(get(hinputS,'String'));
        bg.SelectedObject = bgMIP;
        pushAutoDetect_Callback
        [pks] = dot_detect_MIP(S_proj_clean(:,:,slice),rf);
        slice = round(get(slider1,'Value'));
        assignin('base','t',round(slice));       
        if ~isempty(pks)
            for j = 1:length(pks(:,1))
                rSequence(slice) = r;
                assignin('base','x',round(pks(j,1)));
                xi = round(pks(j,1));
                assignin('base','y',round(pks(j,2)));
                yi = round(pks(j,2));
                [~, ~, z, detected] = track_xyz(xi,yi,r,stdmeanratio,slice);
                zSequence(slice) = z;
                set(hinputZset,'String',num2str(zSequence(slice)));  
                if slice2range(slice,1) == 1
                    xList(slice) = xi;
                    yList(slice) = yi;
                    rSequence(slice) = r;
                    rfSequence(slice) = rf;
                    xList(slice + slice2range(slice,2)) = xi;
                    yList(slice + slice2range(slice,2)) = yi;
                    rSequence(slice + slice2range(slice,2)) = r;
                    rfSequence(slice + slice2range(slice,2)) = rf;
                    [~, ~, z2] = track_xyz(xi,yi,r,stdmeanratio,slice + slice2range(slice,2));
                    zSequence(slice + slice2range(slice,2)) = z2;
                else
                    xList(slice) = xi;
                    yList(slice) = yi;
                    rSequence(slice) = r;
                    rfSequence(slice) = rf;
                    xList(slice - slice2range(slice,1) + 1) = xi;
                    yList(slice - slice2range(slice,1) + 1) = yi;
                    rSequence(slice - slice2range(slice,1) + 1) = r;
                    rfSequence(slice - slice2range(slice,1) + 1) = rf;
                    [~, ~, z2] = track_xyz(xi,yi,r,stdmeanratio,slice - slice2range(slice,1) + 1);
                    zSequence(slice - slice2range(slice,1) + 1) = z2;
                end
                if detected == 1
                    rectangle('Position',[pks(j,1)-(rf+8)/2,pks(j,2)-(rf+8)/2,rf+8,rf+8],'Curvature',[1,1],'Edgecolor','w');
                    pushDot_Callback
                end
                drawnow
            end
        end
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function AutoFitAll_Callback(hObject, eventdata, handles)
        slice = round(get(slider1,'Value'));
        for i = slice2range(slice,1):slice2range(slice,2)
            set(slider1,'Value',i);
            slider1_Callback(slider1)
            pushAutoFIT_Callback
            figure(hfig)
        end
        warndlg('All Done!')
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushEXPORTFIGURES_Callback(hObject, eventdata, handles)
        if dot_number == 0
            warndlg('No Gaussian Fits to export!')
        else
            if slice2range(slice,1) == 1
                slice1 = slice;
                slice2 = slice2range(slice,2) + slice;
            else
                slice1 = slice - slice2range(slice,1) + 1;
                slice2 = slice;
            end
            fullPathString1 = TimepointInfoTable{slice1,1};
            SequenceString1 = TimepointInfoTable{slice1,2};
            [pathString1, ~, extString1] = fileparts(fullPathString1);
            fullFilePathInput1 = fullfile(pathString1,[SequenceString1 '_MULTIPLE_results' '.xls']);
            [num1,txt1,raw1] = xlsread(fullFilePathInput1,'Sheet1');
            n_dots1 = size(num1,1);
            i_minSequence1 = NaN(1,n_dots1);
            i_maxSequence1 = NaN(1,n_dots1);
            x_Sequence1 = NaN(1,n_dots1);
            y_Sequence1 = NaN(1,n_dots1);
            z_Sequence1 = NaN(1,n_dots1);
            t_Sequence1 = NaN(1,n_dots1);
            rf_Sequence1 = NaN(1,n_dots1);
            gM1_Sequence1 = NaN(1,n_dots1);
            gM2_Sequence1 = NaN(1,n_dots1);
            gM3_Sequence1 = NaN(1,n_dots1);
            gM4_Sequence1 = NaN(1,n_dots1);
            gM5_Sequence1 = NaN(1,n_dots1);
            gM6_Sequence1 = NaN(1,n_dots1);
            fullPathString2 = TimepointInfoTable{slice2,1};
            SequenceString2 = TimepointInfoTable{slice2,2};
            [pathString2, ~, extString2] = fileparts(fullPathString2);
            fullFilePathInput2 = fullfile(pathString2,[SequenceString2 '_MULTIPLE_results' '.xls']);
            [num2,txt2,raw2] = xlsread(fullFilePathInput2,'Sheet1');
            n_dots2 = size(num2,1);
            i_minSequence2 = NaN(1,n_dots2);
            i_maxSequence2 = NaN(1,n_dots2);
            x_Sequence2 = NaN(1,n_dots2);
            y_Sequence2 = NaN(1,n_dots2);
            z_Sequence2 = NaN(1,n_dots2);
            t_Sequence2 = NaN(1,n_dots2);
            rf_Sequence2 = NaN(1,n_dots2);
            gM1_Sequence2 = NaN(1,n_dots2);
            gM2_Sequence2 = NaN(1,n_dots2);
            gM3_Sequence2 = NaN(1,n_dots2);
            gM4_Sequence2 = NaN(1,n_dots2);
            gM5_Sequence2 = NaN(1,n_dots2);
            gM6_Sequence2 = NaN(1,n_dots2);
            if size(num1,2) == 20
                for i = 1:size(num1,1)
                    if ~isnan(num1(i,1))
                        i_minSequence1(num1(i,1)) = num1(i,4);
                        i_maxSequence1(num1(i,1)) = num1(i,5);
                        x_Sequence1(num1(i,1)) = num1(i,6);
                        y_Sequence1(num1(i,1)) = num1(i,7);
                        z_Sequence1(num1(i,1)) = num1(i,8);
                        t_Sequence1(num1(i,1)) = num1(i,9);
                        rf_Sequence1(num1(i,1)) = num1(i,12);
                        gM1_Sequence1(num1(i,1)) = num1(i,15);
                        gM2_Sequence1(num1(i,1)) = num1(i,16);
                        gM3_Sequence1(num1(i,1)) = num1(i,17);
                        gM4_Sequence1(num1(i,1)) = num1(i,18);
                        gM5_Sequence1(num1(i,1)) = num1(i,19);
                        gM6_Sequence1(num1(i,1)) = num1(i,20);
                    end
                end
                for i = 1:size(num2,1)
                    if ~isnan(num2(i,1))
                        i_minSequence2(num2(i,1)) = num2(i,4);
                        i_maxSequence2(num2(i,1)) = num2(i,5);
                        x_Sequence2(num2(i,1)) = num2(i,6);
                        y_Sequence2(num2(i,1)) = num2(i,7);
                        z_Sequence2(num2(i,1)) = num2(i,8);
                        t_Sequence2(num2(i,1)) = num2(i,9);
                        rf_Sequence2(num2(i,1)) = num2(i,12);
                        gM1_Sequence2(num2(i,1)) = num2(i,15);
                        gM2_Sequence2(num2(i,1)) = num2(i,16);
                        gM3_Sequence2(num2(i,1)) = num2(i,17);
                        gM4_Sequence2(num2(i,1)) = num2(i,18);
                        gM5_Sequence2(num2(i,1)) = num2(i,19);
                        gM6_Sequence2(num2(i,1)) = num2(i,20);
                    end
                end
                for i = 1:size(num1,1)
                    if ~isnan(num1(i,1))
                        num_images1 = str2num(TimepointInfoTable{slice1,5});
                        fullPathstring1 = TimepointInfoTable{slice1,1};
                        SequenceString1 = TimepointInfoTable{slice1,2};
                        [pathString1, ~, extStringSeq1] = fileparts(fullPathstring1);
                        infoString1 = imfinfo(fullPathstring1);
                        SforZ1 = zeros(infoString1(1).Height, infoString1(1).Width, num_images1);
                        for j = 1:num_images1
                            SforZ1(:,:,j) = imread(fullfile(pathString1, [SequenceString1 extStringSeq1]),(t_Sequence1(i)-1)*num_images1+j, 'Info', infoString1);
                        end
                        B1 = SforZ1(y_Sequence1(i)-rf_Sequence1(i):y_Sequence1(i)+rf_Sequence1(i), x_Sequence1(i)-rf_Sequence1(i):x_Sequence1(i)+rf_Sequence1(i), :);
                        d1 = double(B1(1:rf_Sequence1(i)+rf_Sequence1(i)+1, 1:rf_Sequence1(i)+rf_Sequence1(i)+1, z_Sequence1(i)));
                        figure(hpgauss)
                        close(hpgauss)
                        hpgauss = figure('Name','FIT1','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,545,221,185]);
                        plotgaussfit_in_GUI([gM1_Sequence1(i) gM2_Sequence1(i) gM3_Sequence1(i) gM4_Sequence1(i) gM5_Sequence1(i) gM6_Sequence1(i)],d1,pSize,'n');
                        I_MAX = max([i_maxSequence1, i_maxSequence2]);
                        I_MIN = min([i_minSequence1, i_minSequence2]);
                        axis ([-rf_Sequence1(i)*pSize rf_Sequence1(i)*pSize -rf_Sequence1(i)*pSize rf_Sequence1(i)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        fullFilePathOutput1 = fullfile(pathString1,[SequenceString1 '_GAUSSIAN_FIT_spot_' num2str(i) '.tif']);
                        figure(hpgauss);
                        export_fig(fullFilePathOutput1,'-m2.5','-r300');
                        fullFilePathOutput1 = fullfile(pathString1,[SequenceString1 '_ZOOM_Z_spot_' num2str(i) '.tif']);
                        figure(hpzoom);
                        singleFrameZoom1 = SforZ1(y_Sequence1(i)-rf_Sequence1(i):y_Sequence1(i)+rf_Sequence1(i), x_Sequence1(i)-rf_Sequence1(i):x_Sequence1(i)+rf_Sequence1(i), z_Sequence1(i));
                        imshow(singleFrameZoom1,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        export_fig(fullFilePathOutput1,'-m2.5','-r300');
                    end
                end
                for i = 1:size(num2,1)
                    if ~isnan(num2(i,1))
                        num_images2 = str2num(TimepointInfoTable{slice2,5});
                        fullPathstring2 = TimepointInfoTable{slice2,1};
                        SequenceString2 = TimepointInfoTable{slice2,2};
                        [pathString2, ~, extStringSeq2] = fileparts(fullPathstring2);
                        infoString2 = imfinfo(fullPathstring2);
                        SforZ2 = zeros(infoString2(1).Height, infoString2(1).Width, num_images2);
                        for j = 1:num_images2
                            SforZ2(:,:,j) = imread(fullfile(pathString2, [SequenceString2 extStringSeq2]),(t_Sequence2(i)-1)*num_images2+j, 'Info', infoString2);
                        end
                        B2 = SforZ2(y_Sequence2(i)-rf_Sequence2(i):y_Sequence2(i)+rf_Sequence2(i), x_Sequence2(i)-rf_Sequence2(i):x_Sequence2(i)+rf_Sequence2(i), :);
                        d2 = double(B2(1:rf_Sequence2(i)+rf_Sequence2(i)+1, 1:rf_Sequence2(i)+rf_Sequence2(i)+1, z_Sequence2(i)));
                        figure(hpgauss2)
                        close(hpgauss2)
                        hpgauss2 = figure('Name','FIT2','numberTitle','off','Toolbar','figure',...
                            'Menubar','none','Position',[1116,245,221,185]);
                        plotgaussfit_in_GUI([gM1_Sequence2(i) gM2_Sequence2(i) gM3_Sequence2(i) gM4_Sequence2(i) gM5_Sequence2(i) gM6_Sequence2(i)],d2,pSize,'n');
                        I_MAX = max([i_maxSequence1, i_maxSequence2]);
                        I_MIN = min([i_minSequence1, i_minSequence2]);
                        axis ([-rf_Sequence2(i)*pSize rf_Sequence2(i)*pSize -rf_Sequence2(i)*pSize rf_Sequence2(i)*pSize 0 I_MAX]);
                        caxis ([I_MIN I_MAX]);
                        fullFilePathOutput2 = fullfile(pathString2,[SequenceString2 '_GAUSSIAN_FIT_spot_' num2str(i) '.tif']);
                        figure(hpgauss2);
                        export_fig(fullFilePathOutput2,'-m2.5','-r300');
                        fullFilePathOutput2 = fullfile(pathString2,[SequenceString2 '_ZOOM_Z_spot_' num2str(i) '.tif']);
                        figure(hpzoom2);
                        singleFrameZoom2 = SforZ2(y_Sequence2(i)-rf_Sequence2(i):y_Sequence2(i)+rf_Sequence2(i), x_Sequence2(i)-rf_Sequence2(i):x_Sequence2(i)+rf_Sequence2(i), z_Sequence2(i));
                        imshow(singleFrameZoom2,'DisplayRange',[minImg newMax],'InitialMagnification','fit')
                        export_fig(fullFilePathOutput2,'-m2.5','-r300');
                    end
                end
            end
            figure(hfig)
        end
    end

    function inputR_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
    end

    function inputStdmeanratio_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
    end

    function inputRf_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
        end
        rfSequence(slice) = input/2;
    end

    function inputFWHM_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0.5')
        end
        grid_size = ceil(input/pSize)*2;
        rfSequence(slice) = grid_size/2;
        set(hinputRf,'String',num2str(rfSequence(slice)*2));
    end

    function inputZset_Callback(hObject, eventdata, handles)
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','1')
        end
        if input > 0 && input <= num_images
            zSequence(slice) = input;
            set(slider3,'Value',input);
            slider3_Callback
        elseif input > num_images
            zSequence(slice) = num_images;
            set(slider3,'Value',num_images);
            slider3_Callback
        end
        figure(hfig);
    end

    function editDot_Callback(editDot,eventdata,handles)
        dot_number = str2num(get(editDot,'String'));
        set(editDot,'String',num2str(dot_number));
        set(himage,'ButtonDownFcn',@pixelInfo)
    end

    function pushEND_Callback(hObject, eventdata, handles)
        close(hfig);
        close(hpzoom);
        close(hpzoom2);
        close(hpgauss);
        close(hpgauss2);
    end

end