function [meanTFI, nSteps, prf, prf_fit, fOut] = dot_2D_single_v10(date,fname,psize,r,x,y,outputImg)
% Calculates MEAN and MAXIMUM TFI before the first photobleaching event
% for 2 and 3 bleaching events calculates the TFI difference between
% consecutive bleaching events

fullFilePath = fullfile(date,fname);
[~, name] = fileparts(fullFilePath);
[~, B] = dot_readsingle_3D_nomax(fullFilePath,x,y,r);
md = max(max(max(B)));
fld = min(min(min(B)));
[~, ~, wg, Cg] = gauss3d_v6(B, fld, md, 1, psize, r, 0, 0, 0, 0);
if wg > 0.6
    [~, ~, wg, Cg] = gauss3d_v6(B, fld, md, 1, psize, r-1, 0, 0, 0, 0);
end
[~, prf] = profile_stack(fullFilePath, x, y, 0);
nPrf = length(prf);
sprf = smooth(prf, 5, 'rlowess');
dsprf = diff(sprf);
[~, bStart] = sort(dsprf.*dsprf,'descend');
bStart1 = bStart(1);
bStart2 = bStart(2);
bStart3 = bStart(3);
timep = (1:length(sprf))';
maxProfile = max(sprf);
minProfile = min(sprf);
aStart1 = (maxProfile-minProfile)/2;
aStart2 = aStart1/2;
aStart3 = aStart1/3;
cStart = minProfile;
equation1 = 'a*(1-erf((timep-b)/s))+c';
ft1 = fittype(equation1,'dependent',{'sprf'},'independent',{'timep'},'coefficients',{'a','b','c','s'});
fo1 = fitoptions('method','NonlinearLeastSquares','Lower',[aStart1*0.5 1 cStart*0.5 0.01],'Upper',[aStart1*1.5 length(sprf) cStart*1.5 2],'Startpoint',[aStart1 bStart1 cStart 1]);
equation2 = 'a1*(1-erf((timep-b1)/s))+a2*(1-erf((timep-b2)/s))+c';
ft2 = fittype(equation2,'dependent',{'sprf'},'independent',{'timep'},'coefficients',{'a1','a2','b1','b2','c','s'});
fo2 = fitoptions('method','NonlinearLeastSquares','Lower',[aStart2*0.5 aStart2*0.5 1 4 cStart*0.5 0.01],'Upper',[aStart2*1.5 aStart2*1.5 length(sprf) length(sprf) cStart*1.5 3],'Startpoint',[aStart2 aStart2 bStart1 bStart2 cStart 1]);
equation3 = 'a1*(1-erf((timep-b1)/s))+a2*(1-erf((timep-b2)/s))+a3*(1-erf((timep-b3)/2))+c';
ft3 = fittype(equation3,'dependent',{'sprf'},'independent',{'timep'},'coefficients',{'a1','a2','a3','b1','b2','b3','c','s'});
fo3 = fitoptions('method','NonlinearLeastSquares','Lower',[aStart3*0.5 aStart3*0.5 aStart3*0.5 1 4 6 cStart*0.5 0.01],'Upper',[aStart3*1.5 aStart3*1.5 aStart3*1.5 length(sprf) length(sprf) length(sprf) cStart*1.5 2],'Startpoint',[aStart3 aStart3 aStart3 bStart1 bStart2 bStart3 cStart 1]);
[cf1, gof1] = fit(timep,sprf,ft1,fo1);
[cf2, gof2] = fit(timep,sprf,ft2,fo2);
[cf3, gof3] = fit(timep,sprf,ft3,fo3);
rsquares = [gof1.adjrsquare gof2.adjrsquare gof3.adjrsquare];
rmses = [gof1.rmse gof2.rmse gof3.rmse];
[s_rsquares, i_rsquares] = sort(rsquares,'descend');
if i_rsquares(1) == 3 && ((abs(cf3.b2-cf3.b1) < 6) || (abs(cf3.b3-cf3.b2) < 6) || (cf3.a1 < cf3.a2/2) || (cf3.a1 < cf3.a3/2) || (cf3.a2 < cf3.a1/2) || (cf3.a2 < cf3.a3/2) || (cf3.a3 < cf3.a1/2) || (cf3.a3 < cf3.a2/2))
    i_rsquares(1) = i_rsquares(2);
    s_rsquares(1) = s_rsquares(2);
elseif i_rsquares(1) == 3 && ((s_rsquares(2) < 0.90) || (cf2.a1 < cf2.a2/2) || (cf2.a2 < cf2.a1/2))
    i_rsquares(1) = i_rsquares(3);
    s_rsquares(1) = s_rsquares(3);
end
if i_rsquares(1) == 2 && ((abs(cf2.b2-cf2.b1) < 6) || (cf2.a1 < cf2.a2/2) || (cf2.a2 < cf2.a1/2))
    if i_rsquares(2) == 2 && i_rsquares(3) == 1
        i_rsquares(1) = i_rsquares(3);
        s_rsquares(1) = s_rsquares(3);
    elseif i_rsquares(2) == 1
        i_rsquares(1) = i_rsquares(2);
        s_rsquares(1) = s_rsquares(2);
    end
end
[vrsq, irsq] = max(rsquares);
[~, irms] = min(rmses);
fOut = [name sprintf('_X%d_Y%d__W%4.3f_R%4.3f',x,y,wg,vrsq)];
if (irsq == irms) && wg < 0.6
    if i_rsquares(1) == 1 && (s_rsquares(1) > 0.8)
        nSteps = 1;
        prf_fit = cf1(timep);
        k = round(cf1.b) - 1;
        lastValues = mean(prf_fit(k+2:nPrf)) - Cg;
        TFI_profile = zeros(nPrf);
        TFI = gauss3d_v6(B, fld, md, 1, psize, r,0,0,0,0);
        TFI_profile(1) = TFI;
        for i=2:nPrf
            [TFI , ~, wg] = gauss3d_v6(B, fld, md, i, psize, r,0,0,0,0);
            if wg > 0.6 || TFI > TFI_profile(1) * 3
                TFI = 0;
            end
            TFI_profile(i) = TFI;
        end
        meanTFI = mean(TFI_profile(1:k)) - mean(TFI_profile(k+2:nPrf));
        if lastValues < 0
            meanTFI = mean(TFI_profile(1:k));
        end
        if k == 0
            [meanTFI , ~, maxW] = gauss3d_v6(B, fld, md, 1, psize, r, 0,0,0,0);
            if maxW > 0.6
                meanTFI = 0;
            end
        end
    elseif i_rsquares(1) == 2 && (abs(cf2.b2-cf2.b1) > 6) && (s_rsquares(1) > 0.90)
        nSteps = 2;
        prf_fit = cf2(timep);
        k1 = round(cf2.b1) - 1;
        k2 = round(cf2.b2) - 1;
        kmin = min(k1,k2);
        kmax = max(k1,k2);
        k1end = kmin;
        if k1end == 0
            k1end = 1;
        end
        k2start = k1end + 2;
        k2end = kmax;
        lastValues = mean(prf_fit(k2end+2:nPrf)) - Cg;
        TFI_profile = zeros(nPrf);
        TFI = gauss3d_v6(B, fld, md, 1, psize, r,0,0,0,0);
        TFI_profile(1) = TFI;
        for i=2:nPrf
            [TFI , ~, wg] = gauss3d_v6(B, fld, md, i, psize, r,0,0,0,0);
            if wg > 0.6 || TFI > TFI_profile(1) * 3
                TFI = 0;
            end
            TFI_profile(i) = TFI;
        end
        meanTFI2_1 = mean(TFI_profile(1:k1end)) - mean(TFI_profile(k2start:k2end));
        meanTFI2_2 = mean(TFI_profile(k2start:k2end)) - mean(TFI_profile(k2end+2:nPrf));
        if lastValues < 0
            meanTFI2_2 = mean(TFI_profile(k2start:k2end));
        end
        meanTFI = [meanTFI2_1 meanTFI2_2];
    elseif i_rsquares(1) == 3 &&  (s_rsquares(1) > 0.95) && (abs(cf3.b2-cf3.b1) > 6) && (abs(cf3.b3-cf3.b2) > 6)
        nSteps = 3;
        prf_fit = cf3(timep);
        k1 = round(cf3.b1) - 1;
        k2 = round(cf3.b2) - 1;
        k3 = round(cf3.b3) - 1;
        ksort = sort([k1 k2 k3],'ascend');
        kmin = ksort(1);
        kmid = ksort(2);
        kmax = ksort(3);
        k1end = kmin;
        if k1end == 0
            k1end = 1;
        end
        k2start = k1end+2;
        k2end = kmid;
        k3start = k2end+2;
        k3end = kmax;
        lastValues = mean(prf_fit(k2end+2:nPrf)) - Cg;
        TFI_profile = zeros(nPrf);
        TFI = gauss3d_v6(B, fld, md, 1, psize, r,0,0,0,0);
        TFI_profile(1) = TFI;
        for i=2:nPrf
            [TFI , ~, wg] = gauss3d_v6(B, fld, md, i, psize, r,0,0,0,0);
            if wg > 0.6 || TFI > TFI_profile(1) * 3
                TFI = 0;
            end
            TFI_profile(i) = TFI;
        end
        meanTFI3_1 = mean(TFI_profile(1:k1end)) - mean(TFI_profile(k2start:k2end));
        meanTFI3_2 = mean(TFI_profile(k2start:k2end)) - mean(TFI_profile(k3start:k3end));
        meanTFI3_3 = mean(TFI_profile(k3start:k3end)) - mean(TFI_profile(k3end+2:nPrf));
        if lastValues < 0
            meanTFI3_3 = mean(TFI_profile(k3start:k3end));
        end
        meanTFI = [meanTFI3_1 meanTFI3_2 meanTFI3_3];
    else
        nSteps = 0;
        meanTFI = 0;
        prf_fit = prf;
        if outputImg == 1
            h0 = figure('Position',[1000 50 300 300]);
            plot(prf);
            fullFilePathJpg = fullfile(date,['FAIL - ' fOut '.jpg']);
            saveas(h0,fullFilePathJpg);
            close(h0)
        end
    end
else
    nSteps = 0;
    meanTFI = 0;
    prf_fit = prf;
    if outputImg == 1
        h0 = figure('Position',[1000 50 300 300]);
        plot(prf);
        fullFilePathJpg = fullfile(date,['FAIL - ' fOut '.jpg']);
        saveas(h0,fullFilePathJpg);
        close(h0)
    end
end
prf = prf - Cg;
prf_fit = prf_fit - Cg;